/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStatus;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.util.PolicyDecisionUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.locale.Locale;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpSession;

public final class AuthContextLocal
implements Serializable {
    private static final String amAuthContextLocal = "amAuthContextLocal";
    protected static Debug authDebug = Debug.getInstance((String)"amAuthContextLocal");
    protected static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"amAuthContextLocal");
    protected String organizationName;
    protected Set moduleInstanceNames;
    protected AuthContext.IndexType indexType;
    protected String indexName;
    protected AuthContext.Status loginStatus;
    protected String hostName;
    protected HttpSession httpSession;
    protected SSOToken ssoToken;
    protected volatile AuthLoginException loginException = null;
    protected Callback[] informationRequired = null;
    public AMLoginContext amlc = null;
    public LoginStatus ls;
    protected Subject subject;
    protected char[] password;
    private LoginState loginState = null;
    private String orgDN = null;
    private boolean inSubmitRequirements = false;
    public static final String LDAP_AUTH_URL = "ldap://";
    public static final String PCOOKIE = "pCookieMode";
    public static final String PRINCIPAL = "principal";
    public static final String PASSWORD = "password";
    public static final String SUBJECT = "subject";
    public static final String INDEX_TYPE = "indexType";
    public static final String INDEX_NAME = "indexName";
    public static final String LOCALE = "locale";
    public static final String REDIRECT_URL = "redirectionURL";

    public AuthContextLocal(String orgName) {
        authDebug.message("AuthContextLocal() constructor called");
        this.organizationName = orgName;
        this.amlc = new AMLoginContext(this);
        if (authDebug.messageEnabled()) {
            authDebug.message("AMLoginContext object is... " + this.amlc);
        }
        this.reset();
    }

    public Set getModuleInstanceNames() {
        this.moduleInstanceNames = this.amlc.getModuleInstanceNames();
        return this.moduleInstanceNames;
    }

    public void login() throws AuthLoginException {
        this.login(null);
    }

    public void login(Principal principal, char[] password) throws AuthLoginException {
        if (principal == null) {
            throw new AuthLoginException(amAuthContextLocal, "invalid-username", null);
        }
        if (password == null) {
            throw new AuthLoginException(amAuthContextLocal, "invalid-password", null);
        }
        this.password = password;
        this.login(null, null, principal, password, null, false);
    }

    public void login(AuthContext.IndexType type, String indexName) throws AuthLoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal::login() called with IndexType : " + type + " & Indexname : " + indexName);
        }
        this.login(type, indexName, null, null, null, false);
    }

    public void login(Subject subject) throws AuthLoginException {
        this.login(null, null, null, null, subject, false);
    }

    public void login(AuthContext.IndexType type, String indexName, String locale) throws AuthLoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal::login() called with IndexType : " + type + " & Indexname : " + indexName + " & locale : " + locale);
        }
        this.login(type, indexName, null, null, null, false, null, locale);
    }

    public void login(AuthContext.IndexType type, String indexName, boolean pCookieMode) throws AuthLoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal::login() called with IndexType : " + type + " & Indexname : " + indexName + " & pCookieMode : " + pCookieMode);
        }
        this.login(type, indexName, null, null, null, pCookieMode);
    }

    public void login(AuthContext.IndexType type, String indexName, boolean pCookieMode, String locale) throws AuthLoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal::login() called with IndexType : " + type + " & Indexname : " + indexName + " & pCookieMode : " + pCookieMode + " & locale : " + locale);
        }
        this.login(type, indexName, null, null, null, pCookieMode, null, locale);
    }

    public void login(AuthContext.IndexType type, String indexName, boolean pCookieMode, Map envMap, String locale) throws AuthLoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal::login() called with IndexType : " + type + " & Indexname : " + indexName + " & pCookieMode : " + pCookieMode + " & locale : " + locale + " & envMap : " + envMap);
        }
        this.login(type, indexName, null, null, null, pCookieMode, envMap, locale);
    }

    protected void login(AuthContext.IndexType type, String indexName, Principal principal, char[] password, Subject subject, boolean pCookieMode) throws AuthLoginException {
        this.login(type, indexName, principal, password, subject, pCookieMode, null, null);
    }

    protected void login(AuthContext.IndexType type, String indexName, Principal principal, char[] password, Subject subject, boolean pCookieMode, Map envMap, String locale) throws AuthLoginException {
        try {
            this.loginStatus = AuthContext.Status.IN_PROGRESS;
            String redirectUrl = null;
            if (type != null && type.equals(AuthContext.IndexType.RESOURCE)) {
                List result = Collections.EMPTY_LIST;
                try {
                    result = PolicyDecisionUtils.doResourceIPEnvAuth(indexName, this.organizationName, envMap);
                }
                catch (PolicyException pe) {
                    authDebug.warning("AuthContextLocal.login() policy error indexName=" + indexName, (Throwable)pe);
                    type = null;
                    indexName = null;
                }
                if (authDebug.messageEnabled()) {
                    authDebug.message("AuthContextLocal.login: policy decision=" + result);
                }
                if (result.size() == 2) {
                    type = (AuthContext.IndexType)result.get(0);
                    indexName = (String)result.get(1);
                } else if (result.size() == 1) {
                    String gotoParam;
                    redirectUrl = (String)result.get(0);
                    Set tmp = (Set)envMap.get("goto");
                    if (tmp != null && !tmp.isEmpty() && (gotoParam = (String)tmp.iterator().next()) != null && gotoParam.length() != 0) {
                        redirectUrl = redirectUrl != null && redirectUrl.indexOf("?") != -1 ? redirectUrl + "&" + "goto" + "=" + URLEncDec.encode((String)gotoParam) : redirectUrl + "?" + "goto" + "=" + URLEncDec.encode((String)gotoParam);
                    }
                    type = null;
                    indexName = null;
                } else {
                    type = null;
                    indexName = null;
                }
            }
            HashMap<String, Object> loginParamsMap = new HashMap<String, Object>();
            loginParamsMap.put(INDEX_TYPE, type);
            loginParamsMap.put(INDEX_NAME, indexName);
            loginParamsMap.put(PRINCIPAL, principal);
            loginParamsMap.put(PASSWORD, password);
            loginParamsMap.put(SUBJECT, subject);
            loginParamsMap.put(PCOOKIE, pCookieMode);
            loginParamsMap.put(LOCALE, locale);
            if (redirectUrl != null) {
                loginParamsMap.put(REDIRECT_URL, redirectUrl);
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("loginParamsMap : " + loginParamsMap.toString());
            }
            authDebug.message("calling AMLoginContext::exceuteLogin : ");
            this.amlc.executeLogin(loginParamsMap);
            authDebug.message("after AMLoginContext::exceuteLogin : ");
            if (this.amlc.getStatus() == 3) {
                this.loginStatus = AuthContext.Status.SUCCESS;
            } else if (this.amlc.getStatus() == 4) {
                this.loginStatus = AuthContext.Status.FAILED;
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Status at the end of login() : " + this.loginStatus);
            }
        }
        catch (AuthLoginException e) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Exception in ac.login : " + e.toString());
            }
            throw e;
        }
    }

    public void reset() {
        authDebug.message("AuthContextLocal::reset() called");
        this.loginStatus = AuthContext.Status.NOT_STARTED;
        this.informationRequired = null;
        this.loginException = null;
    }

    public Subject getSubject() {
        if (!this.loginStatus.equals(AuthContext.Status.SUCCESS)) {
            return null;
        }
        if (this.subject == null) {
            this.subject = this.amlc.getSubject();
        }
        return this.subject;
    }

    public boolean hasMoreRequirements() {
        authDebug.message("AuthContextLocal::hasMoreRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return false;
        }
        this.informationRequired = this.amlc.getRequiredInfo();
        return this.informationRequired != null;
    }

    public boolean hasMoreRequirements(boolean noFilter) {
        authDebug.message("AuthContextLocal::hasMoreRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return false;
        }
        this.informationRequired = this.amlc.getRequiredInfo();
        return AuthContextLocal.getCallbacks(this.informationRequired, noFilter) != null;
    }

    public Callback[] getRequirements() {
        authDebug.message("AuthContextLocal::getRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return null;
        }
        return this.informationRequired;
    }

    public Callback[] getRequirements(boolean noFilter) {
        authDebug.message("AuthContextLocal::getRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return null;
        }
        return AuthContextLocal.getCallbacks(this.informationRequired, noFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequirements(Callback[] info) {
        authDebug.message("AuthContextLocal::submitRequirements()");
        this.inSubmitRequirements = true;
        try {
            this.informationRequired = null;
            this.amlc.submitRequiredInfo(info);
            if (!this.amlc.isPureJAAS()) {
                this.amlc.runLogin();
            }
            if (this.amlc.getStatus() == 3) {
                this.loginStatus = AuthContext.Status.SUCCESS;
            } else if (this.amlc.getStatus() == 4) {
                this.loginStatus = AuthContext.Status.FAILED;
            }
            authDebug.message("AuthContextLocal::submitRequirements end");
            if (authDebug.messageEnabled()) {
                authDebug.message("Status at the end of submitRequirements() : " + this.loginStatus);
            }
        }
        finally {
            this.inSubmitRequirements = false;
        }
    }

    public void logout() throws AuthLoginException {
        authDebug.message("AuthContextLocal::logout()");
        try {
            this.amlc.logout();
        }
        catch (Exception e) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Exception in AMLoginContext::logout() " + e.getMessage());
            }
            throw new AuthLoginException(amAuthContextLocal, "logoutError", null, e);
        }
        authDebug.message("Called AMLoginContext::logout()");
        this.loginStatus = AuthContext.Status.COMPLETED;
    }

    public AuthLoginException getLoginException() {
        authDebug.message("AuthContextLocal::getLoginException()");
        return this.loginException;
    }

    public void setLoginException(AuthLoginException exception) {
        this.loginException = exception;
    }

    public AuthContext.Status getStatus() {
        authDebug.message("AuthContextLocal::getStatus()");
        if (this.amlc.getStatus() == 3) {
            this.loginStatus = AuthContext.Status.SUCCESS;
        } else if (this.amlc.getStatus() == 4) {
            this.loginStatus = AuthContext.Status.FAILED;
        } else if (this.amlc.getStatus() == 7) {
            this.loginStatus = AuthContext.Status.RESET;
        } else if (this.amlc.getStatus() == 8) {
            this.loginStatus = AuthContext.Status.ORG_MISMATCH;
        } else if (this.amlc.getStatus() == 2) {
            this.loginStatus = AuthContext.Status.IN_PROGRESS;
        } else if (this.amlc.getStatus() == 5) {
            this.loginStatus = AuthContext.Status.COMPLETED;
        }
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal:: Status : " + this.loginStatus);
        }
        return this.loginStatus;
    }

    protected void setLoginStatus(AuthContext.Status status) {
        authDebug.message("AuthContextLocal::setLoginStatus()");
        this.loginStatus = status;
    }

    public SSOToken getSSOToken() {
        this.ssoToken = this.amlc.getSSOToken();
        return this.ssoToken;
    }

    public String getSuccessURL() {
        return this.amlc.getSuccessURL();
    }

    public String getFailureURL() {
        return this.amlc.getFailureURL();
    }

    public String getOrganizationName() {
        return this.amlc.getOrganizationName();
    }

    public void abort() throws AuthLoginException {
        authDebug.message("AuthContextLocal::abort()");
        try {
            this.amlc.abort();
        }
        catch (Exception e) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Exception in AMLoginContext::abort() " + e.getMessage());
            }
            throw new AuthLoginException(amAuthContextLocal, "abortError", null, e);
        }
        this.loginStatus = AuthContext.Status.COMPLETED;
    }

    public String getErrorTemplate() {
        return this.amlc.getErrorTemplate();
    }

    public String getErrorMessage() {
        return this.amlc.getErrorMessage();
    }

    public String getErrorCode() {
        return this.amlc.getErrorCode();
    }

    public String getAuthIdentifier() {
        return this.amlc.getAuthIdentifier();
    }

    public String getLockoutMsg() {
        String lockoutMsg = this.amlc.getLockoutMsg();
        if (authDebug.messageEnabled()) {
            authDebug.message("getLockoutMsg: lockoutMsg: " + lockoutMsg);
        }
        return lockoutMsg;
    }

    public boolean isLockedOut() {
        boolean isLockedOut = this.amlc.isLockedOut();
        if (authDebug.messageEnabled()) {
            authDebug.message("isLockedOut : " + isLockedOut);
        }
        return isLockedOut;
    }

    public void setClientHostName(String hostname) {
        this.hostName = hostname;
    }

    protected String getClientHostName() {
        return this.hostName;
    }

    public boolean submittedRequirements() {
        return this.inSubmitRequirements;
    }

    public void setHttpSession(HttpSession session) {
        this.httpSession = session;
    }

    protected HttpSession getHttpSession() {
        return this.httpSession;
    }

    protected static Callback[] getCallbacks(Callback[] recdCallbacks, boolean noFilter) {
        if (recdCallbacks == null) {
            return null;
        }
        if (noFilter) {
            return recdCallbacks;
        }
        Callback[] answer = new Callback[]{};
        ArrayList<Callback> callbackList = new ArrayList<Callback>();
        for (int i = 0; i < recdCallbacks.length; ++i) {
            if (authDebug.messageEnabled()) {
                authDebug.message("In getCallbacks() callback : " + recdCallbacks[i]);
            }
            if (recdCallbacks[i] instanceof PagePropertiesCallback) continue;
            callbackList.add(recdCallbacks[i]);
        }
        return callbackList.toArray(answer);
    }

    public void setLoginState(LoginState state) {
        this.loginState = state;
    }

    public LoginState getLoginState() {
        return this.loginState;
    }

    public void setOrgDN(String orgDN) {
        this.orgDN = orgDN;
    }

    public String getOrgDN() {
        return this.orgDN;
    }
}

