/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy.model;

import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.console.base.model.QueryResults;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyCache;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.console.property.PolicyPropertyXMLBuilder;
import com.sun.identity.console.property.ResponseProviderXMLBuilder;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ResponseProviderTypeManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PolicyModelImpl
extends AMModelBase
implements PolicyModel {
    private ServiceTypeManager svcTypeMgr = null;
    private Map mapSvcTypeNameToActions = null;
    private Map mapSvcTypeNameToResBundle = null;
    private Map mapSvcNameToManagedResource = new HashMap();
    private Set requiredResourceNameService = new HashSet();
    private Set notRequiredResourceNameService = new HashSet();
    private static SSOToken adminSSOToken = AMAdminUtils.getSuperAdminSSOToken();

    public PolicyModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    private PolicyManager getPolicyManager(String realmName) throws AMConsoleException {
        if (realmName == null || realmName.length() == 0) {
            realmName = this.getStartDN();
        }
        try {
            return new PolicyManager(this.getUserSSOToken(), realmName);
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getPolicyManager", (Throwable)((Object)e));
            throw new AMConsoleException((Throwable)((Object)e));
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getPolicyManager", (Throwable)e);
            throw new AMConsoleException(e);
        }
    }

    private ServiceTypeManager getServiceTypeManager() throws AMConsoleException {
        if (this.svcTypeMgr == null) {
            try {
                this.svcTypeMgr = new ServiceTypeManager(this.getUserSSOToken());
            }
            catch (SSOException ssoe) {
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)ssoe)));
            }
        }
        return this.svcTypeMgr;
    }

    public CachedPolicy getCachedPolicy(String cacheID) throws AMConsoleException {
        PolicyCache cache = PolicyCache.getInstance();
        return cache.getPolicy(this.getUserSSOToken(), cacheID);
    }

    public String cachePolicy(String policyName, String description, boolean isReferral, boolean isActive) throws AMConsoleException {
        try {
            Policy policy = new Policy(policyName, description, isReferral, isActive);
            PolicyCache cache = PolicyCache.getInstance();
            return cache.cachePolicy(this.getUserSSOToken(), new CachedPolicy(policy));
        }
        catch (InvalidNameException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public String cachePolicy(String realmName, String policyName) throws AMConsoleException {
        try {
            PolicyManager policyManager = this.getPolicyManager(realmName);
            Policy policy = policyManager.getPolicy(policyName);
            PolicyCache cache = PolicyCache.getInstance();
            return cache.cachePolicy(this.getUserSSOToken(), new CachedPolicy(policy));
        }
        catch (InvalidFormatException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (InvalidNameException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (NoPermissionException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (NameNotFoundException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (PolicyException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Set getPolicyNames(String realmName, String filter) throws AMConsoleException {
        Set names = null;
        try {
            String[] param = new String[]{realmName};
            this.logEvent("ATTEMPT_GET_POLICY_NAMES", param);
            PolicyManager policyManager = this.getPolicyManager(realmName);
            names = policyManager.getPolicyNames(filter);
            this.logEvent("SUCCEED_GET_POLICY_NAMES", param);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] params = new String[]{realmName, strError};
            this.logEvent("SSO_EXCEPTION_GET_POLICY_NAMES", params);
            throw new AMConsoleException(strError);
        }
        catch (PolicyException e) {
            String strError = this.getErrorString(e);
            String[] params = new String[]{realmName, strError};
            this.logEvent("POLICY_EXCEPTION_GET_POLICY_NAMES", params);
            throw new AMConsoleException(strError);
        }
        return names != null ? names : Collections.EMPTY_SET;
    }

    public void createPolicy(String realmName, Policy policy) throws AMConsoleException {
        try {
            String[] params = new String[]{realmName, policy.getName()};
            this.logEvent("ATTEMPT_CREATE_POLICY", params);
            PolicyManager policyManager = this.getPolicyManager(realmName);
            policyManager.addPolicy(policy);
            this.logEvent("SUCCEED_CREATE_POLICY", params);
        }
        catch (PolicyException e) {
            String strError = this.getErrorString(e);
            String[] params = new String[]{realmName, policy.getName(), strError};
            this.logEvent("POLICY_EXCEPTION_CREATE_POLICY", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] params = new String[]{realmName, policy.getName(), strError};
            this.logEvent("SSO_EXCEPTION_CREATE_POLICY", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void replacePolicy(String realmName, Policy policy) throws AMConsoleException {
        try {
            String[] params = new String[]{realmName, policy.getName()};
            this.logEvent("ATTEMPT_MODIFY_POLICY", params);
            PolicyManager policyManager = this.getPolicyManager(realmName);
            policyManager.replacePolicy(policy);
            this.logEvent("SUCCEED_MODIFY_POLICY", params);
        }
        catch (PolicyException e) {
            String strError = this.getErrorString(e);
            String[] params = new String[]{realmName, policy.getName(), strError};
            this.logEvent("POLICY_EXCEPTION_MODIFY_POLICY", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] params = new String[]{realmName, policy.getName(), strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_POLICY", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void deletePolicies(String realmName, Set names) throws AMConsoleException {
        PolicyManager policyManager = this.getPolicyManager(realmName);
        ArrayList<String> unableToDelete = new ArrayList<String>(names.size());
        String[] params = new String[2];
        params[0] = realmName;
        String[] paramsEx = new String[3];
        paramsEx[0] = realmName;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name;
            params[1] = name = (String)iter.next();
            try {
                this.logEvent("ATTEMPT_DELETE_POLICY", params);
                policyManager.removePolicy(name);
                this.logEvent("SUCCEED_DELETE_POLICY", params);
            }
            catch (PolicyException e) {
                paramsEx[1] = name;
                paramsEx[2] = this.getErrorString(e);
                this.logEvent("POLICY_EXCEPTION_DELETE_POLICY", params);
                debug.warning("PolicyModelImpl.deletePolicies", (Throwable)e);
                unableToDelete.add(name);
            }
            catch (SSOException e) {
                paramsEx[1] = name;
                paramsEx[2] = this.getErrorString((Throwable)((Object)e));
                this.logEvent("SSO_EXCEPTION_DELETE_POLICY", params);
                debug.warning("PolicyModelImpl.deletePolicies", (Throwable)((Object)e));
                unableToDelete.add(name);
            }
        }
        if (!unableToDelete.isEmpty()) {
            Object[] p = unableToDelete.toArray();
            String msg = MessageFormat.format("policy.message.unableToDeletePolicies", p);
            throw new AMConsoleException(msg);
        }
    }

    public boolean canCreateRule(Policy policy, String realmName) {
        this.getSvcTypeNameToActionsMap(policy, realmName);
        return !this.requiredResourceNameService.isEmpty() || !this.notRequiredResourceNameService.isEmpty();
    }

    public Map getServiceTypeNames() {
        HashMap<String, String> map = null;
        try {
            Set types = this.getServiceTypeManager().getServiceTypeNames();
            if (types != null && !types.isEmpty()) {
                map = new HashMap<String, String>(types.size() * 2);
                for (String name : types) {
                    String lname = this.getLocalizedServiceName(name, null);
                    if (lname == null) continue;
                    map.put(name, lname);
                }
            }
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getServiceTypeNames", (Throwable)((Object)e));
        }
        catch (NoPermissionException e) {
            debug.warning("PolicyModelImpl.getServiceTypeNames", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getServiceTypeNames", (Throwable)e);
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public Set getActionSchemas(Policy policy, String realmName, String name, boolean withResourceName) {
        HashSet<ActionSchema> actions = null;
        Map map = this.getSvcTypeNameToActionsMap(policy, realmName);
        Set actionSchemas = (Set)map.get(name);
        if (actionSchemas != null && !actionSchemas.isEmpty()) {
            actions = new HashSet<ActionSchema>(actionSchemas.size() * 2);
            for (ActionSchema as : actionSchemas) {
                if (withResourceName) {
                    if (!as.requiresResourceName()) continue;
                    actions.add(as);
                    continue;
                }
                if (as.requiresResourceName()) continue;
                actions.add(as);
            }
        }
        return actions != null ? actions : Collections.EMPTY_SET;
    }

    public String getActionSchemaLocalizedName(String name, ActionSchema actionSchema) {
        ResourceBundle rb = (ResourceBundle)this.mapSvcTypeNameToResBundle.get(name);
        return Locale.getString((ResourceBundle)rb, (String)actionSchema.getI18NKey(), (Debug)debug);
    }

    public OptionList getChoiceValues(String name, ActionSchema actionSchema) {
        ResourceBundle rb = (ResourceBundle)this.mapSvcTypeNameToResBundle.get(name);
        OptionList optList = null;
        AttributeSchema.Syntax syntax = actionSchema.getSyntax();
        AttributeSchema.UIType uiType = actionSchema.getUIType();
        optList = uiType != null && uiType == AttributeSchema.UIType.RADIO ? (syntax == AttributeSchema.Syntax.BOOLEAN ? this.getAttrRadioBooleanChoiceValue(actionSchema, rb) : this.getAttrChoiceValue(actionSchema, rb)) : this.getAttrChoiceValue(actionSchema, rb);
        return optList;
    }

    public boolean requiredResourceName(Policy policy, String realmName, String name) {
        this.getSvcTypeNameToActionsMap(policy, realmName);
        return this.requiredResourceNameService.contains(name);
    }

    public boolean notRequiredResourceName(Policy policy, String realmName, String name) {
        this.getSvcTypeNameToActionsMap(policy, realmName);
        return this.notRequiredResourceNameService.contains(name);
    }

    private OptionList getAttrRadioBooleanChoiceValue(ActionSchema actionSchema, ResourceBundle rb) {
        String label;
        OptionList optionList = new OptionList();
        String trueValue = actionSchema.getTrueValue();
        String falseValue = actionSchema.getFalseValue();
        if (trueValue == null) {
            trueValue = "true";
        }
        if (falseValue == null) {
            falseValue = "false";
        }
        String trueI18nKey = actionSchema.getTrueValueI18NKey();
        String falseI18nKey = actionSchema.getFalseValueI18NKey();
        if (trueI18nKey != null) {
            label = Locale.getString((ResourceBundle)rb, (String)trueI18nKey, (Debug)debug);
            if (label == null || label.length() == 0) {
                optionList.add(trueValue, trueValue);
            } else {
                optionList.add(label, trueValue);
            }
        } else {
            optionList.add(trueValue, trueValue);
        }
        if (falseI18nKey != null) {
            label = Locale.getString((ResourceBundle)rb, (String)falseI18nKey, (Debug)debug);
            if (label == null || label.length() == 0) {
                optionList.add(falseValue, falseValue);
            } else {
                optionList.add(label, falseValue);
            }
        } else {
            optionList.add(falseValue, falseValue);
        }
        return optionList;
    }

    private OptionList getAttrChoiceValue(ActionSchema actionSchema, ResourceBundle rb) {
        OptionList optionList = new OptionList();
        String[] choices = actionSchema.getChoiceValues();
        for (int i = 0; i < choices.length; ++i) {
            String choice = choices[i];
            String i18nKey = actionSchema.getChoiceValueI18NKey(choice);
            String lname = Locale.getString((ResourceBundle)rb, (String)i18nKey, (Debug)debug);
            if (lname == null || lname.length() == 0) {
                lname = i18nKey;
            }
            optionList.add(lname, choice);
        }
        return optionList;
    }

    private Map getSvcTypeNameToActionsMap(Policy policy, String realmName) {
        if (this.mapSvcTypeNameToActions == null) {
            try {
                Set serviceTypeNames = this.getServiceTypeNames().keySet();
                int sz = serviceTypeNames.size();
                this.mapSvcTypeNameToActions = new HashMap(sz * 2);
                this.mapSvcTypeNameToResBundle = new HashMap(sz * 2);
                ServiceTypeManager mgr = this.getServiceTypeManager();
                for (String serviceTypeName : serviceTypeNames) {
                    ResourceBundle rb;
                    ServiceType serviceType = mgr.getServiceType(serviceTypeName);
                    if (serviceType == null || (rb = this.getResourceBundle(serviceType, this.getUserLocale())) == null) continue;
                    this.mapSvcTypeNameToResBundle.put(serviceTypeName, rb);
                    Set as = this.getActionSchemas(serviceType);
                    this.filterActionSchemaWithI18nKey(as);
                    if (as == null || as.isEmpty()) continue;
                    this.mapSvcTypeNameToActions.put(serviceTypeName, as);
                    if (this.requiresResourceName(policy, realmName, serviceTypeName, as, true)) {
                        this.requiredResourceNameService.add(serviceTypeName);
                    }
                    if (!this.requiresResourceName(policy, realmName, serviceTypeName, as, false)) continue;
                    this.notRequiredResourceNameService.add(serviceTypeName);
                }
            }
            catch (AMConsoleException e) {
                debug.warning("PolicyModelImppl.getSvcTypeNameToActionsMap", (Throwable)e);
            }
            catch (SSOException e) {
                debug.warning("PolicyModelImppl.getSvcTypeNameToActionsMap", (Throwable)((Object)e));
            }
            catch (NameNotFoundException e) {
                debug.warning("PolicyModelImppl.getSvcTypeNameToActionsMap", (Throwable)e);
            }
        }
        return this.mapSvcTypeNameToActions;
    }

    private boolean requiresResourceName(Policy policy, String realmName, String serviceTypeName, Set actionSchemas, boolean required) {
        if (realmName == null || realmName.trim().length() == 0) {
            realmName = this.getStartDN();
        }
        boolean yes = false;
        Iterator iter = actionSchemas.iterator();
        while (iter.hasNext() && !yes) {
            ActionSchema as = (ActionSchema)iter.next();
            yes = as.requiresResourceName() == required;
        }
        if (required) {
            if (yes) {
                yes = this.canCreateNewResource(realmName, serviceTypeName) || !this.getManagedResources(realmName, serviceTypeName).isEmpty();
            }
        } else if (yes) {
            Set ruleWithoutRes = this.getRuleNamesWithoutRes(policy, serviceTypeName);
            yes = ruleWithoutRes.isEmpty() ? realmName.equals("/") || !this.getManagedResources(realmName, serviceTypeName).isEmpty() : false;
        }
        return yes;
    }

    private Set getRuleNamesWithoutRes(Policy policy, String serviceTypeName) {
        Set rules = this.getRules(policy);
        HashSet<String> selected = new HashSet<String>(rules.size() * 2);
        for (Rule rule : rules) {
            String res;
            if (!rule.getServiceTypeName().equals(serviceTypeName) || (res = rule.getResourceName()) != null) continue;
            selected.add(rule.getName());
        }
        return selected;
    }

    private Set getRules(Policy policy) {
        HashSet<Rule> rules = null;
        Set ruleNames = policy.getRuleNames();
        if (ruleNames != null && !ruleNames.isEmpty()) {
            rules = new HashSet<Rule>(ruleNames.size() * 2);
            for (String name : ruleNames) {
                try {
                    rules.add(policy.getRule(name));
                }
                catch (NameNotFoundException e) {
                    debug.warning("PolicyModelImpl.getRules", (Throwable)e);
                }
            }
        }
        return rules != null ? rules : Collections.EMPTY_SET;
    }

    public boolean canCreateNewResource(String realmName, String svcTypeName) {
        boolean can = false;
        try {
            ResourceManager resMgr;
            PolicyManager mgr = this.getPolicyManager(realmName);
            if (mgr != null && (resMgr = mgr.getResourceManager()) != null) {
                try {
                    can = resMgr.canCreateNewResource(svcTypeName);
                }
                catch (PolicyException e) {
                    debug.warning("PolicyModelImpl.canCreateNewResource", (Throwable)e);
                }
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.canCreateNewResource", (Throwable)e);
        }
        return can;
    }

    public List getManagedResources(String realmName, String serviceTypeName) {
        List managedResources = (List)this.mapSvcNameToManagedResource.get(serviceTypeName);
        if (managedResources == null) {
            managedResources = Collections.EMPTY_LIST;
            try {
                Set resources;
                PolicyManager mgr = this.getPolicyManager(realmName);
                if (mgr != null && (resources = mgr.getManagedResourceNames(serviceTypeName)) != null && !resources.isEmpty()) {
                    managedResources = AMFormatUtils.sortItems(resources, this.getUserLocale());
                }
            }
            catch (PolicyException e) {
                debug.warning("PolicyModelImpl.getManagedResources", (Throwable)e);
            }
            catch (AMConsoleException e) {
                debug.warning("PolicyModelImpl.getManagedResources", (Throwable)e);
            }
            this.mapSvcNameToManagedResource.put(serviceTypeName, managedResources);
        }
        return managedResources;
    }

    private void filterActionSchemaWithI18nKey(Set actionSchemas) {
        if (actionSchemas != null && !actionSchemas.isEmpty()) {
            Iterator iter = actionSchemas.iterator();
            while (iter.hasNext()) {
                ActionSchema as = (ActionSchema)iter.next();
                String i18nKey = as.getI18NKey();
                if (i18nKey != null && i18nKey.trim().length() != 0) continue;
                iter.remove();
            }
        }
    }

    private ResourceBundle getResourceBundle(ServiceType type, java.util.Locale locale) {
        String fileName = type.getI18NPropertiesFileName();
        return fileName != null && fileName.length() > 0 ? AMResBundleCacher.getBundle(fileName, locale) : null;
    }

    private Set getActionSchemas(ServiceType svcType) {
        HashSet<ActionSchema> actionSchemas = null;
        Set actionNames = svcType.getActionNames();
        if (actionNames != null && !actionNames.isEmpty()) {
            actionSchemas = new HashSet<ActionSchema>(actionNames.size() * 2);
            for (String name : actionNames) {
                ActionSchema as = this.getActionSchema(svcType, name);
                if (as == null || !this.isActionSchemaSupported(as)) continue;
                actionSchemas.add(as);
            }
        }
        return actionSchemas;
    }

    private ActionSchema getActionSchema(ServiceType svcType, String name) {
        ActionSchema schema = null;
        try {
            schema = svcType.getActionSchema(name);
        }
        catch (InvalidNameException e) {
            debug.warning("PolicyModelImpl.getActionSchema", (Throwable)e);
        }
        return schema;
    }

    private boolean isActionSchemaSupported(ActionSchema actionSchema) {
        int attrSyntax = AMDisplayType.getDisplaySyntax(actionSchema);
        return attrSyntax != 7 && attrSyntax != 8;
    }

    public Map getActiveReferralTypes(String realmName) {
        HashMap<String, String> referralTypes = null;
        try {
            ReferralTypeManager referralTypeMgr;
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null && (referralTypeMgr = policyMgr.getReferralTypeManager()) != null) {
                Set types = referralTypeMgr.getSelectedReferralTypeNames();
                referralTypes = new HashMap<String, String>(types.size() * 2);
                for (String rName : types) {
                    Syntax syntax;
                    Referral referral = referralTypeMgr.getReferral(rName);
                    if (referral == null || (syntax = referral.getValueSyntax(this.getUserSSOToken())).equals(Syntax.NONE)) continue;
                    referralTypes.put(rName, referralTypeMgr.getDisplayName(rName));
                }
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getActiveReferralTypes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getActiveReferralTypes", (Throwable)((Object)e));
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getActiveReferralTypes", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getActiveReferralTypes", (Throwable)e);
        }
        return referralTypes == null ? Collections.EMPTY_MAP : referralTypes;
    }

    public Syntax getReferralSyntax(String realmName, String referralType) {
        Syntax syntax = Syntax.NONE;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ReferralTypeManager referralTypeMgr = policyMgr.getReferralTypeManager();
                Referral referral = referralTypeMgr.getReferral(referralType);
                syntax = referral.getValueSyntax(this.getUserSSOToken());
            }
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getActiveReferralTypes", (Throwable)((Object)e));
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getActiveReferralTypes", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getActiveReferralTypes", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getReferralActionSchema", (Throwable)e);
        }
        return syntax;
    }

    public Referral createReferral(String realmName, String referralType, Set values) throws AMConsoleException {
        Referral referral = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ReferralTypeManager referralTypeMgr = policyMgr.getReferralTypeManager();
                referral = referralTypeMgr.getReferral(referralType);
                referral.setValues(values);
            }
        }
        catch (NameNotFoundException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (PolicyException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        return referral;
    }

    public ValidValues getReferralPossibleValues(String realmName, String referralType, String filter) {
        ValidValues values = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ReferralTypeManager referralTypeMgr = policyMgr.getReferralTypeManager();
                Referral referral = referralTypeMgr.getReferral(referralType);
                values = referral.getValidValues(this.getUserSSOToken(), filter);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getReferralPossibleValues", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getReferralPossibleValues", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getReferralPossibleValues", (Throwable)((Object)e));
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getReferralPossibleValues", (Throwable)e);
        }
        return values;
    }

    public String getReferralViewBeanURL(String realmName, String referralTypeName) {
        String url = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ReferralTypeManager referralTypeMgr = policyMgr.getReferralTypeManager();
                Referral referral = referralTypeMgr.getReferral(referralTypeName);
                url = referralTypeMgr.getViewBeanURL(referral);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getReferralViewBeanURL", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getReferralViewBeanURL", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getReferralViewBeanURL", (Throwable)e);
        }
        return url;
    }

    public Map getDisplayNameForReferralValues(String realmName, String referralTypeName, Set values) {
        HashMap<String, String> map = null;
        if (values != null && !values.isEmpty()) {
            map = new HashMap<String, String>(values.size() * 2);
            java.util.Locale locale = this.getUserLocale();
            try {
                PolicyManager policyMgr = this.getPolicyManager(realmName);
                if (policyMgr != null) {
                    ReferralTypeManager mgr = policyMgr.getReferralTypeManager();
                    Referral referral = mgr.getReferral(referralTypeName);
                    for (String v : values) {
                        map.put(v, referral.getDisplayNameForValue(v, locale));
                    }
                }
            }
            catch (AMConsoleException e) {
                debug.warning("PolicyModelImpl.getDisplayNameForReferralValues", (Throwable)e);
            }
            catch (NameNotFoundException e) {
                debug.warning("PolicyModelImpl.getDisplayNameForReferralValues", (Throwable)e);
            }
            catch (PolicyException e) {
                debug.warning("PolicyModelImpl.getDisplayNameForReferralValues", (Throwable)e);
            }
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public QueryResults getActiveSubjectTypes(String realmName) {
        HashMap<String, String> subjectTypes = Collections.EMPTY_MAP;
        String strError = null;
        try {
            SubjectTypeManager subjectTypeMgr;
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null && (subjectTypeMgr = policyMgr.getSubjectTypeManager()) != null) {
                Set types = subjectTypeMgr.getSelectedSubjectTypeNames();
                subjectTypes = new HashMap<String, String>(types.size() * 2);
                for (String rName : types) {
                    try {
                        Syntax syntax;
                        Subject subject = subjectTypeMgr.getSubject(rName);
                        if (subject == null || (syntax = subject.getValueSyntax(this.getUserSSOToken())).equals(Syntax.NONE)) continue;
                        subjectTypes.put(rName, subjectTypeMgr.getDisplayName(rName));
                    }
                    catch (SSOException e) {
                        strError = this.getErrorString((Throwable)((Object)e));
                    }
                    catch (NameNotFoundException e) {
                        strError = this.getErrorString(e);
                    }
                    catch (PolicyException e) {
                        strError = this.getErrorString(e);
                    }
                }
            }
        }
        catch (AMConsoleException e) {
            debug.error("PolicyModelImpl.getActiveSubjectTypes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("PolicyModelImpl.getActiveSubjectTypes", (Throwable)((Object)e));
        }
        catch (NameNotFoundException e) {
            debug.error("PolicyModelImpl.getActiveSubjectTypes", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.error("PolicyModelImpl.getActiveSubjectTypes", (Throwable)e);
        }
        return new QueryResults(subjectTypes, strError);
    }

    public Syntax getSubjectSyntax(String realmName, String subjectType) {
        Syntax syntax = Syntax.NONE;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                SubjectTypeManager subjectTypeMgr = policyMgr.getSubjectTypeManager();
                Subject subject = subjectTypeMgr.getSubject(subjectType);
                syntax = subject.getValueSyntax(this.getUserSSOToken());
            }
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getActiveSubjectTypes", (Throwable)((Object)e));
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getActiveSubjectTypes", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getActiveSubjectTypes", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getActiveSubjectTypes", (Throwable)e);
        }
        return syntax;
    }

    public Subject createSubject(String realmName, String subjectType, Set values) throws AMConsoleException {
        Subject subject = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                SubjectTypeManager subjectTypeMgr = policyMgr.getSubjectTypeManager();
                subject = subjectTypeMgr.getSubject(subjectType);
                subject.setValues(values);
            }
        }
        catch (NameNotFoundException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (PolicyException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        return subject;
    }

    public ValidValues getSubjectPossibleValues(String realmName, String subjectType, String filter) throws AMConsoleException {
        debug.error("PolicyModelImpl.getSubjectPossibleValues()");
        ValidValues values = null;
        if (filter == null || filter.trim().length() == 0) {
            filter = "*";
        }
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                SubjectTypeManager subjectTypeMgr = policyMgr.getSubjectTypeManager();
                Subject subject = subjectTypeMgr.getSubject(subjectType);
                values = subject.getValidValues(this.getUserSSOToken(), filter);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getSubjectPossibleValues", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getSubjectPossibleValues", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getSubjectPossibleValues", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getSubjectPossibleValues", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return values;
    }

    public String getSubjectTypeName(String realmName, Subject subject) {
        String typeName = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                SubjectTypeManager subjectTypeMgr = policyMgr.getSubjectTypeManager();
                typeName = subjectTypeMgr.getSubjectTypeName(subject);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getSubjectTypeName", (Throwable)e);
        }
        return typeName;
    }

    public String getSubjectViewBeanURL(String realmName, String subjectTypeName) {
        String url = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                SubjectTypeManager subjectTypeMgr = policyMgr.getSubjectTypeManager();
                Subject subject = subjectTypeMgr.getSubject(subjectTypeName);
                url = subjectTypeMgr.getViewBeanURL(subject);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getSubjectViewBeanURL", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getSubjectViewBeanURL", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getSubjectViewBeanURL", (Throwable)e);
        }
        return url;
    }

    public String getSubjectViewBeanURL(String realmName, Subject subject) {
        String url = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                SubjectTypeManager subjectTypeMgr = policyMgr.getSubjectTypeManager();
                url = subjectTypeMgr.getViewBeanURL(subject);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getSubjectViewBeanURL", (Throwable)e);
        }
        return url;
    }

    public Map getDisplayNameForSubjectValues(String realmName, String subjectTypeName, Set values) {
        HashMap<String, String> map = null;
        if (values != null && !values.isEmpty()) {
            map = new HashMap<String, String>(values.size() * 2);
            java.util.Locale locale = this.getUserLocale();
            try {
                PolicyManager policyMgr = this.getPolicyManager(realmName);
                if (policyMgr != null) {
                    SubjectTypeManager subjectTypeMgr = policyMgr.getSubjectTypeManager();
                    Subject subject = subjectTypeMgr.getSubject(subjectTypeName);
                    for (String v : values) {
                        map.put(v, subject.getDisplayNameForValue(v, locale));
                    }
                }
            }
            catch (AMConsoleException e) {
                debug.warning("PolicyModelImpl.getDisplayNameForSubjectValues", (Throwable)e);
            }
            catch (NameNotFoundException e) {
                debug.warning("PolicyModelImpl.getDisplayNameForSubjectValues", (Throwable)e);
            }
            catch (PolicyException e) {
                debug.warning("PolicyModelImpl.getDisplayNameForSubjectValues", (Throwable)e);
            }
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public String getResponseProviderXML(String realmName, String providerType, boolean bCreate, boolean readonly) {
        String xml = null;
        xml = bCreate ? "com/sun/identity/console/propertyPMResponseProviderAdd.xml" : (readonly ? "com/sun/identity/console/propertyPMResponseProviderEdit_Readonly.xml" : "com/sun/identity/console/propertyPMResponseProviderEdit.xml");
        String prefix = AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream(xml));
        ResponseProviderXMLBuilder builder = new ResponseProviderXMLBuilder(this.getResponseProviderInstance(realmName, providerType), this);
        if (!bCreate && readonly) {
            builder.setAllAttributeReadOnly(true);
        }
        return builder.getXML(prefix);
    }

    public List getResponseProviderPropertyNames(String realmName, String providerType) {
        ResponseProvider provider = this.getResponseProviderInstance(realmName, providerType);
        return provider != null ? provider.getPropertyNames() : Collections.EMPTY_LIST;
    }

    public ResponseProvider createResponseProvider(String realmName, String providerType, Map values) throws AMConsoleException {
        ResponseProvider provider = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ResponseProviderTypeManager mgr = policyMgr.getResponseProviderTypeManager();
                provider = mgr.getResponseProvider(providerType);
                provider.setProperties(values);
            }
        }
        catch (NameNotFoundException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (PolicyException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        return provider;
    }

    private ResponseProvider getResponseProviderInstance(String realmName, String typeName) {
        ResponseProvider provider = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ResponseProviderTypeManager mgr = policyMgr.getResponseProviderTypeManager();
                provider = mgr.getResponseProvider(typeName);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getResponseProviderInstance", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getResponseProviderInstance", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getResponseProviderInstance", (Throwable)e);
        }
        return provider;
    }

    public Map getActiveResponseProviderTypes(String realmName) {
        HashMap<String, String> providerTypes = null;
        try {
            ResponseProviderTypeManager providerTypeMgr;
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null && (providerTypeMgr = policyMgr.getResponseProviderTypeManager()) != null) {
                Set types = providerTypeMgr.getSelectedResponseProviderTypeNames();
                providerTypes = new HashMap<String, String>(types.size() * 2);
                for (String rName : types) {
                    providerTypes.put(rName, providerTypeMgr.getDisplayName(rName));
                }
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getActiveResponseProviderTypes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getActiveResponseProviderTypes", (Throwable)((Object)e));
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getActiveResponseProviderTypes", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getActiveResponseProviderTypes", (Throwable)e);
        }
        return providerTypes == null ? Collections.EMPTY_MAP : providerTypes;
    }

    public String getResponseProviderTypeName(String realmName, ResponseProvider provider) {
        String typeName = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ResponseProviderTypeManager mgr = policyMgr.getResponseProviderTypeManager();
                typeName = mgr.getResponseProviderTypeName(provider);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getResponseProviderTypeName", (Throwable)e);
        }
        return typeName;
    }

    public String getResponseProviderViewBeanURL(String realmName, ResponseProvider provider) {
        String url = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ResponseProviderTypeManager ResponseProviderTypeMgr = policyMgr.getResponseProviderTypeManager();
                url = ResponseProviderTypeMgr.getViewBeanURL(provider);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getResponseProviderViewBeanURL", (Throwable)e);
        }
        return url;
    }

    public String getResponseProviderViewBeanURL(String realmName, String typeName) {
        String url = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ResponseProviderTypeManager mgr = policyMgr.getResponseProviderTypeManager();
                ResponseProvider provider = mgr.getResponseProvider(typeName);
                url = mgr.getViewBeanURL(provider);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getResponseProviderViewBeanURL", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getResponseProviderViewBeanURL", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getResponseProviderViewBeanURL", (Throwable)e);
        }
        return url;
    }

    public Map getActiveConditionTypes(String realmName) {
        HashMap<String, String> condTypes = null;
        try {
            ConditionTypeManager condTypeMgr;
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null && (condTypeMgr = policyMgr.getConditionTypeManager()) != null) {
                Set types = condTypeMgr.getSelectedConditionTypeNames();
                condTypes = new HashMap<String, String>(types.size() * 2);
                for (String rName : types) {
                    condTypes.put(rName, condTypeMgr.getDisplayName(rName));
                }
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getActiveConditionTypes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("PolicyModelImpl.getActiveConditionTypes", (Throwable)((Object)e));
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getActiveConditionTypes", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getActiveConditionTypes", (Throwable)e);
        }
        return condTypes == null ? Collections.EMPTY_MAP : condTypes;
    }

    public String getConditionViewBeanURL(String realmName, Condition condition) {
        String url = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ConditionTypeManager conditionTypeMgr = policyMgr.getConditionTypeManager();
                url = conditionTypeMgr.getViewBeanURL(condition);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getConditionViewBeanURL", (Throwable)e);
        }
        return url;
    }

    public String getConditionViewBeanURL(String realmName, String conditionTypeName) {
        String url = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ConditionTypeManager condTypeMgr = policyMgr.getConditionTypeManager();
                Condition condition = condTypeMgr.getCondition(conditionTypeName);
                url = condTypeMgr.getViewBeanURL(condition);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getConditionViewBeanURL", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getConditionViewBeanURL", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getConditionViewBeanURL", (Throwable)e);
        }
        return url;
    }

    private Condition getConditionInstance(String realmName, String conditionTypeName) {
        Condition condition = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ConditionTypeManager condTypeMgr = policyMgr.getConditionTypeManager();
                condition = condTypeMgr.getCondition(conditionTypeName);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getConditionInstance", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            debug.warning("PolicyModelImpl.getConditionInstance", (Throwable)e);
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.getConditionInstance", (Throwable)e);
        }
        return condition;
    }

    public Condition createCondition(String realmName, String conditionType, Map values) throws AMConsoleException {
        Condition condition = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ConditionTypeManager conditionTypeMgr = policyMgr.getConditionTypeManager();
                condition = conditionTypeMgr.getCondition(conditionType);
                condition.setProperties(values);
            }
        }
        catch (NameNotFoundException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (PolicyException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        return condition;
    }

    public String getConditionXML(String realmName, String conditionType, boolean readonly) {
        String prefix = AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyPMConditionAdd.xml"));
        PolicyPropertyXMLBuilder builder = new PolicyPropertyXMLBuilder(this.getConditionInstance(realmName, conditionType), this);
        builder.setAllAttributeReadOnly(readonly);
        return builder.getXML(prefix);
    }

    public List getConditionPropertyNames(String realmName, String conditionType) {
        Condition cond = this.getConditionInstance(realmName, conditionType);
        return cond != null ? cond.getPropertyNames() : Collections.EMPTY_LIST;
    }

    public String getConditionTypeName(String realmName, Condition condition) {
        String typeName = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                ConditionTypeManager conditionTypeMgr = policyMgr.getConditionTypeManager();
                typeName = conditionTypeMgr.getConditionTypeName(condition);
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyModelImpl.getConditionTypeName", (Throwable)e);
        }
        return typeName;
    }

    public String canCreatePolicy(String realmName) {
        String message = null;
        try {
            PolicyManager policyMgr = this.getPolicyManager(realmName);
            if (policyMgr != null) {
                if (!this.canCreateNewResource(policyMgr) && !this.hasReferredResources(policyMgr)) {
                    message = "noReferralForOrg.message";
                } else if (!this.hasPolicyConfigSvcRegistered(realmName)) {
                    message = "noPolicyConfigSvc.message";
                }
            }
        }
        catch (AMConsoleException e) {
            message = e.getMessage();
        }
        return message;
    }

    private boolean hasPolicyConfigSvcRegistered(String realmName) {
        try {
            OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(adminSSOToken, realmName);
            Set names = orgCfgMgr.getAssignedServices();
            return names != null && names.contains("iPlanetAMPolicyConfigService");
        }
        catch (SMSException e) {
            debug.warning("PolicyModelImpl.hasPolicyConfigSvcRegistered", (Throwable)e);
            return false;
        }
    }

    private boolean canCreateNewResource(PolicyManager policyMgr) {
        Set services;
        boolean can = false;
        ResourceManager resMgr = policyMgr.getResourceManager();
        if (resMgr != null && (services = this.getServiceTypeNames().keySet()) != null && !services.isEmpty()) {
            Iterator i = services.iterator();
            while (i.hasNext() && !can) {
                String svcName = (String)i.next();
                try {
                    can = resMgr.canCreateNewResource(svcName);
                }
                catch (PolicyException e) {
                    debug.warning("PolicyModelImpl.canCreateNewResource", (Throwable)e);
                }
            }
        }
        return can;
    }

    private boolean hasReferredResources(PolicyManager policyMgr) {
        boolean hasPrefixes = false;
        try {
            Set prefixes = policyMgr.getManagedResourceNames();
            hasPrefixes = prefixes != null && !prefixes.isEmpty();
        }
        catch (PolicyException e) {
            debug.warning("PolicyModelImpl.hasReferredResources", (Throwable)e);
        }
        return hasPrefixes;
    }

    public Set getAuthenticationInstances(String realmName) throws AMConsoleException {
        HashSet<String> names = Collections.EMPTY_SET;
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), realmName);
            Set instances = mgr.getAuthenticationInstances();
            if (instances != null && !instances.isEmpty()) {
                names = new HashSet<String>(instances.size());
                Iterator i = instances.iterator();
                while (i.hasNext()) {
                    names.add(((AMAuthenticationInstance)i.next()).getName());
                }
            }
        }
        catch (AMConfigurationException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        return names;
    }

    public Set getProtectedResourceNames(String realmName, String policyName) throws AMConsoleException {
        HashSet<String> resourceNames = new HashSet<String>();
        String policyID = this.cachePolicy(realmName, policyName);
        CachedPolicy cachedPolicy = this.getCachedPolicy(policyID);
        Policy policy = cachedPolicy.getPolicy();
        Set ruleNames = policy.getRuleNames();
        if (ruleNames != null && !ruleNames.isEmpty()) {
            for (String ruleName : ruleNames) {
                try {
                    String resName;
                    Rule rule = policy.getRule(ruleName);
                    if (rule == null || (resName = rule.getResourceName()) == null || resName.trim().length() <= 0) continue;
                    resourceNames.add(resName);
                }
                catch (NameNotFoundException nnfe) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("Cannot find the rule with name '" + ruleName + " in policy " + policy.getName(), (Throwable)nnfe);
                }
            }
        }
        return resourceNames;
    }

    public Set getAuthInstances(String realmName) {
        HashSet<String> instances = null;
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realmName);
            Set inst = mgr.getAuthenticationInstances();
            if (inst != null && !inst.isEmpty()) {
                instances = new HashSet<String>(inst.size() * 2);
                for (AMAuthenticationInstance i : inst) {
                    instances.add(i.getName());
                }
            }
        }
        catch (AMConfigurationException e) {
            debug.warning("PolicyModelImpl.getAuthInstances", (Throwable)((Object)e));
        }
        return instances == null ? Collections.EMPTY_SET : instances;
    }

    public String getAuthenticationLevel(String realmName, String name) {
        String level = "0";
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realmName);
            AMAuthenticationInstance ai = mgr.getAuthenticationInstance(name);
            Map map = ai.getAttributeValues();
            String authType = ai.getType();
            Set set = (Set)map.get(AMAuthConfigUtils.getAuthLevelAttribute(map, authType));
            if (set != null && !set.isEmpty()) {
                level = (String)set.iterator().next();
            }
        }
        catch (AMConfigurationException e) {
            debug.warning("PolicyModelImpl.getInstanceValues", (Throwable)((Object)e));
        }
        return level;
    }

    public Set getRealmNames(String base, String filter) throws AMConsoleException {
        if (base == null || base.length() == 0) {
            base = this.getStartDN();
        }
        String[] param = new String[]{base};
        this.logEvent("ATTEMPT_GET_REALM_NAMES", param);
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(adminSSOToken, base);
            this.logEvent("SUCCEED_GET_REALM_NAMES", param);
            return PolicyModelImpl.appendBaseDN(base, orgMgr.getSubOrganizationNames(filter, true), filter, this);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{base, strError};
            this.logEvent("SMS_EXCEPTION_GET_REALM_NAMES", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    static Set appendBaseDN(String base, Set results, String filter, AMModel model) {
        HashSet<String> altered = new HashSet<String>();
        String displayName = null;
        if (base.equals("/")) {
            displayName = AMFormatUtils.DNToName(model, model.getStartDSDN());
        } else {
            int idx = base.lastIndexOf("/");
            String string = displayName = idx != -1 ? base.substring(idx + 1) : base;
        }
        if (DisplayUtils.wildcardMatch(displayName, filter)) {
            altered.add(base);
        }
        if (results != null && !results.isEmpty()) {
            for (String name : results) {
                if (name.charAt(0) != '/') {
                    if (base.charAt(base.length() - 1) == '/') {
                        altered.add(base + name);
                        continue;
                    }
                    altered.add(base + "/" + name);
                    continue;
                }
                if (base.charAt(base.length() - 1) == '/') {
                    altered.add(base.substring(0, base.length() - 1) + name);
                    continue;
                }
                altered.add(base + name);
            }
        }
        return altered;
    }
}

