/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.SMSDataEntry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.SearchResultEntry;

public class EmbeddedSearchResultIterator
implements Iterator {
    private Iterator resultIter;
    private Set excludeDNs;
    private boolean hasExcludeDNs;
    private SMSDataEntry current;

    public EmbeddedSearchResultIterator(LinkedList results, Set excludeDNs) {
        this.resultIter = results.iterator();
        this.excludeDNs = excludeDNs;
        this.hasExcludeDNs = excludeDNs != null && !excludeDNs.isEmpty();
    }

    public boolean hasNext() {
        if (!this.resultIter.hasNext()) {
            return false;
        }
        SearchResultEntry entry = (SearchResultEntry)this.resultIter.next();
        String dn = entry.getDN().toString();
        if (this.hasExcludeDNs) {
            while (this.excludeDNs.contains(dn)) {
                if (this.resultIter.hasNext()) {
                    entry = (SearchResultEntry)this.resultIter.next();
                    dn = entry.getDN().toString();
                    continue;
                }
                entry = null;
                break;
            }
        }
        this.current = entry == null ? null : new SMSDataEntry(dn, EmbeddedSearchResultIterator.convertLDAPAttributeSetToMap(entry.getAttributes()));
        return this.current != null;
    }

    public Object next() {
        SMSDataEntry tmp = this.current;
        this.current = null;
        return tmp;
    }

    public void remove() {
    }

    static Map convertLDAPAttributeSetToMap(List attributes) {
        Map answer = null;
        if (attributes != null && !attributes.isEmpty()) {
            for (Attribute attr : attributes) {
                String attrName = attr.getName();
                LinkedHashSet values = attr.getValues();
                if (values == null || values.isEmpty()) continue;
                HashSet<String> strValues = new HashSet<String>();
                for (AttributeValue value : values) {
                    strValues.add(value.getStringValue());
                }
                if (answer == null) {
                    answer = new CaseInsensitiveHashMap(10);
                }
                answer.put(attrName, strValues);
            }
        }
        return answer;
    }
}

