/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.sm.SMSObjectListener;
import java.util.Map;

public class LDAPEventManager
implements IDSEventListener {
    private static String baseDN;
    protected static SMSObjectListener changeListener;
    protected static Debug debug;
    private Map listeners;
    protected static final String OC_SERVICE = "sunService";
    protected static final String OC_SERVICE_COMP = "sunServiceComponent";
    protected static final String SEARCH_FILTER = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";

    static void addObjectChangeListener(SMSObjectListener cl) {
        if (cl == null) {
            debug.error("LDAPEventManager.addObjectChangeListener NULL object for change listener");
        }
        changeListener = cl;
        if (debug.messageEnabled()) {
            debug.message("LDAPEventManager.addObjectChangeListener Adding listener: " + cl.getClass().getName());
        }
        try {
            String installTime;
            String disabledList = SystemProperties.get("com.sun.am.event.connection.disable.list", "");
            if (disabledList.indexOf("sm") != -1 && (installTime = SystemProperties.get("installTime", "false")).equals("false")) {
                debug.error("LDAPEventManager.addObjectChangeListener Persistent search for SMS has been disabled by the property: com.sun.am.event.connection.disable.list");
            }
            EventService.getEventService().resetAllSearches(false);
        }
        catch (EventException ex) {
            debug.error("LDAPEventManager.addObjectChangeListener Unable to set persistent search", (Throwable)ex);
        }
        catch (LDAPException ex) {
            debug.error("LDAPEventManager.addObjectChangeListener Unable to set persistent search", (Throwable)ex);
        }
    }

    static void removeObjectChangeListener() {
        changeListener = null;
        try {
            EventService.getEventService().resetAllSearches(false);
        }
        catch (EventException ex) {
            debug.error("LDAPEventManager.removeObjectChangeListener Unable to remove persistent search", (Throwable)ex);
        }
        catch (LDAPException ex) {
            debug.error("LDAPEventManager.removeObjectChangeListener Unable to remove persistent search", (Throwable)ex);
        }
    }

    public synchronized void entryChanged(DSEvent dsEvent) {
        if (changeListener == null) {
            if (debug.warningEnabled()) {
                debug.warning("LDAPEventManager.entryChanged No listner objects registred");
            }
            return;
        }
        int event = dsEvent.getEventType();
        String dn = dsEvent.getID();
        switch (event) {
            case 1: {
                event = 0;
                break;
            }
            case 2: 
            case 8: {
                event = 1;
                break;
            }
            case 4: {
                event = 3;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPEventManager:entry changed for: " + dn + " sending object changed notifications");
        }
        changeListener.objectChanged(dn, event);
    }

    public void eventError(String errorStr) {
        debug.error("LDAPEventManager.eventError(): " + errorStr);
    }

    public void allEntriesChanged() {
        if (changeListener == null) {
            if (debug.warningEnabled()) {
                debug.warning("LDAPEventManager.entryChanged No listner objects registred");
            }
            return;
        }
        if (debug.warningEnabled()) {
            debug.warning("LDAPEventManager: received all entries changed event from EventService");
        }
        changeListener.allObjectsChanged();
    }

    public String getBase() {
        block12: {
            if (baseDN != null) {
                return baseDN;
            }
            try {
                ServerInstance serverInstance = null;
                DSConfigMgr mgr = DSConfigMgr.getDSConfigMgr();
                if (mgr != null) {
                    serverInstance = mgr.getServerInstance("sms", LDAPUser.Type.AUTH_PROXY);
                    if (serverInstance == null) {
                        serverInstance = mgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
                        if (debug.messageEnabled()) {
                            debug.message("LDAPEventManager: SMS servergroup not available. Using default AMSDK DN");
                        }
                    }
                    if (serverInstance != null) {
                        baseDN = serverInstance.getBaseDN();
                    } else if (debug.warningEnabled()) {
                        debug.warning("LDAPEventManager: SMS & AMSDK servergroup not available. Using hardcoded value");
                    }
                } else if (debug.warningEnabled()) {
                    debug.warning("LDAPEventManager: DSConfigMgr is NULL Using hardcoded value");
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block12;
                debug.warning("LDAPEventManager: Exception obtaing baseDN from DSConfigMgr and ServerInstances", (Throwable)e);
            }
        }
        if (baseDN == null) {
            debug.error("LDAPEventManager.getBase(): Unable to get base DN  from serverconfig.xml");
        }
        return baseDN == null ? "o=isp" : baseDN;
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 15;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map listener) {
        this.listeners = listener;
    }

    static {
        debug = Debug.getInstance((String)"amSMSEvent");
    }
}

