/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.dm.UserPropertiesBase;
import com.sun.identity.console.dm.model.UserModel;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UserGroupsViewBean
extends UserPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/UserGroups.jsp";
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    protected static final String PAGE_TITLE = "pgtitle";
    protected static final String USER_GROUPS = "userGroupSelection";
    private CCAddRemoveModel addRemoveModel = null;
    private AMPropertySheetModel propertySheetModel;
    private boolean canModify;
    private OptionList selectedOption;

    public UserGroupsViewBean() {
        super("UserGroups");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String userName;
        if (!this.initialized && (userName = this.getUserName()) != null && userName.length() > 0) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createPropertySheetModel(userName);
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGE_TITLE, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.ptModel.registerChildren((ContainerViewBase)this);
    }

    protected void createPropertySheetModel(String userName) {
        UserModel model = (UserModel)this.getModel();
        this.canModify = model.canModify(userName, ((Object)((Object)this)).getClass().getName());
        String xmlFile = this.canModify ? "com/sun/identity/console/propertyUMUserGroups.xml" : "com/sun/identity/console/propertyUMUserGroups_Readonly.xml";
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xmlFile));
        if (this.canModify) {
            this.addRemoveModel = new CCAddRemoveModel();
            this.addRemoveModel.setShowMoveUpDownButtons("false");
            this.propertySheetModel.setModel(USER_GROUPS, this.addRemoveModel);
        }
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PAGE_TITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.setAddRemoveValues();
        this.setPageTitle("page.title.user.groups");
    }

    private void setAddRemoveValues() {
        this.model = (UserModel)this.getModel();
        String name = this.getUserName();
        Set assigned = this.model.getAssignedGroups(name);
        if (this.canModify) {
            CCAddRemove child = (CCAddRemove)this.getChild(USER_GROUPS);
            child.resetStateData();
            Set available = null;
            available = this.selectedOption != null ? this.model.getAvailableGroups(name, AMAdminUtils.toList(this.selectedOption)) : this.model.getAvailableGroups(name, assigned);
            if (available != null) {
                this.addRemoveModel.setAvailableOptionList(this.createOptionList(this.createMap(available)));
                if (this.selectedOption != null) {
                    this.addRemoveModel.setSelectedOptionList(this.selectedOption);
                } else if (assigned != null) {
                    this.addRemoveModel.setSelectedOptionList(this.createOptionList(this.createMap(assigned)));
                }
            } else {
                this.addRemoveModel.setAvailableOptionList(new OptionList());
            }
        } else if (assigned != null && !assigned.isEmpty()) {
            this.propertySheetModel.setValue(USER_GROUPS, AMAdminUtils.getString(assigned, ",", false));
        } else {
            this.propertySheetModel.setValue(USER_GROUPS, "");
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        CCAddRemove groups = (CCAddRemove)this.getChild(USER_GROUPS);
        groups.restoreStateData();
        this.addRemoveModel = (CCAddRemoveModel)groups.getModel();
        this.selectedOption = this.addRemoveModel.getSelectedOptionList();
        Set values = UserGroupsViewBean.getValues(this.selectedOption);
        this.model = (UserModel)this.getModel();
        try {
            this.model.updateGroups(this.getUserName(), values);
            this.setInlineAlertMessage("info", "message.information", this.model.getLocalizedString("profile.updated"));
        }
        catch (AMConsoleException ame) {
            this.setInlineAlertMessage("error", "message.error", ame.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        CCAddRemove child = (CCAddRemove)this.getChild(USER_GROUPS);
        child.resetStateData();
        this.setAddRemoveValues();
        this.forwardTo();
    }

    private Map createMap(Set roles) {
        HashMap<String, String> values = new HashMap<String, String>(roles.size() * 2);
        if (roles != null && !roles.isEmpty()) {
            for (String value : roles) {
                values.put(value, AMFormatUtils.DNToName(this.getModel(), value));
            }
        }
        return values;
    }
}

