/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AMIdentityMembershipCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private Map properties;
    private Set nameValues = new HashSet();
    private static List propertyNames = new ArrayList(1);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.ANY;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = (HashMap)properties;
        if (properties == null || properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set keySet = properties.keySet();
        Iterator keys = keySet.iterator();
        String key = (String)keys.next();
        if (!"amIdentityName".equals(key)) {
            Object[] args = new String[]{"amIdentityName"};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property", args, null);
        }
        Set nameSet = (Set)properties.get("amIdentityName");
        if (nameSet == null || nameSet.isEmpty()) {
            Object[] args = new String[]{"amIdentityName"};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_values", args, null);
        }
        this.nameValues.addAll(nameSet);
    }

    public Map getProperties() {
        return this.properties;
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map environment) throws SSOException, PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At AMIdentityMembershipCondition.getConditionDecision(): entering, names:" + this.nameValues);
            DEBUG.message("At AMIdentityMembershipCondition.getConditionDecision(): environment.invocatorPrincipalUud:" + environment.get("invocatorPrincipalUuid"));
        }
        boolean member = false;
        Set invocatorUuidSet = (Set)environment.get("invocatorPrincipalUuid");
        if (invocatorUuidSet != null && !invocatorUuidSet.isEmpty()) {
            String invocatorUuid = (String)invocatorUuidSet.iterator().next();
            member = this.isMember(invocatorUuid);
        } else if (DEBUG.messageEnabled()) {
            DEBUG.message("At AMIdentityMembershipCondition.getConditionDecision(): invocatorUuidSet isnull or empty");
        }
        return new ConditionDecision(member);
    }

    public Object clone() {
        AMIdentityMembershipCondition theClone = null;
        try {
            theClone = (AMIdentityMembershipCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            for (Object o : this.properties.keySet()) {
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    private boolean isMember(String invocatorUuid) throws SSOException, PolicyException {
        boolean subjectMatch = false;
        if (invocatorUuid == null) {
            if (DEBUG.warningEnabled()) {
                DEBUG.warning("AMIdentityMembershipCondition.isMember():invocatorUuid is null");
                DEBUG.warning("AMIdentityMembershipCondition.isMember():returning false");
            }
            return false;
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.warning("AMIdentityMembershipCondition.isMember():invocatorUuid:" + invocatorUuid);
        }
        if (!this.nameValues.isEmpty()) {
            for (String nameValue : this.nameValues) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("AMIndentityMembershipCondition.isMember(): checking membership with nameValue = " + nameValue + ", invocatorUuid = " + invocatorUuid);
                }
                try {
                    AMIdentity invocatorIdentity = IdUtils.getIdentity(this.getAdminToken(), invocatorUuid);
                    if (invocatorIdentity == null) {
                        if (DEBUG.messageEnabled()) {
                            DEBUG.message("AMidentityMembershipCondition.isMember():invocatorIdentity is null for invocatorUuid = " + invocatorUuid);
                            DEBUG.message("AMidentityMembershipCondition.isMember():returning false");
                        }
                        return false;
                    }
                    AMIdentity nameValueIdentity = IdUtils.getIdentity(this.getAdminToken(), nameValue);
                    if (nameValueIdentity == null) {
                        if (DEBUG.messageEnabled()) {
                            DEBUG.message("AMidentityMembershipCondition.isMember():nameValueidentity is null for nameValue = " + nameValue);
                            DEBUG.message("AMidentityMembershipCondition.isMember():returning false");
                        }
                        return false;
                    }
                    IdType invocatorIdType = invocatorIdentity.getType();
                    IdType nameValueIdType = nameValueIdentity.getType();
                    Set allowedMemberTypes = null;
                    if (invocatorIdentity.equals(nameValueIdentity)) {
                        if (DEBUG.messageEnabled()) {
                            DEBUG.message("AMidentityMembershipCondition.isMember():invocatorIdentity equals  nameValueIdentity:membership=true");
                        }
                        subjectMatch = true;
                    } else {
                        allowedMemberTypes = nameValueIdType.canHaveMembers();
                        if (allowedMemberTypes != null && allowedMemberTypes.contains(invocatorIdType)) {
                            subjectMatch = invocatorIdentity.isMember(nameValueIdentity);
                            if (DEBUG.messageEnabled()) {
                                DEBUG.message("AMIdentityMembershipCondition.isMember():invocatorIdentityType " + invocatorIdType + " can be a member of " + " nameValueIdentityType " + nameValueIdType + ":membership=" + subjectMatch);
                            }
                        } else {
                            subjectMatch = false;
                            if (DEBUG.messageEnabled()) {
                                DEBUG.message("AMIdentityMembershipCondition.isMember():invocatoridentityType " + invocatorIdType + " can be a member of " + " nameValueIdentityType " + nameValueIdType + ":membership=" + subjectMatch);
                            }
                        }
                    }
                    if (!subjectMatch) continue;
                    break;
                }
                catch (IdRepoException ire) {
                    DEBUG.warning("AMidentityMembershipCondition.isMember():can not check membership for invocator " + invocatorUuid + ", nameValue " + nameValue, (Throwable)ire);
                    Object[] args = new String[]{invocatorUuid, nameValue};
                    throw new PolicyException("amPolicy", "am_id_subject_membership_evaluation_error", args, ire);
                }
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("AMIdentityMembershipCondition.isMember():invocatorUuidr=" + invocatorUuid + ",nameValues=" + this.nameValues + ",subjectMatch=" + subjectMatch);
        }
        return subjectMatch;
    }

    private SSOToken getAdminToken() throws SSOException {
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (token == null) {
            throw new SSOException(new PolicyException("amPolicy", "invalid_admin", null, null));
        }
        return token;
    }

    static {
        propertyNames.add("amIdentityName");
    }
}

