/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso.cli;

import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.opensso.cli.ApplicationImpl;
import com.sun.identity.log.Level;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public class SetApplication
extends ApplicationImpl {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        String realm = this.getStringOptionValue("realm");
        String appName = this.getStringOptionValue("name");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        String[] params = new String[]{realm, appName};
        this.writeLog(0, Level.INFO, "ATTEMPT_SET_APPLICATION", params);
        Subject adminSubject = this.getAdminSubject();
        Application appl = ApplicationManager.getApplication(adminSubject, realm, appName);
        Object[] param = new Object[]{appName};
        if (appl == null) {
            throw new CLIException(MessageFormat.format(this.getResourceString("set-application-not-found"), param), 127);
        }
        try {
            this.setApplicationAttributes(appl, attributeValues, false);
            ApplicationManager.saveApplication(this.getAdminSubject(), realm, appl);
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("set-application-modified"), param));
            this.writeLog(0, Level.INFO, "SUCCEEDED_SET_APPLICATION", params);
        }
        catch (EntitlementException e) {
            String[] paramExs = new String[]{realm, appName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_SET_APPLICATION", paramExs);
            throw new CLIException(e, 127);
        }
        catch (CLIException e) {
            String[] paramExs = new String[]{realm, appName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_SET_APPLICATION", paramExs);
            throw e;
        }
    }
}

