/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.server;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.comm.share.PLLBundle;
import com.sun.identity.common.HttpURLConnectionManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class NotificationSender {
    private URL url;
    private NotificationSet set;
    private static boolean useCache = Boolean.getBoolean(SystemProperties.get("com.sun.identity.urlconnection.useCache", "false"));

    NotificationSender(URL u, NotificationSet s) {
        this.url = u;
        this.set = s;
    }

    public void run() throws SendNotificationException {
        HttpURLConnection conn = null;
        OutputStream httpOut = null;
        try {
            String in_string;
            conn = HttpURLConnectionManager.getConnection((URL)this.url);
            conn.setDoOutput(true);
            conn.setUseCaches(useCache);
            conn.setRequestMethod("POST");
            if (SystemProperties.iasGXId != null) {
                conn.setRequestProperty("Cookie", "GX_jst=" + SystemProperties.iasGXId);
            }
            conn.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            String xml = this.set.toXMLString();
            int requestLength = xml.getBytes("UTF-8").length;
            conn.setRequestProperty("Content-Length", Integer.toString(requestLength));
            if (PLLServer.pllDebug.messageEnabled()) {
                PLLServer.pllDebug.message("Sent NotificationSet XML :" + xml);
            }
            httpOut = conn.getOutputStream();
            httpOut.write(xml.getBytes("UTF-8"));
            httpOut.flush();
            StringBuffer in_buf = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((in_string = in.readLine()) != null) {
                in_buf.append(in_string);
            }
            in_string = in_buf.toString();
            if (!in_string.equals("OK")) {
                throw new SendNotificationException(PLLBundle.getString("sendNotificationFailed"));
            }
        }
        catch (Exception e) {
            PLLServer.pllDebug.error("Cannot send notification to " + this.url, (Throwable)e);
            throw new SendNotificationException(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (httpOut != null) {
                    httpOut.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

