/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.SchemaElementAlreadyExistsException;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import com.sun.identity.shared.ldap.LDAPBind;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPControl;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPModificationSet;
import com.sun.identity.shared.ldap.LDAPSchema;
import com.sun.identity.shared.ldap.LDAPSchemaElement;
import com.sun.identity.shared.ldap.LDAPSearchConstraints;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.LDAPSortKey;
import com.sun.identity.shared.ldap.controls.LDAPProxiedAuthControl;
import com.sun.identity.shared.ldap.controls.LDAPSortControl;
import com.sun.identity.shared.ldap.controls.LDAPVirtualListControl;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class DataLayer
implements Serializable {
    private static Debug debug;
    private static I18n i18n;
    static final int MAX_CONN = 20;
    static final int MAX_BACKLOG = 100;
    static final String LDAP_MAXBACKLOG = "maxbacklog";
    static final String LDAP_RELEASECONNBEFORESEARCH = "releaseconnectionbeforesearchcompletes";
    static final String LDAP_REFERRAL = "referral";
    private static int replicaRetryNum;
    private static long replicaRetryInterval;
    private static final String LDAP_CONNECTION_NUM_RETRIES = "com.iplanet.am.ldap.connection.num.retries";
    private static final String LDAP_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.ldap.connection.delay.between.retries";
    private static final String LDAP_CONNECTION_ERROR_CODES = "com.iplanet.am.ldap.connection.ldap.error.codes.retries";
    private static int connNumRetry;
    private static int connRetryInterval;
    private static HashSet retryErrorCodes;
    private static LDAPConnectionPool _ldapPool;
    private static LDAPConnection _trialConn;
    private static LDAPSearchConstraints _defaultSearchConstraints;
    private static DataLayer m_instance;
    private String m_host = null;
    private int m_port;
    private String m_proxyUser = "";
    private String m_proxyPassword = "";
    private boolean m_releaseConnectionBeforeSearchCompletes = false;
    private static final String[] EMPTY_STRING_ARRAY;

    public static void initConnectionParams() {
        String retryErrs;
        block10: {
            String retryIntervalStr;
            block9: {
                String numRetryStr = SystemProperties.get(LDAP_CONNECTION_NUM_RETRIES);
                if (numRetryStr != null) {
                    try {
                        connNumRetry = Integer.parseInt(numRetryStr);
                    }
                    catch (NumberFormatException e) {
                        if (!debug.warningEnabled()) break block9;
                        debug.warning("Invalid value for com.iplanet.am.ldap.connection.num.retries");
                    }
                }
            }
            if ((retryIntervalStr = SystemProperties.get(LDAP_CONNECTION_RETRY_INTERVAL)) != null) {
                try {
                    connRetryInterval = Integer.parseInt(retryIntervalStr);
                }
                catch (NumberFormatException e) {
                    if (!debug.warningEnabled()) break block10;
                    debug.warning("Invalid value for com.iplanet.am.ldap.connection.delay.between.retries");
                }
            }
        }
        if ((retryErrs = SystemProperties.get(LDAP_CONNECTION_ERROR_CODES)) != null) {
            StringTokenizer stz = new StringTokenizer(retryErrs, ",");
            while (stz.hasMoreTokens()) {
                retryErrorCodes.add(stz.nextToken().trim());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("DataLayer: number of retry = " + connNumRetry);
            debug.message("DataLayer: retry interval = " + connRetryInterval);
            debug.message("DataLayer: retry error codes = " + retryErrorCodes);
        }
    }

    private DataLayer() {
    }

    private DataLayer(String id, String pwd, String host, int port) throws UMSException {
        this.m_proxyUser = id;
        this.m_proxyPassword = pwd;
        this.m_host = host;
        this.m_port = port;
        this.initReplicaProperties();
        this.initLdapPool();
    }

    public static synchronized DataLayer getInstance(ServerInstance serverCfg) throws UMSException {
        if (m_instance == null) {
            String host = "localhost";
            int port = 389;
            String pUser = "";
            String pPwd = "";
            if (serverCfg != null) {
                host = serverCfg.getServerName();
                port = serverCfg.getPort();
                pUser = serverCfg.getAuthID();
                pPwd = (String)AccessController.doPrivileged(new ServerInstanceAction(serverCfg));
            }
            m_instance = new DataLayer(pUser, pPwd, host, port);
            DataLayer.initializeEventService();
        }
        return m_instance;
    }

    public static DataLayer getInstance() throws UMSException {
        if (m_instance == null) {
            try {
                DSConfigMgr cfgMgr = DSConfigMgr.getDSConfigMgr();
                ServerInstance serverCfg = cfgMgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
                m_instance = DataLayer.getInstance(serverCfg);
            }
            catch (LDAPServiceException ex) {
                debug.error("Error:  Unable to get server config instance " + ex.getMessage());
            }
        }
        return m_instance;
    }

    public LDAPConnection getConnection(Principal principal) {
        if (_ldapPool == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Invoking _ldapPool.getConnection()");
        }
        LDAPConnection conn = _ldapPool.getConnection();
        if (debug.messageEnabled()) {
            debug.message("Got Connection : " + conn);
        }
        LDAPProxiedAuthControl proxyCtrl = new LDAPProxiedAuthControl(principal.getName(), true);
        LDAPSearchConstraints cons = conn.getSearchConstraints();
        cons.setServerControls((LDAPControl)proxyCtrl);
        conn.setSearchConstraints(cons);
        return conn;
    }

    public void releaseConnection(LDAPConnection conn) {
        if (_ldapPool == null || conn == null) {
            return;
        }
        conn.setSearchConstraints(_defaultSearchConstraints);
        if (debug.messageEnabled()) {
            debug.message("Invoking _ldapPool.close(conn) : " + conn);
        }
        _ldapPool.close(conn);
        if (debug.messageEnabled()) {
            debug.message("Released Connection : " + conn);
        }
    }

    public void releaseConnection(LDAPConnection conn, int ldapErrCode) {
        if (_ldapPool == null || conn == null) {
            return;
        }
        conn.setSearchConstraints(_defaultSearchConstraints);
        if (debug.messageEnabled()) {
            debug.message("Invoking _ldapPool.close(conn,ldapErrCode) : " + conn + ":" + ldapErrCode);
        }
        _ldapPool.close(conn, ldapErrCode);
        if (debug.messageEnabled()) {
            debug.message("Released Connection:close(conn,ldapErrCode) : " + conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttributeString(Principal principal, Guid guid, String attrName) {
        LDAPConnection conn = null;
        String id = guid.getDn();
        try {
            conn = this.getConnection(principal);
            LDAPEntry ldapEntry = this.readLDAPEntry(conn, id, null);
            LDAPAttribute attr = ldapEntry.getAttribute(attrName);
            String[] stringArray = attr.getStringValueArray();
            return stringArray;
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("Exception in DataLayer.getAttributeString for DN: " + id, (Throwable)e);
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attr getAttribute(Principal principal, Guid guid, String attrName) {
        LDAPAttribute ldapAttr;
        String id;
        LDAPConnection conn;
        block6: {
            conn = null;
            id = guid.getDn();
            String[] attrNames = new String[]{attrName};
            conn = this.getConnection(principal);
            LDAPEntry ldapEntry = this.readLDAPEntry(conn, id, attrNames);
            ldapAttr = ldapEntry.getAttribute(attrName);
            if (ldapAttr != null) break block6;
            Attr attr = null;
            this.releaseConnection(conn);
            return attr;
        }
        try {
            Attr attr = new Attr(ldapAttr);
            this.releaseConnection(conn);
            return attr;
        }
        catch (Exception e) {
            try {
                if (debug.warningEnabled()) {
                    debug.warning("Exception in DataLayer.getAttribute for DN: " + id, (Throwable)e);
                }
                Attr attr = null;
                this.releaseConnection(conn);
                return attr;
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAttributes(Principal principal, Guid guid, Collection attrNames) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        LDAPConnection conn = null;
        String id = guid.getDn();
        try {
            conn = this.getConnection(principal);
            LDAPEntry ldapEntry = this.readLDAPEntry(conn, id, attrNames.toArray(EMPTY_STRING_ARRAY));
            if (ldapEntry == null) {
                debug.warning("No attributes returned may not have permission to read");
                Set set = Collections.EMPTY_SET;
                return set;
            }
            for (String attrName : attrNames) {
                LDAPAttribute ldapAttribute = ldapEntry.getAttribute(attrName);
                if (ldapAttribute == null) continue;
                attributes.add(new Attr(ldapAttribute));
            }
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("Exception in DataLayer.getAttributes for DN: " + id, (Throwable)e);
            }
            Collection collection = null;
            return collection;
        }
        finally {
            this.releaseConnection(conn);
        }
        return attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEntry(Principal principal, Guid guid, AttrSet attrSet) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        LDAPConnection conn = null;
        String id = guid.getDn();
        int errorCode = 0;
        try {
            conn = this.getConnection(principal);
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("DataLayer.addEntry retry: " + retry);
                }
                try {
                    LDAPEntry entry = new LDAPEntry(id, attrSet.toLDAPAttributeSet());
                    conn.add(entry);
                    return;
                }
                catch (LDAPException e) {
                    try {
                        errorCode = e.getLDAPResultCode();
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                    catch (LDAPException e2) {
                        if (debug.warningEnabled()) {
                            debug.warning("Exception in DataLayer.addEntry for DN: " + id, (Throwable)e2);
                        }
                        errorCode = e2.getLDAPResultCode();
                        Object[] args = new String[]{id};
                        switch (errorCode) {
                            case 68: {
                                throw new EntryAlreadyExistsException(i18n.getString("ums-entry_already_exists", args), e2);
                            }
                            case 50: {
                                throw new AccessRightsException(i18n.getString("ums-insufficient_access_add", args), e2);
                            }
                        }
                        throw new UMSException(i18n.getString("ums-unable_to_add_entry", args), e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.releaseConnection(conn, errorCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteEntry(Principal principal, Guid guid) throws AccessRightsException, EntryNotFoundException, UMSException {
        if (guid == null) {
            String msg = i18n.getString("ums-badid");
            throw new IllegalArgumentException(msg);
        }
        LDAPConnection conn = null;
        String id = guid.getDn();
        int errorCode = 0;
        try {
            conn = this.getConnection(principal);
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("DataLayer.deleteEntry retry: " + retry);
                }
                try {
                    conn.delete(id);
                    return;
                }
                catch (LDAPException e) {
                    try {
                        errorCode = e.getLDAPResultCode();
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                    catch (LDAPException e2) {
                        debug.error("Exception in DataLayer.deleteEntry for DN: " + id, (Throwable)e2);
                        errorCode = e2.getLDAPResultCode();
                        Object[] args = new String[]{id};
                        switch (errorCode) {
                            case 32: {
                                throw new EntryNotFoundException(i18n.getString("ums-entry_not_found", args), e2);
                            }
                            case 50: {
                                throw new AccessRightsException(i18n.getString("ums-insufficient_access_delete", args), e2);
                            }
                        }
                        throw new UMSException(i18n.getString("ums-unable_to_delete_entry", args), e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.releaseConnection(conn, errorCode);
        }
    }

    public AttrSet read(Principal principal, Guid guid) throws EntryNotFoundException, UMSException {
        return this.read(principal, guid, null);
    }

    public AttrSet read(Principal principal, Guid guid, String[] attrNames) throws EntryNotFoundException, UMSException {
        LDAPConnection conn = null;
        String id = guid.getDn();
        LDAPEntry entry = null;
        try {
            conn = this.getConnection(principal);
            entry = attrNames == null ? this.readLDAPEntry(conn, id, null) : this.readLDAPEntry(conn, id, attrNames);
        }
        catch (LDAPException e) {
            if (debug.warningEnabled()) {
                debug.warning("Exception in DataLayer.read for DN: " + id);
                debug.warning("LDAPException: " + (Object)((Object)e));
            }
            int errorCode = e.getLDAPResultCode();
            Object[] args = new String[]{id};
            if (errorCode == 32) {
                throw new EntryNotFoundException(i18n.getString("ums-entry_not_found", args), e);
            }
            throw new UMSException(i18n.getString("ums-unable_to_read_entry", args), e);
        }
        finally {
            this.releaseConnection(conn);
        }
        if (entry == null) {
            throw new AccessRightsException(id);
        }
        LDAPAttributeSet ldapAttrSet = entry.getAttributeSet();
        if (ldapAttrSet == null) {
            Object[] args = new String[]{id};
            throw new EntryNotFoundException(i18n.getString("ums-entry_not_found", args));
        }
        return new AttrSet(ldapAttrSet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rename(Principal principal, Guid guid, String newName, boolean deleteOldName) throws AccessRightsException, EntryNotFoundException, UMSException {
        LDAPConnection conn = null;
        String id = guid.getDn();
        int errorCode = 0;
        try {
            conn = this.getConnection(principal);
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("DataLayer.rename retry: " + retry);
                }
                try {
                    conn.rename(id, newName, deleteOldName);
                    return;
                }
                catch (LDAPException e) {
                    try {
                        errorCode = e.getLDAPResultCode();
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                    catch (LDAPException e2) {
                        if (debug.warningEnabled()) {
                            debug.warning("Exception in DataLayer.rename for DN: " + id, (Throwable)e2);
                        }
                        errorCode = e2.getLDAPResultCode();
                        switch (errorCode) {
                            case 32: {
                                throw new EntryNotFoundException(id, e2);
                            }
                            case 50: {
                                throw new AccessRightsException(id, e2);
                            }
                        }
                        throw new UMSException(id, e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.releaseConnection(conn, errorCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modify(Principal principal, Guid guid, ModSet modSet) throws AccessRightsException, EntryNotFoundException, UMSException {
        LDAPConnection conn = null;
        String id = guid.getDn();
        int errorCode = 0;
        try {
            conn = this.getConnection(principal);
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("DataLayer.modify retry: " + retry);
                }
                try {
                    conn.modify(id, (LDAPModificationSet)modSet);
                    return;
                }
                catch (LDAPException e) {
                    try {
                        errorCode = e.getLDAPResultCode();
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                    catch (LDAPException e2) {
                        if (debug.warningEnabled()) {
                            debug.warning("Exception in DataLayer.modify for DN: " + id, (Throwable)e2);
                        }
                        errorCode = e2.getLDAPResultCode();
                        switch (errorCode) {
                            case 32: {
                                throw new EntryNotFoundException(id, e2);
                            }
                            case 50: {
                                throw new AccessRightsException(id, e2);
                            }
                        }
                        throw new UMSException(id, e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.releaseConnection(conn, errorCode);
        }
    }

    public void changePassword(Guid guid, String attrName, String oldPassword, String newPassword) throws AccessRightsException, EntryNotFoundException, UMSException {
        ModSet modSet = new ModSet();
        modSet.add(2, new LDAPAttribute(attrName, newPassword));
        String id = guid.getDn();
        LDAPConnection ldc = null;
        boolean resultCode = false;
        try {
            DSConfigMgr dsCfg = DSConfigMgr.getDSConfigMgr();
            String hostAndPort = dsCfg.getHostName("default");
            ldc = new LDAPConnection();
            ldc.connect(hostAndPort, 389, id, oldPassword);
            ldc.modify(id, (LDAPModificationSet)modSet);
        }
        catch (LDAPException ldex) {
            if (debug.warningEnabled()) {
                debug.warning("DataLayer.changePassword:", (Throwable)ldex);
            }
            int errorCode = ldex.getLDAPResultCode();
            switch (errorCode) {
                case 32: {
                    throw new EntryNotFoundException(id, ldex);
                }
                case 50: {
                    throw new AccessRightsException(id, ldex);
                }
            }
            throw new UMSException(id, ldex);
        }
        catch (LDAPServiceException ex) {
            debug.error("DataLayer.changePassword:", (Throwable)ex);
            throw new UMSException(id, ex);
        }
        finally {
            if (ldc != null) {
                try {
                    ldc.disconnect();
                }
                catch (LDAPException lde) {}
            }
        }
    }

    public void addAttributeValue(Principal principal, Guid guid, String name, String value) throws UMSException {
        ModSet modSet = new ModSet();
        modSet.add(0, new LDAPAttribute(name, value));
        this.modify(principal, guid, modSet);
    }

    public void removeAttributeValue(Principal principal, Guid guid, String name, String value) throws UMSException {
        ModSet modSet = new ModSet();
        modSet.add(1, new LDAPAttribute(name, value));
        this.modify(principal, guid, modSet);
    }

    private LDAPConnection getSearchConnection(Principal principal, SearchControl searchControl) {
        LDAPConnection conn = this.getConnection(principal);
        if (searchControl != null) {
            int[] vlvRange = searchControl.getVLVRange();
            SortKey[] sortKeys = searchControl.getSortKeys();
            ArrayList<Object> ctrls = new ArrayList<Object>();
            if (sortKeys != null) {
                LDAPSortKey[] ldapSortKeys = new LDAPSortKey[sortKeys.length];
                for (int i = 0; i < ldapSortKeys.length; ++i) {
                    ldapSortKeys[i] = new LDAPSortKey(sortKeys[i].attributeName, sortKeys[i].reverse);
                }
                ctrls.add(new LDAPSortControl(ldapSortKeys, false));
                if (vlvRange != null) {
                    if (searchControl.getVLVJumpTo() == null) {
                        ctrls.add(new LDAPVirtualListControl(vlvRange[0], vlvRange[1], vlvRange[2], 0));
                    } else {
                        ctrls.add(new LDAPVirtualListControl(searchControl.getVLVJumpTo(), vlvRange[1], vlvRange[2]));
                    }
                }
            }
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            LDAPControl[] existingCtrls = constraints.getServerControls();
            for (int i = 0; i < existingCtrls.length; ++i) {
                ctrls.add(existingCtrls[i]);
            }
            constraints.setBatchSize(1);
            constraints.setMaxResults(searchControl.getMaxResults());
            constraints.setServerTimeLimit(searchControl.getTimeOut());
            if (sortKeys != null) {
                constraints.setServerControls(ctrls.toArray(new LDAPControl[0]));
            }
            searchControl.set("constraints", constraints);
        }
        return conn;
    }

    public SearchResults search(Principal principal, Guid guid, int scope, String searchFilter, String[] attrNames, boolean attrOnly, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        LDAPConnection conn = null;
        String id = guid.getDn();
        String[] attrNames1 = null;
        if (attrNames != null) {
            attrNames1 = new String[attrNames.length + 1];
            System.arraycopy(attrNames, 0, attrNames1, 0, attrNames.length);
            attrNames1[attrNames1.length - 1] = "objectclass";
        } else {
            attrNames1 = new String[]{"objectclass"};
        }
        LDAPSearchResults ldapResults = null;
        if (searchFilter == null) {
            searchFilter = "(objectclass=*)";
        }
        int errorCode = 0;
        try {
            SortKey[] sortKeys;
            conn = this.getSearchConnection(principal, searchControl);
            if (replicaRetryNum != 0) {
                this.readLDAPEntry(conn, id, null);
            }
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("DataLayer.search retry: " + retry);
                }
                try {
                    if (searchControl == null) {
                        ldapResults = conn.search(id, scope, searchFilter, attrNames1, attrOnly);
                        break;
                    }
                    if (searchControl.isGetAllReturnAttributesEnabled()) {
                        attrNames1 = new String[]{"*"};
                    }
                    ldapResults = conn.search(id, scope, searchFilter, attrNames1, attrOnly, (LDAPSearchConstraints)searchControl.get("constraints"));
                    break;
                }
                catch (LDAPException e) {
                    errorCode = e.getLDAPResultCode();
                    if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                        throw e;
                    }
                    ++retry;
                    try {
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException ex) {}
                }
            }
            SortKey[] result = new SearchResults(ldapResults, conn, this);
            result.set("baseID", id);
            result.set("searchFilter", searchFilter);
            result.set("searchScope", new Integer(scope));
            if (searchControl != null && (searchControl.contains("vlvRange") || searchControl.contains("vlvJumpTo"))) {
                result.set("expectVlvResponse", Boolean.TRUE);
            }
            if (searchControl != null && searchControl.contains("sortKeys") && (sortKeys = searchControl.getSortKeys()) != null && sortKeys.length > 0) {
                result.set("sortKeys", sortKeys);
            }
            sortKeys = result;
            return sortKeys;
        }
        catch (LDAPException e) {
            errorCode = e.getLDAPResultCode();
            this.releaseConnection(conn, errorCode);
            if (debug.warningEnabled()) {
                debug.warning("Exception in DataLayer.search: ", (Throwable)e);
            }
            String msg = i18n.getString("ums-searchfailed");
            switch (errorCode) {
                case 3: {
                    int timeLimit = searchControl != null ? searchControl.getTimeOut() : 0;
                    throw new TimeLimitExceededException(String.valueOf(timeLimit), e);
                }
                case 4: {
                    int sizeLimit = searchControl != null ? searchControl.getMaxResults() : 0;
                    throw new SizeLimitExceededException(String.valueOf(sizeLimit), e);
                }
                case 2: 
                case 89: {
                    throw new InvalidSearchFilterException(searchFilter, e);
                }
            }
            throw new UMSException(msg, e);
        }
    }

    public SearchResults searchIDs(Principal principal, Guid guid, int scope, String searchFilter, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        String[] attrNames = new String[]{"objectclass"};
        return this.search(principal, guid, scope, searchFilter, attrNames, false, searchControl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LDAPSchema getSchema(Principal principal) throws AccessRightsException, UMSException {
        LDAPConnection conn = null;
        LDAPSchema dirSchema = new LDAPSchema();
        int errorCode = 0;
        try {
            conn = this.getConnection(principal);
            conn.setProperty("com.sun.identity.shared.ldap.schema.quoting", (Object)"standard");
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("DataLayer.getSchema retry: " + retry);
                }
                try {
                    if (retry > 0) {
                        try {
                            conn.read("fake=fake");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    dirSchema.fetchSchema(conn, "cn=schema");
                    LDAPSchema ex = dirSchema;
                    return ex;
                }
                catch (LDAPException e) {
                    try {
                        errorCode = e.getLDAPResultCode();
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                    catch (LDAPException e2) {
                        debug.error("Exception in DataLayer.getSchema: ", (Throwable)e2);
                        errorCode = e2.getLDAPResultCode();
                        switch (errorCode) {
                            case 50: {
                                throw new AccessRightsException(this.m_host, e2);
                            }
                        }
                        throw new UMSException(this.m_host, e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return dirSchema;
                    }
                }
            }
        }
        finally {
            this.releaseConnection(conn, errorCode);
        }
    }

    public void addSchema(Principal principal, LDAPSchemaElement schemaElement) throws AccessRightsException, SchemaElementAlreadyExistsException, UMSException {
        LDAPConnection conn = null;
        try {
            conn = this.getConnection(principal);
            conn.setProperty("com.sun.identity.shared.ldap.schema.quoting", (Object)"standard");
            schemaElement.add(conn, "cn=schema");
        }
        catch (LDAPException e) {
            debug.error("Exception in DataLayer.addSchema: ", (Throwable)e);
            int errorCode = e.getLDAPResultCode();
            switch (errorCode) {
                case 20: {
                    throw new SchemaElementAlreadyExistsException(schemaElement.getName(), e);
                }
                case 50: {
                    throw new AccessRightsException(schemaElement.getName(), e);
                }
            }
            throw new UMSException(schemaElement.getName(), e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    public void removeSchema(Principal principal, LDAPSchemaElement schemaElement) throws AccessRightsException, UMSException {
        LDAPConnection conn = null;
        try {
            conn = this.getConnection(principal);
            conn.setProperty("com.sun.identity.shared.ldap.schema.quoting", (Object)"standard");
            schemaElement.remove(conn, "cn=schema");
        }
        catch (LDAPException e) {
            debug.error("Exception in DataLayer.removeSchema:", (Throwable)e);
            int errorCode = e.getLDAPResultCode();
            switch (errorCode) {
                case 50: {
                    throw new AccessRightsException(schemaElement.getName(), e);
                }
            }
            throw new UMSException(schemaElement.getName(), e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    private void initReplicaProperties() {
        String interval;
        String retries = SystemProperties.get("com.iplanet.am.replica.num.retries");
        if (retries != null) {
            try {
                replicaRetryNum = Integer.parseInt(retries);
                if (replicaRetryNum < 0) {
                    replicaRetryNum = 0;
                    debug.warning("Invalid value for replica retry num, set to 0");
                }
            }
            catch (NumberFormatException e) {
                debug.warning("Invalid value for replica retry num");
            }
        }
        if ((interval = SystemProperties.get("com.iplanet.am.replica.delay.between.retries")) != null) {
            try {
                replicaRetryInterval = Long.parseLong(interval);
                if (replicaRetryInterval < 0L) {
                    replicaRetryInterval = 0L;
                    debug.warning("Invalid value for replica interval, set to 0");
                }
            }
            catch (NumberFormatException e) {
                debug.warning("Invalid value for replica interval");
            }
        }
    }

    public LDAPEntry readLDAPEntry(LDAPConnection ld, String dn, String[] attrnames) throws LDAPException {
        LDAPException ldapEx = null;
        int retry = 0;
        int connRetry = 0;
        while (retry <= replicaRetryNum && connRetry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("DataLayer.readLDAPEntry: connRetry: " + connRetry);
                debug.message("DataLayer.readLDAPEntry: retry: " + retry);
            }
            try {
                if (attrnames == null) {
                    return ld.read(dn);
                }
                return ld.read(dn, attrnames);
            }
            catch (LDAPException e) {
                int errorCode = e.getLDAPResultCode();
                if (errorCode == 32) {
                    if (debug.messageEnabled()) {
                        debug.message("Replica: entry not found: " + dn + " retry: " + retry);
                    }
                    if (retry == replicaRetryNum) {
                        ldapEx = e;
                    } else {
                        try {
                            Thread.sleep(replicaRetryInterval);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ++retry;
                    continue;
                }
                if (retryErrorCodes.contains("" + errorCode)) {
                    if (connRetry == connNumRetry) {
                        ldapEx = e;
                    } else {
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ++connRetry;
                    continue;
                }
                throw e;
            }
        }
        throw ldapEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initLdapPool() throws UMSException {
        block10: {
            if (_ldapPool != null) {
                return;
            }
            ServerInstance svrCfg = null;
            String hostName = null;
            HashMap<String, Constable> connOptions = new HashMap<String, Constable>();
            try {
                DSConfigMgr dsCfg = DSConfigMgr.getDSConfigMgr();
                hostName = dsCfg.getHostName("default");
                _trialConn = dsCfg.getNewProxyConnection();
                svrCfg = dsCfg.getServerInstance(LDAPUser.Type.AUTH_PROXY);
            }
            catch (LDAPServiceException ex) {
                debug.error("Error initializing connection pool " + ex.getMessage());
            }
            if (svrCfg == null || _trialConn == null) {
                debug.error("Error getting server config.");
                Object[] args = new String[]{hostName == null ? "default" : hostName};
                throw new UMSException(i18n.getString("ums-newinstancefailed", args));
            }
            int poolMin = svrCfg.getMinConnections();
            int poolMax = svrCfg.getMaxConnections();
            int maxBackLog = svrCfg.getIntValue(LDAP_MAXBACKLOG, 100);
            this.m_releaseConnectionBeforeSearchCompletes = svrCfg.getBooleanValue(LDAP_RELEASECONNBEFORESEARCH, false);
            boolean referrals = svrCfg.getBooleanValue(LDAP_REFERRAL, true);
            String connDN = svrCfg.getAuthID();
            String connPWD = svrCfg.getPasswd();
            if (debug.messageEnabled()) {
                debug.message("Creating ldap connection pool with :");
                debug.message("poolMin : " + poolMin);
                debug.message("poolMax : " + poolMax);
                debug.message("maxBackLog : " + maxBackLog);
            }
            try {
                _trialConn.setOption(30, (Object)new Integer(maxBackLog));
                _trialConn.setOption(8, (Object)referrals);
                LDAPBind defaultBinder = new LDAPBind(){

                    public void bind(LDAPConnection ld) throws LDAPException {
                        String dn = _trialConn.getAuthenticationDN();
                        String pwd = _trialConn.getAuthenticationPassword();
                        String newhost = ld.getHost();
                        int newport = ld.getPort();
                        ld.connect(3, newhost, newport, dn, pwd);
                    }
                };
                _trialConn.setOption(13, (Object)defaultBinder);
                _defaultSearchConstraints = _trialConn.getSearchConstraints();
                connOptions.put(LDAP_MAXBACKLOG, new Integer(maxBackLog));
                connOptions.put("referrals", new Boolean(referrals));
                connOptions.put("searchconstraints", (Constable)_defaultSearchConstraints);
                ShutdownManager shutdownMan = ShutdownManager.getInstance();
                if (!shutdownMan.acquireValidLock()) break block10;
                try {
                    _ldapPool = new LDAPConnectionPool("DataLayer", poolMin, poolMax, hostName, 389, connDN, connPWD, _trialConn, connOptions);
                    shutdownMan.addShutdownListener(new ShutdownListener(){

                        public void shutdown() {
                            if (_ldapPool != null) {
                                _ldapPool.destroy();
                            }
                        }
                    });
                }
                finally {
                    shutdownMan.releaseLockAndNotify();
                }
            }
            catch (LDAPException e) {
                debug.error("Exception in DataLayer.initLdapPool:", (Throwable)e);
            }
        }
    }

    public static int getConnNumRetry() {
        return connNumRetry;
    }

    public static int getConnRetryInterval() {
        return connRetryInterval;
    }

    public static HashSet getRetryErrorCodes() {
        return retryErrorCodes;
    }

    private static void initializeEventService() {
        if (!EventService.isThreadStarted()) {
            InitEventServiceThread th = new InitEventServiceThread();
            Thread initEventServiceThread = new Thread((Runnable)th, "InitEventServiceThread");
            initEventServiceThread.setDaemon(true);
            initEventServiceThread.start();
        }
    }

    static {
        i18n = I18n.getInstance("amSDK");
        replicaRetryNum = 1;
        replicaRetryInterval = 1000L;
        connNumRetry = 3;
        connRetryInterval = 1000;
        retryErrorCodes = new HashSet();
        debug = Debug.getInstance((String)"amSDK");
        DataLayer.initConnectionParams();
        _ldapPool = null;
        _trialConn = null;
        _defaultSearchConstraints = null;
        m_instance = null;
        EMPTY_STRING_ARRAY = new String[0];
    }

    private static class InitEventServiceThread
    implements Runnable {
        private InitEventServiceThread() {
        }

        public void run() {
            debug.message("InitEventServiceThread:initializeEventService() - EventService thread getting  initialized ");
            try {
                EventService es = EventService.getEventService();
                if (!EventService.isThreadStarted()) {
                    es.resetAllSearches(false);
                }
            }
            catch (Exception e) {
                debug.error("InitEventServiceThread:run() Unable to start EventService!!", (Throwable)e);
            }
        }
    }
}

