/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.COTUtils;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.shared.debug.Debug;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public class CreateCircleOfTrust
extends AuthenticatedCommand {
    private static Debug debug = COTUtils.debug;
    private String realm;
    private String cot;
    private List trustedProviders;
    private String prefix;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.superAdminUserValidation();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        this.prefix = this.getStringOptionValue("prefix");
        this.trustedProviders = rc.getOption("trustedproviders");
        HashSet providers = new HashSet();
        if (this.trustedProviders != null) {
            providers.addAll(this.trustedProviders);
        }
        String[] params = new String[]{this.realm, this.cot, ((Object)providers).toString(), this.prefix};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_COT", params);
        try {
            CircleOfTrustDescriptor descriptor = this.prefix == null || this.prefix.trim().length() == 0 ? new CircleOfTrustDescriptor(this.cot, this.realm, "active", "", null, null, null, null, providers) : new CircleOfTrustDescriptor(this.cot, this.realm, "active", "", this.prefix + "/idffreader", this.prefix + "/idffwriter", this.prefix + "/saml2reader", this.prefix + "/saml2writer", providers);
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            cotManager.createCircleOfTrust(this.realm, descriptor);
            Object[] objs = new Object[]{this.cot, this.realm};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-circle-of-trust-succeeded"), objs));
            this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_COT", params);
        }
        catch (COTException e) {
            debug.warning("CreateCircleOfTrust.handleRequest", (Throwable)e);
            String[] args = new String[]{this.realm, this.cot, ((Object)providers).toString(), this.prefix, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_CREATE_COT", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

