/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaSecurityUtils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.jaxb.entityconfig.FederationConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationMetadataElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportMetaData
extends AuthenticatedCommand {
    private String metadata;
    private String extendedData;
    private String cot;
    private String realm;
    private String spec;
    private boolean webAccess;

    public void handleRequest(RequestContext rc) throws CLIException {
        block6: {
            super.handleRequest(rc);
            this.ldapLogin();
            this.superAdminUserValidation();
            this.realm = this.getStringOptionValue("realm", "/");
            this.metadata = this.getStringOptionValue("meta-data-file");
            this.extendedData = this.getStringOptionValue("extended-data-file");
            this.cot = this.getStringOptionValue("cot");
            this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
            String[] params = new String[]{this.realm, this.metadata, this.extendedData, this.cot, this.spec};
            this.writeLog(0, Level.INFO, "ATTEMPT_IMPORT_ENTITY", params);
            if (this.metadata == null && this.extendedData == null) {
                String[] args = new String[]{this.realm, this.metadata, this.extendedData, this.cot, this.spec, this.getResourceString("import-entity-exception-no-datafile")};
                this.writeLog(1, Level.INFO, "FAILED_IMPORT_ENTITY", args);
                throw new CLIException(this.getResourceString("import-entity-exception-no-datafile"), 127);
            }
            this.validateCOT();
            CommandManager mgr = this.getCommandManager();
            String url = mgr.getWebEnabledURL();
            this.webAccess = url != null && url.length() > 0;
            try {
                if (this.spec.equals("saml2")) {
                    this.handleSAML2Request(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_IMPORT_ENTITY", params);
                    break block6;
                }
                if (this.spec.equals("idff")) {
                    this.handleIDFFRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_IMPORT_ENTITY", params);
                    break block6;
                }
                if (this.spec.equals("wsfed")) {
                    this.handleWSFedRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_IMPORT_ENTITY", params);
                    break block6;
                }
                throw new CLIException(this.getResourceString("unsupported-specification"), 127);
            }
            catch (CLIException e) {
                String[] args = new String[]{this.realm, this.metadata, this.extendedData, this.cot, this.spec, e.getMessage()};
                this.writeLog(1, Level.INFO, "FAILED_IMPORT_ENTITY", args);
                throw e;
            }
        }
    }

    private void validateCOT() throws CLIException {
        if (this.cot != null && this.cot.length() > 0) {
            try {
                CircleOfTrustManager cotManager = new CircleOfTrustManager();
                if (!cotManager.getAllCirclesOfTrust(this.realm).contains(this.cot)) {
                    String[] args = new String[]{this.realm, this.metadata, this.extendedData, this.cot, this.spec, this.getResourceString("import-entity-exception-cot-no-exist")};
                    this.writeLog(1, Level.INFO, "FAILED_IMPORT_ENTITY", args);
                    throw new CLIException(this.getResourceString("import-entity-exception-cot-no-exist"), 127);
                }
            }
            catch (COTException e) {
                throw new CLIException(e.getMessage(), 127);
            }
        }
    }

    private void handleSAML2Request(RequestContext rc) throws CLIException {
        try {
            CircleOfTrustManager cotManager;
            Object[] objs;
            String out;
            List config;
            SAML2MetaManager metaManager = new SAML2MetaManager();
            String entityID = null;
            EntityConfigElement configElt = null;
            if (this.extendedData != null && (configElt = this.geEntityConfigElement()) != null && configElt.isHosted() && !(config = configElt.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig()).isEmpty()) {
                com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType bConfig = (com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType)config.iterator().next();
                this.realm = SAML2MetaUtils.getRealmByMetaAlias((String)bConfig.getMetaAlias());
            }
            com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement descriptor = null;
            if (this.metadata != null && (descriptor = this.getSAML2EntityDescriptorElement(metaManager)) != null) {
                entityID = descriptor.getEntityID();
            }
            metaManager.createEntity(this.realm, descriptor, configElt);
            if (descriptor != null) {
                out = this.webAccess ? "web" : this.metadata;
                objs = new Object[]{out};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("import-entity-succeeded"), objs));
            }
            if (configElt != null) {
                out = this.webAccess ? "web" : this.extendedData;
                objs = new Object[]{out};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("import-entity-succeeded"), objs));
            }
            if (this.cot != null && this.cot.length() > 0 && entityID != null && entityID.length() > 0 && !(cotManager = new CircleOfTrustManager()).isInCircleOfTrust(this.realm, this.cot, this.spec, entityID)) {
                cotManager.addCircleOfTrustMember(this.realm, this.cot, this.spec, entityID);
            }
        }
        catch (COTException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        catch (SAML2MetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleIDFFRequest(RequestContext rc) throws CLIException {
        try {
            CircleOfTrustManager cotManager;
            IDFFMetaManager metaManager = new IDFFMetaManager((Object)this.getAdminSSOToken());
            String entityID = null;
            com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement configElt = null;
            if (this.extendedData != null && (configElt = this.getIDFFEntityConfigElement()) != null && configElt.isHosted()) {
                IDPDescriptorConfigElement idpConfig = IDFFMetaUtils.getIDPDescriptorConfig((com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement)configElt);
                if (idpConfig != null) {
                    this.realm = SAML2MetaUtils.getRealmByMetaAlias((String)idpConfig.getMetaAlias());
                } else {
                    SPDescriptorConfigElement spConfig = IDFFMetaUtils.getSPDescriptorConfig((com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement)configElt);
                    if (spConfig != null) {
                        this.realm = SAML2MetaUtils.getRealmByMetaAlias((String)spConfig.getMetaAlias());
                    }
                }
            }
            if (this.metadata != null) {
                entityID = this.importIDFFMetaData(this.realm, metaManager);
            }
            if (configElt != null) {
                String out = this.webAccess ? "web" : this.extendedData;
                Object[] objs = new Object[]{out};
                metaManager.createEntityConfig(this.realm, configElt);
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("import-entity-succeeded"), objs));
            }
            if (this.cot != null && this.cot.length() > 0 && entityID != null && entityID.length() > 0 && !(cotManager = new CircleOfTrustManager()).isInCircleOfTrust(this.realm, this.cot, this.spec, entityID)) {
                cotManager.addCircleOfTrustMember(this.realm, this.cot, this.spec, entityID);
            }
        }
        catch (IDFFMetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        catch (COTException e) {
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleWSFedRequest(RequestContext rc) throws CLIException {
        try {
            CircleOfTrustManager cotManager;
            List config;
            String federationID = null;
            FederationConfigElement configElt = null;
            if (this.extendedData != null && (configElt = this.getWSFedEntityConfigElement()) != null && configElt.isHosted() && !(config = configElt.getIDPSSOConfigOrSPSSOConfig()).isEmpty()) {
                BaseConfigType bConfig = (BaseConfigType)config.iterator().next();
                this.realm = WSFederationMetaUtils.getRealmByMetaAlias((String)bConfig.getMetaAlias());
            }
            if (this.metadata != null) {
                federationID = this.importWSFedMetaData();
            }
            if (configElt != null) {
                WSFederationMetaManager.createEntityConfig((String)this.realm, (FederationConfigElement)configElt);
                String out = this.webAccess ? "web" : this.extendedData;
                Object[] objs = new Object[]{out};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("import-entity-succeeded"), objs));
            }
            if (this.cot != null && this.cot.length() > 0 && federationID != null && !(cotManager = new CircleOfTrustManager()).isInCircleOfTrust(this.realm, this.cot, this.spec, federationID)) {
                cotManager.addCircleOfTrustMember(this.realm, this.cot, this.spec, federationID);
            }
        }
        catch (COTException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        catch (WSFederationMetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement getSAML2EntityDescriptorElement(SAML2MetaManager metaManager) throws SAML2MetaException, CLIException {
        InputStream is = null;
        String out = this.webAccess ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        try {
            Object obj;
            Document doc;
            Debug debug = CommandManager.getDebugger();
            if (this.webAccess) {
                doc = XMLUtils.toDOMDocument((String)this.metadata, (Debug)debug);
            } else {
                is = new FileInputStream(this.metadata);
                doc = XMLUtils.toDOMDocument((InputStream)is, (Debug)debug);
            }
            if (doc == null) {
                throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
            }
            Element docElem = doc.getDocumentElement();
            if (!"EntityDescriptor".equals(docElem.getLocalName()) || !"urn:oasis:names:tc:SAML:2.0:metadata".equals(docElem.getNamespaceURI())) {
                throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
            }
            SAML2MetaSecurityUtils.verifySignature((Document)doc);
            ImportMetaData.workaroundAbstractRoleDescriptor(doc);
            if (debug.messageEnabled()) {
                debug.message("ImportMetaData.getSAML2EntityDescriptorElement: modified metadata = " + XMLUtils.print((Node)doc));
            }
            if ((obj = SAML2MetaUtils.convertNodeToJAXB((Node)doc)) instanceof com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement) {
                com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement entityDescriptorElement = (com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement)obj;
                return entityDescriptorElement;
            }
            com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement entityDescriptorElement = null;
            return entityDescriptorElement;
        }
        catch (FileNotFoundException e) {
            throw new CLIException(MessageFormat.format(this.getResourceString("file-not-found"), objs), 127);
        }
        catch (JAXBException e) {
            this.debugWarning("ImportMetaData.importMetaData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
        }
        catch (IllegalArgumentException e) {
            this.debugWarning("ImportMetaData.importMetaData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String importIDFFMetaData(String realm, IDFFMetaManager metaManager) throws IDFFMetaException, CLIException {
        InputStream is = null;
        String out = this.webAccess ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        String entityID = null;
        try {
            Object obj;
            if (this.webAccess) {
                obj = IDFFMetaUtils.convertStringToJAXB((String)this.metadata);
            } else {
                is = new FileInputStream(this.metadata);
                Document doc = XMLUtils.toDOMDocument((InputStream)is, (Debug)CommandManager.getDebugger());
                obj = IDFFMetaUtils.convertNodeToJAXB((Node)doc);
            }
            if (obj instanceof EntityDescriptorElement) {
                EntityDescriptorElement descriptor = (EntityDescriptorElement)obj;
                entityID = descriptor.getProviderID();
                metaManager.createEntityDescriptor(realm, descriptor);
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("import-entity-succeeded"), objs));
            }
            String string = entityID;
            return string;
        }
        catch (FileNotFoundException e) {
            throw new CLIException(MessageFormat.format(this.getResourceString("file-not-found"), objs), 127);
        }
        catch (JAXBException e) {
            this.debugWarning("ImportMetaData.importMetaData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
        }
        catch (IllegalArgumentException e) {
            this.debugWarning("ImportMetaData.importMetaData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String importWSFedMetaData() throws WSFederationMetaException, CLIException {
        InputStream is = null;
        String out = this.webAccess ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        String federationID = null;
        try {
            Object obj;
            if (this.webAccess) {
                obj = WSFederationMetaUtils.convertStringToJAXB((String)this.metadata);
                Document doc = XMLUtils.toDOMDocument((String)this.metadata, (Debug)CommandManager.getDebugger());
            } else {
                is = new FileInputStream(this.metadata);
                Document doc = XMLUtils.toDOMDocument((InputStream)is, (Debug)CommandManager.getDebugger());
                obj = WSFederationMetaUtils.convertNodeToJAXB((Node)doc);
            }
            if (obj instanceof FederationMetadataElement) {
                obj = ((FederationMetadataElement)obj).getAny().get(0);
            }
            if (obj instanceof FederationElement) {
                FederationElement federation = (FederationElement)obj;
                federationID = federation.getFederationID();
                if (federationID == null) {
                    federationID = "sunFMWSFederationDefaultFederationID";
                }
                WSFederationMetaManager.createFederation((String)this.realm, (FederationElement)federation);
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("import-entity-succeeded"), objs));
            }
            String string = federationID;
            return string;
        }
        catch (FileNotFoundException e) {
            throw new CLIException(MessageFormat.format(this.getResourceString("file-not-found"), objs), 127);
        }
        catch (JAXBException e) {
            this.debugWarning("ImportMetaData.importMetaData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
        }
        catch (IllegalArgumentException e) {
            this.debugWarning("ImportMetaData.importMetaData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-descriptor-file"), objs), 127);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private EntityConfigElement geEntityConfigElement() throws SAML2MetaException, CLIException {
        String out = this.webAccess ? "web" : this.extendedData;
        Object[] objs = new Object[]{out};
        InputStream is = null;
        try {
            Object obj = null;
            if (this.webAccess) {
                obj = SAML2MetaUtils.convertStringToJAXB((String)this.extendedData);
            } else {
                is = new FileInputStream(this.extendedData);
                obj = SAML2MetaUtils.convertInputStreamToJAXB((InputStream)is);
            }
            EntityConfigElement entityConfigElement = obj instanceof EntityConfigElement ? (EntityConfigElement)obj : null;
            return entityConfigElement;
        }
        catch (FileNotFoundException e) {
            throw new CLIException(MessageFormat.format(this.getResourceString("file-not-found"), objs), 127);
        }
        catch (JAXBException e) {
            this.debugWarning("ImportMetaData.importExtendedData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-config-file"), objs), 127);
        }
        catch (IllegalArgumentException e) {
            this.debugWarning("ImportMetaData.importExtendedData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-config-file"), objs), 127);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement getIDFFEntityConfigElement() throws IDFFMetaException, CLIException {
        String out = this.webAccess ? "web" : this.extendedData;
        Object[] objs = new Object[]{out};
        try {
            Object obj = this.webAccess ? IDFFMetaUtils.convertStringToJAXB((String)this.extendedData) : IDFFMetaUtils.convertStringToJAXB((String)ImportMetaData.getFileContent(this.extendedData));
            return obj instanceof com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement ? (com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement)obj : null;
        }
        catch (IOException e) {
            throw new CLIException(MessageFormat.format(this.getResourceString("file-not-found"), objs), 127);
        }
        catch (JAXBException e) {
            this.debugWarning("ImportMetaData.importExtendedData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-config-file"), objs), 127);
        }
        catch (IllegalArgumentException e) {
            this.debugWarning("ImportMetaData.importExtendedData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-config-file"), objs), 127);
        }
    }

    private FederationConfigElement getWSFedEntityConfigElement() throws WSFederationMetaException, CLIException {
        String out = this.webAccess ? "web" : this.extendedData;
        Object[] objs = new Object[]{out};
        InputStream is = null;
        try {
            Object obj = null;
            if (this.webAccess) {
                obj = WSFederationMetaUtils.convertStringToJAXB((String)this.extendedData);
            } else {
                is = new FileInputStream(this.extendedData);
                obj = WSFederationMetaUtils.convertInputStreamToJAXB((InputStream)is);
            }
            FederationConfigElement federationConfigElement = obj instanceof FederationConfigElement ? (FederationConfigElement)obj : null;
            return federationConfigElement;
        }
        catch (FileNotFoundException e) {
            throw new CLIException(MessageFormat.format(this.getResourceString("file-not-found"), objs), 127);
        }
        catch (JAXBException e) {
            this.debugWarning("ImportMetaData.importExtendedData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-config-file"), objs), 127);
        }
        catch (IllegalArgumentException e) {
            this.debugWarning("ImportMetaData.importExtendedData", e);
            throw new CLIException(MessageFormat.format(this.getResourceString("import-entity-exception-invalid-config-file"), objs), 127);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(String fileName) throws IOException {
        BufferedReader br = null;
        StringBuffer buff = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            while (line != null) {
                buff.append(line).append("\n");
                line = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return buff.toString();
    }

    public static void workaroundAbstractRoleDescriptor(Document doc) {
        NodeList nl = doc.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");
        int length = nl.getLength();
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Element child = (Element)nl.item(i);
            String type = child.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type == null || !type.equals("AttributeQueryDescriptorType") && !type.endsWith(":AttributeQueryDescriptorType")) continue;
            String newTag = type.substring(0, type.length() - 4);
            String xmlstr = XMLUtils.print((Node)child);
            int index = xmlstr.indexOf("RoleDescriptor");
            xmlstr = "<" + newTag + xmlstr.substring(index + "RoleDescriptor".length());
            if (!xmlstr.endsWith("/>")) {
                index = xmlstr.lastIndexOf("</");
                xmlstr = xmlstr.substring(0, index) + "</" + newTag + ">";
            }
            Document tmpDoc = XMLUtils.toDOMDocument((String)xmlstr, (Debug)CommandManager.getDebugger());
            Node newChild = doc.importNode(tmpDoc.getDocumentElement(), true);
            child.getParentNode().replaceChild(newChild, child);
        }
    }
}

