/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public class CLIUtil {
    private CLIUtil() {
    }

    public static String getFileContent(CommandManager mgr, String fileName) throws CLIException {
        return CLIUtil.getFileContent(mgr, fileName, false);
    }

    public static String getFileContent(CommandManager mgr, String fileName, boolean singleLine) throws CLIException {
        StringBuffer buff;
        block13: {
            File test = new File(fileName);
            if (!test.exists()) {
                Object[] param = new Object[]{fileName};
                throw new CLIException(MessageFormat.format(mgr.getResourceBundle().getString("error-message-file-does-not-exist"), param), 18);
            }
            buff = new StringBuffer();
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(fileName));
                if (!in.ready()) break block13;
                String line = in.readLine();
                while (line != null) {
                    buff.append(line);
                    if (singleLine) {
                        break;
                    }
                    buff.append("\n");
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                throw new CLIException(e.getMessage(), 18);
            }
            finally {
                block14: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            Debug debugger = CommandManager.getDebugger();
                            if (!debugger.warningEnabled()) break block14;
                            debugger.warning("cannot close file, " + fileName, (Throwable)e);
                        }
                    }
                }
            }
        }
        return buff.toString();
    }

    public static Set getPasswordFields(String serviceName) throws SMSException, SSOException {
        ServiceSchema schema;
        HashSet<String> setPasswords = new HashSet<String>();
        SSOToken ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, ssoToken);
        if (ssm != null && (schema = ssm.getOrganizationSchema()) != null) {
            Set attributeSchemas = schema.getAttributeSchemas();
            for (AttributeSchema as : attributeSchemas) {
                if (!as.getSyntax().equals(AttributeSchema.Syntax.PASSWORD)) continue;
                setPasswords.add(as.getName());
            }
        }
        return setPasswords;
    }

    public static Set getPasswordFields(String serviceName, SchemaType schemaType, String subSchema) throws SMSException, SSOException {
        ServiceSchema schema;
        HashSet<String> setPasswords = new HashSet<String>();
        SSOToken ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, ssoToken);
        if (ssm != null && (schema = ssm.getSchema(schemaType)) != null) {
            ServiceSchema ss = schema.getSubSchema(subSchema);
            Set attributeSchemas = ss.getAttributeSchemas();
            for (AttributeSchema as : attributeSchemas) {
                if (!as.getSyntax().equals(AttributeSchema.Syntax.PASSWORD)) continue;
                setPasswords.add(as.getName());
            }
        }
        return setPasswords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String file, String content) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            fout.write(content.getBytes());
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

