/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPReferralException;
import com.sun.identity.shared.ldap.LDAPSearchConstraints;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.LDAPUrl;
import com.sun.identity.shared.ldap.util.DN;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LDAPGroups
implements Subject {
    static final String STATIC_GROUP_MEMBER_ATTR = "uniqueMember";
    static final String STATIC_GROUP_MEMBER_ALT_ATTR = "member";
    static final String DYNAMIC_GROUP_MEMBER_URL = "memberUrl";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedGroupDNs = Collections.EMPTY_SET;
    private Set selectedRFCGroupDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String groupSearchFilter;
    private int groupSearchScope = 2;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String groupRDNAttrName;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private LDAPConnectionPool connPool;
    private boolean localDS;
    private boolean aliasEnabled;
    private String ldapServer;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map configParams) throws PolicyException {
        if (configParams == null) {
            throw new PolicyException("amPolicy", "ldapgroups_initialization_failed", null, null);
        }
        String configuredLdapServer = (String)configParams.get("iplanet-am-policy-config-ldap-server");
        if (configuredLdapServer == null) {
            debug.error("LDAPGroups.initialize(): failed to get LDAP server name. If you enter more than one server name in the policy config service's Primary LDAP Server field, please make sure the ldap server name is preceded with the local server name.");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        this.ldapServer = configuredLdapServer.toLowerCase();
        this.localDS = PolicyUtils.isLocalDS(this.ldapServer);
        this.aliasEnabled = Boolean.valueOf((String)configParams.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)configParams.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)configParams.get("iplanet-am-policy-config-ldap-bind-password");
        if (this.authpw != null) {
            this.authpw = PolicyUtils.decrypt(this.authpw);
        }
        this.baseDN = (String)configParams.get("iplanet-am-policy-config-ldap-base-dn");
        this.groupSearchFilter = (String)configParams.get("iplanet-am-policy-config-ldap-groups-search-filter");
        String scope = (String)configParams.get("iplanet-am-policy-config-ldap-groups-search-scope");
        this.groupSearchScope = scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.groupRDNAttrName = (String)configParams.get("iplanet-am-policy-config-ldap-groups-search-attribute");
        this.userSearchFilter = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-filter");
        scope = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException nfe) {
            throw new PolicyException(nfe);
        }
        String ssl = (String)configParams.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = ssl.equalsIgnoreCase("true");
        Set orgNameSet = (Set)configParams.get("OrganizationName");
        if (orgNameSet != null && orgNameSet.size() != 0) {
            Iterator items = orgNameSet.iterator();
            this.orgName = (String)items.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.initialize(): getting params\nldapServer: " + this.ldapServer + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\ngroupSearchFilter: " + this.groupSearchFilter + "\ngroupRDNAttrName: " + this.groupRDNAttrName + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(this.ldapServer, this.authid, this.authpw, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(this.ldapServer);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken token) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldapgroups_subject_not_yet_initialized", null, null);
        }
        HashSet<String> validGroupDNs = new HashSet<String>();
        String searchFilter = null;
        searchFilter = pattern != null && pattern.trim().length() != 0 ? "(&" + this.groupSearchFilter + "(" + this.groupRDNAttrName + "=" + pattern + "))" : this.groupSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.getValidValues(): group search filter is: " + searchFilter);
        }
        String[] attrs = new String[]{this.groupRDNAttrName};
        LDAPConnection ld = this.connPool.getConnection();
        LDAPSearchConstraints constraints = ld.getSearchConstraints();
        constraints.setMaxResults(this.maxResults);
        constraints.setServerTimeLimit(this.timeLimit);
        int status = 0;
        try {
            ld.authenticate(this.authid, this.authpw);
            LDAPSearchResults res = ld.search(this.baseDN, this.groupSearchScope, searchFilter, attrs, false, constraints);
            while (res.hasMoreElements()) {
                try {
                    LDAPEntry entry = res.next();
                    if (entry == null) continue;
                    validGroupDNs.add(entry.getDN());
                    if (!debug.messageEnabled()) continue;
                    debug.message("LDAPGroups.getValidValues(): found group name=" + entry.getDN());
                }
                catch (LDAPReferralException lre) {
                }
                catch (LDAPException le) {
                    String[] objs = new String[]{this.orgName};
                    int resultCode = le.getLDAPResultCode();
                    if (resultCode == 4) {
                        debug.warning("LDAPGroups.getValidValues(): exceeded the size limit");
                        status = 1;
                        continue;
                    }
                    if (resultCode != 3) throw new PolicyException(le);
                    debug.warning("LDAPGroups.getValidValues(): exceeded the time limit");
                    status = 2;
                    continue;
                    return new ValidValues(status, validGroupDNs);
                }
            }
        }
        catch (LDAPException lde) {
            int ldapErrorCode = lde.getLDAPResultCode();
            if (ldapErrorCode == 49) {
                throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
            }
            if (ldapErrorCode == 32) {
                Object[] objs = new String[]{this.baseDN};
                throw new PolicyException("amPolicy", "no_such_ldap_base_dn", objs, null);
            }
            String errorMsg = lde.getLDAPErrorMessage();
            String additionalMsg = lde.errorCodeToString();
            if (additionalMsg == null) throw new PolicyException(errorMsg);
            throw new PolicyException(errorMsg + ": " + additionalMsg);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        finally {
            this.connPool.close(ld);
        }
    }

    public String getDisplayNameForValue(String value, Locale locale) throws NameNotFoundException {
        return PolicyUtils.getDNDisplayString(value);
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.getValues() gets called");
        }
        return this.selectedGroupDNs;
    }

    public void setValues(Set names) throws InvalidNameException {
        if (names == null) {
            debug.error("LDAPGroups.setValues(): Invalid names");
            throw new InvalidNameException("amPolicy", "ldapgroups_subject_invalid_group_names", null, null, 5);
        }
        this.selectedGroupDNs = new HashSet();
        this.selectedGroupDNs.addAll(names);
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.setValues(): selected group names=" + this.selectedGroupDNs);
        }
        this.selectedRFCGroupDNs = new HashSet();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            this.selectedRFCGroupDNs.add(new DN((String)it.next()).toRFCString().toLowerCase());
        }
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        if (token == null) {
            return false;
        }
        boolean listenerAdded = false;
        String tokenID = ((Object)token.getTokenID()).toString();
        String userLocalDN = token.getPrincipal().getName();
        DN userDN = null;
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMember(): user local DN is " + userLocalDN);
        }
        if (this.selectedRFCGroupDNs.size() > 0) {
            Iterator groupsIter = this.selectedRFCGroupDNs.iterator();
            String userRDN = null;
            while (groupsIter.hasNext()) {
                Boolean matchFound = null;
                String groupDN = (String)groupsIter.next();
                matchFound = SubjectEvaluationCache.isMember(tokenID, this.ldapServer, groupDN);
                if (matchFound != null) {
                    boolean result;
                    if (debug.messageEnabled()) {
                        debug.message("LDAPGroups.isMember():Got membership from cache of " + userLocalDN + " in group " + groupDN + " :" + matchFound);
                    }
                    if (!(result = matchFound.booleanValue())) continue;
                    return result;
                }
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups:isMember():entry for " + groupDN + " not in subject evaluation cache,fetching from " + "directory server.");
                }
                if (userDN == null) {
                    int beginIndex = userLocalDN.indexOf("=");
                    int endIndex = userLocalDN.indexOf(",");
                    if (beginIndex <= 0 || endIndex <= 0 || beginIndex >= endIndex) {
                        throw new PolicyException("amPolicy", "ldapgroups_subject_invalid_local_user_dn", null, null);
                    }
                    String userName = userLocalDN.substring(beginIndex + 1, endIndex);
                    userRDN = PolicyUtils.constructUserFilter(token, this.userRDNAttrName, userName, this.aliasEnabled);
                    userDN = this.localDS && !PolicyUtils.principalNameEqualsUuid(token) ? new DN(userLocalDN) : this.getUserDN(userRDN);
                    if (userDN == null) {
                        if (debug.messageEnabled()) {
                            debug.message("LDAPGroups.isMember(): User " + userLocalDN + " is not found in the directory");
                        }
                        return false;
                    }
                }
                if (!listenerAdded && !PolicyEvaluator.ssoListenerRegistry.containsKey(tokenID)) {
                    token.addSSOTokenListener(PolicyEvaluator.ssoListener);
                    PolicyEvaluator.ssoListenerRegistry.put(tokenID, PolicyEvaluator.ssoListener);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPGroups.isMember(): sso listener added .\n");
                    }
                    listenerAdded = true;
                }
                if (!this.isMemberOfGroup(groupDN, userDN, userRDN, token)) continue;
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups.isMember(): User " + userDN.toRFCString() + " is a member of this LDAPGroups.");
                }
                return true;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMember(): User " + userLocalDN + " is not a member of this LDAPGroups.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMemberOfGroup(String groupName, DN userDN, String userRDN, SSOToken token) throws SSOException, PolicyException {
        DN memberDN;
        String memberDNStr;
        Enumeration enumVals;
        LDAPAttribute attribute;
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMemberOfGroup(): entering with groupName = " + groupName + ",userDN = " + userDN);
        }
        if (groupName == null || groupName.length() == 0 || userDN == null) {
            return false;
        }
        String tokenID = ((Object)token.getTokenID()).toString();
        boolean groupMatch = false;
        LDAPConnection ld = this.connPool.getConnection();
        LDAPEntry groupEntry = null;
        try {
            ld.authenticate(this.authid, this.authpw);
            groupEntry = ld.read(groupName);
        }
        catch (Exception e) {
            debug.warning("LDAPGroups: invalid group name " + groupName + " specified in the policy definition.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.connPool.close(ld);
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMemberOfGroup(): get uniqueMember group attribute");
        }
        if ((attribute = groupEntry.getAttribute(STATIC_GROUP_MEMBER_ATTR)) != null) {
            enumVals = attribute.getStringValues();
            while (enumVals != null && enumVals.hasMoreElements()) {
                memberDNStr = (String)enumVals.nextElement();
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups.isMemberOfGroup(): memberDNStr = " + memberDNStr);
                }
                if (!userDN.equals(memberDN = new DN(memberDNStr))) continue;
                groupMatch = true;
                break;
            }
        }
        if (!groupMatch) {
            if (debug.messageEnabled()) {
                debug.message("LDAPGroups.isMemberOfGroup(): get member group attribute");
            }
            if ((attribute = groupEntry.getAttribute(STATIC_GROUP_MEMBER_ALT_ATTR)) != null) {
                enumVals = attribute.getStringValues();
                while (enumVals != null && enumVals.hasMoreElements()) {
                    memberDNStr = (String)enumVals.nextElement();
                    if (debug.messageEnabled()) {
                        debug.message("LDAPGroups.isMemberOfGroup(): memberDNStr = " + memberDNStr);
                    }
                    if (!userDN.equals(memberDN = new DN(memberDNStr))) continue;
                    groupMatch = true;
                    break;
                }
            }
        }
        if (!groupMatch && (attribute = groupEntry.getAttribute(DYNAMIC_GROUP_MEMBER_URL)) != null) {
            enumVals = attribute.getStringValues();
            block9: while (enumVals != null && enumVals.hasMoreElements()) {
                String memberUrl = (String)enumVals.nextElement();
                try {
                    LDAPUrl ldapUrl = new LDAPUrl(memberUrl);
                    Set members = this.findDynamicGroupMembersByUrl(ldapUrl, userRDN);
                    for (String memberDNStr2 : members) {
                        DN memberDN2 = new DN(memberDNStr2);
                        if (!userDN.equals(memberDN2)) continue;
                        groupMatch = true;
                        continue block9;
                    }
                }
                catch (MalformedURLException e) {
                    throw new PolicyException(e);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMemberOfGroup():adding entry " + tokenID + " " + this.ldapServer + " " + groupName + " " + groupMatch + " in subject evaluation cache.");
        }
        SubjectEvaluationCache.addEntry(tokenID, this.ldapServer, groupName, groupMatch);
        return groupMatch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set findDynamicGroupMembersByUrl(LDAPUrl url, String userRDN) throws PolicyException {
        LDAPConnection ld = this.connPool.getConnection();
        LDAPSearchConstraints constraints = ld.getSearchConstraints();
        constraints.setMaxResults(this.maxResults);
        constraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> groupMemberDNs = new HashSet<String>();
        try {
            ld.authenticate(this.authid, this.authpw);
            StringBuffer filter = new StringBuffer(25);
            filter.append("(&").append(userRDN);
            String groupFilter = url.getFilter();
            int index = groupFilter.indexOf("(");
            if (index != 0) {
                filter.append("(").append(groupFilter).append("))");
            } else {
                filter.append(groupFilter).append(")");
            }
            if (debug.messageEnabled()) {
                debug.message("search filter in LDAPGroups : " + filter);
            }
            String[] attrs = new String[]{this.userRDNAttrName};
            LDAPSearchResults res = ld.search(url.getDN(), url.getScope(), filter.toString(), attrs, false, constraints);
            while (res.hasMoreElements()) {
                try {
                    LDAPEntry entry = res.next();
                    if (entry == null) continue;
                    groupMemberDNs.add(entry.getDN());
                }
                catch (LDAPReferralException lre) {
                }
                catch (LDAPException le) {
                    Object[] objs = new String[]{this.orgName};
                    int resultCode = le.getLDAPResultCode();
                    if (resultCode == 4) {
                        debug.warning("LDAPGroups.findDynamicGroupMembersByUrl(): exceeded the size limit");
                        throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objs, null);
                    }
                    if (resultCode != 3) throw new PolicyException(le);
                    debug.warning("LDAPGroups.findDynamicGroupMembersByUrl(): exceeded the time limit");
                    throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objs, null);
                    return groupMemberDNs;
                }
            }
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        finally {
            this.connPool.close(ld);
        }
    }

    public int hashCode() {
        return ((Object)this.selectedGroupDNs).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LDAPGroups) {
            LDAPGroups g = (LDAPGroups)o;
            if (this.selectedGroupDNs != null && g.selectedGroupDNs != null && ((Object)this.selectedGroupDNs).equals(g.selectedGroupDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        LDAPGroups theClone = null;
        try {
            theClone = (LDAPGroups)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.selectedGroupDNs != null) {
            theClone.selectedGroupDNs = new HashSet();
            theClone.selectedGroupDNs.addAll(this.selectedGroupDNs);
        }
        if (this.selectedRFCGroupDNs != null) {
            theClone.selectedRFCGroupDNs = new HashSet();
            theClone.selectedRFCGroupDNs.addAll(this.selectedRFCGroupDNs);
        }
        return theClone;
    }

    /*
     * Exception decompiling
     */
    private DN getUserDN(String userRDN) throws SSOException, PolicyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

