/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class AddPrivileges
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        List privileges = rc.getOption("privileges");
        IdType idType = this.convert2IdType(type);
        String[] params = new String[]{realm, type, idName};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_ADD_PRIVILEGES", params);
            DelegationManager mgr = new DelegationManager(adminSSOToken, realm);
            Set privilegeObjects = mgr.getPrivileges();
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            String uid = amid.getUniversalId();
            DelegationPrivilege newDp = null;
            for (String name : privileges) {
                HashSet<String> subjects;
                DelegationPrivilege dp = this.getDelegationPrivilege(name, privilegeObjects);
                if (dp != null) {
                    subjects = dp.getSubjects();
                    if (!subjects.contains(uid)) {
                        subjects.add(uid);
                        newDp = new DelegationPrivilege(name, subjects, realm);
                        mgr.addPrivilege(newDp);
                        continue;
                    }
                    String[] args = new String[]{idName, name};
                    String msg = MessageFormat.format(this.getResourceString("delegation-already-has-privilege"), args);
                    throw new CLIException(msg, 127);
                }
                subjects = new HashSet<String>(2);
                subjects.add(uid);
                newDp = new DelegationPrivilege(name, subjects, realm);
                mgr.addPrivilege(newDp);
            }
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("idrepo-add-privileges-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_ADD_PRIVILEGES", params);
        }
        catch (DelegationException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("AddPrivileges.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_ADD_PRIVILEGES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("AddPrivileges.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_ADD_PRIVILEGES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

