/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.Syntax;
import com.sun.identity.sm.AttributeSchema;

public class AMDisplayType {
    private static AMDisplayType instance = new AMDisplayType();
    public static final int UNDEFINED_SYNTAX = -9;
    public static final int NONE_SYNTAX = -1;
    public static final int SYNTAX_TEXT = 0;
    public static final int SYNTAX_BOOLEAN = 1;
    public static final int SYNTAX_TEXTFIELD = 2;
    public static final int SYNTAX_PASSWORD = 3;
    public static final int SYNTAX_ENCRYPTED_PASSWORD = 4;
    public static final int SYNTAX_PARAGRAPH = 5;
    public static final int SYNTAX_RADIO = 6;
    public static final int SYNTAX_LINK = 7;
    public static final int SYNTAX_BUTTON = 8;
    public static final int SYNTAX_NAME_VALUE_LIST = 9;
    public static final int SYNTAX_SINGLE_CHOICE = 10;
    public static final int SYNTAX_MULTIPLE_CHOICE = 11;
    public static final int SYNTAX_LIST = 12;
    public static final int DEFAULT_SYNTAX = 2;
    public static final int TYPE_SINGLE = 0;
    public static final int TYPE_SINGLE_CHOICE = 1;
    public static final int TYPE_MULTIPLE_CHOICE = 2;
    public static final int TYPE_LIST = 3;
    public static final int DEFAULT_TYPE = 0;

    public static AMDisplayType getInstance() {
        return instance;
    }

    private AMDisplayType() {
    }

    public static int getDisplayType(ActionSchema actionSchema) {
        int displayType = 0;
        AttributeSchema.Type type = actionSchema.getType();
        if (type.equals(AttributeSchema.Type.LIST)) {
            displayType = 3;
        } else if (type.equals(AttributeSchema.Type.SINGLE_CHOICE)) {
            displayType = 1;
        } else if (type.equals(AttributeSchema.Type.MULTIPLE_CHOICE)) {
            displayType = 2;
        }
        return displayType;
    }

    public static int getDisplaySyntax(ActionSchema actionSchema) {
        int displaySyntax = AMDisplayType.getDisplaySyntaxFromUIType(actionSchema);
        if (displaySyntax == -9) {
            displaySyntax = AMDisplayType.getDisplaySyntax(actionSchema.getSyntax());
        }
        return displaySyntax;
    }

    public static int getDisplaySyntax(AttributeSchema.Syntax syntax) {
        int displaySyntax = 2;
        if (syntax.equals(AttributeSchema.Syntax.BOOLEAN)) {
            displaySyntax = 1;
        } else if (syntax.equals(AttributeSchema.Syntax.PASSWORD)) {
            displaySyntax = 3;
        } else if (syntax.equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            displaySyntax = 4;
        } else if (syntax.equals(AttributeSchema.Syntax.PARAGRAPH) || syntax.equals(AttributeSchema.Syntax.XML)) {
            displaySyntax = 5;
        }
        return displaySyntax;
    }

    public static int getDisplaySyntax(Syntax syntax) {
        int displaySyntax = -1;
        if (!syntax.equals(Syntax.ANY_SEARCHABLE)) {
            if (syntax.equals(Syntax.ANY)) {
                displaySyntax = 2;
            } else if (syntax.equals(Syntax.SINGLE_CHOICE)) {
                displaySyntax = 10;
            } else if (syntax.equals(Syntax.MULTIPLE_CHOICE)) {
                displaySyntax = 11;
            } else if (syntax.equals(Syntax.LIST)) {
                displaySyntax = 12;
            }
        }
        return displaySyntax;
    }

    private static int getDisplaySyntaxFromUIType(ActionSchema actionSchema) {
        int displaySyntax = -9;
        AttributeSchema.UIType uiType = actionSchema.getUIType();
        if (uiType != null) {
            if (uiType == AttributeSchema.UIType.RADIO) {
                displaySyntax = 6;
            } else if (uiType == AttributeSchema.UIType.LINK) {
                displaySyntax = 7;
            } else if (uiType == AttributeSchema.UIType.BUTTON) {
                displaySyntax = 8;
            } else if (uiType == AttributeSchema.UIType.NAME_VALUE_LIST) {
                displaySyntax = 9;
            }
        }
        return displaySyntax;
    }
}

