/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.messageid;

import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.LogMessageProviderBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class MessageProviderFactory {
    public static final String DEFAULT_MESSAGE_ID_XML_DIR = "com/sun/identity/log/messageid";
    public static final String MESSAGEID_XML_SUFFIX = "LogMessageIDs.xml";
    private static MessageProviderFactory instance = new MessageProviderFactory();
    private Map mapProviders = new HashMap();

    private MessageProviderFactory() {
    }

    public static LogMessageProvider getProvider(String name) throws IOException {
        return instance.getMessageProvider(name, null);
    }

    public static LogMessageProvider getProvider(String name, String packageName) throws IOException {
        return instance.getMessageProvider(name, packageName);
    }

    private synchronized LogMessageProvider getMessageProvider(String name, String packageName) throws IOException {
        LogMessageProvider p = (LogMessageProvider)this.mapProviders.get(name);
        if (p == null) {
            if (packageName == null) {
                packageName = DEFAULT_MESSAGE_ID_XML_DIR;
            }
            p = new LogMessageProviderBase(packageName + "/" + name + MESSAGEID_XML_SUFFIX);
            this.mapProviders.put(name, p);
        }
        return p;
    }
}

