/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

public class RegisterAuthModule
extends SchemaCommand {
    static final String AUTH_MODULE = "authmodule";
    static final String AUTH_AUTHENTICATOR_ATTR = "iplanet-am-auth-authenticators";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String authModule = this.getStringOptionValue(AUTH_MODULE);
        ServiceSchema ss = this.getServiceSchema("iPlanetAMAuthService", null, "Global");
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{"iPlanetAMAuthService"};
            this.writeLog(0, Level.INFO, "ATTEMPT_REGISTER_AUTH_MODULE", params);
            Map attrValues = ss.getAttributeDefaults();
            HashSet<String> values = (HashSet<String>)attrValues.get(AUTH_AUTHENTICATOR_ATTR);
            if (values == null || values.isEmpty()) {
                values = new HashSet<String>(2);
            }
            values.add(authModule);
            ss.setAttributeDefaults(AUTH_AUTHENTICATOR_ATTR, values);
            this.writeLog(0, Level.INFO, "SUCCEED_REGISTER_AUTH_MODULE", params);
            outputWriter.printlnMessage(this.getResourceString("register-auth-module-succeeded"));
        }
        catch (SSOException e) {
            String[] args = new String[]{"iPlanetAMAuthService", e.getMessage()};
            this.debugError("RegisterAuthModule.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REGISTER_AUTH_MODULE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{"iPlanetAMAuthService", e.getMessage()};
            this.debugError("RegisterAuthModule.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REGISTER_AUTH_MODULE", args);
            throw new CLIException(e, 127);
        }
    }
}

