/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.util;

import java.net.MalformedURLException;

public class RelaxedURL {
    private String protocol;
    private String hostname;
    private String port;
    private String path;
    private String query;

    public RelaxedURL(String url) throws MalformedURLException {
        int idx = this.getProtocol(url);
        this.parseURL(url, idx);
    }

    private int getProtocol(String url) throws MalformedURLException {
        if (url.startsWith("https://")) {
            this.protocol = "https";
            return 8;
        }
        if (url.startsWith("http://")) {
            this.protocol = "http";
            return 7;
        }
        int idx = url.indexOf("://");
        if (idx == -1) {
            throw new MalformedURLException(url);
        }
        this.protocol = url.substring(0, idx);
        return idx + 3;
    }

    private void parseURL(String url, int begins) {
        int slash;
        int colon = url.indexOf(":", begins);
        if (colon == -1) {
            if (this.protocol.equals("http")) {
                this.port = "80";
            } else if (this.protocol.equals("https")) {
                this.port = "443";
            }
            slash = url.indexOf(47, begins);
            if (slash == -1) {
                this.hostname = url.substring(begins);
                this.path = "/";
            } else {
                this.hostname = url.substring(begins, slash);
                this.path = url.substring(slash);
            }
        } else {
            this.hostname = url.substring(begins, colon);
            slash = url.indexOf(47, colon);
            if (slash == -1) {
                this.port = url.substring(colon + 1);
                this.path = "/";
            } else {
                this.port = url.substring(colon + 1, slash);
                this.path = url.substring(slash);
            }
        }
        int idx = this.path.indexOf(63);
        if (idx == -1) {
            this.query = "";
        } else {
            this.query = this.path.substring(idx + 1);
            this.path = this.path.substring(0, idx);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPath() {
        return this.path;
    }

    public String getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQuery() {
        return this.query;
    }
}

