/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.ILogRecord;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class DBFormatter
extends Formatter {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private ITimestampGenerator secureTimestampGenerator;
    private String dateTimeFormat = null;
    private boolean isMySQL = false;

    public DBFormatter() {
        String timestampGeneratorClass = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clz = Class.forName(timestampGeneratorClass);
            this.secureTimestampGenerator = (ITimestampGenerator)clz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("DBFormatter: TimeStamp Generator Class not found", cnfe);
        }
        catch (InstantiationException ie) {
            Debug.error("DBFormatter: Timestamp Generator Could not be Instantiated", ie);
        }
        catch (IllegalAccessException iae) {
            Debug.error("DBFormatter: Timestamp Generator Could not be Instantiated", iae);
        }
        String driver = this.lmanager.getProperty("iplanet-am-logging-db-driver");
        if (driver == null || driver.length() == 0) {
            Debug.error("DBFormatter:DB driver not provided; assume not MySQL");
        } else if (driver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
            this.dateTimeFormat = this.lmanager.getProperty("sun-am-logging-ora-dbdate-format");
        } else if (driver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
            this.dateTimeFormat = this.lmanager.getProperty("sun-am-logging-mysql-dbdate-format");
        } else {
            this.isMySQL = false;
            this.dateTimeFormat = this.lmanager.getProperty("sun-am-logging-ora-dbdate-format");
            Debug.error("DBFormatter:assuming driver: '" + driver + "' is Oracle-compatible.");
        }
    }

    public String getHead(Handler h) {
        String retString = this.lmanager.getProperty("iplanet-am-logging-allfields");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter: Returned String from getHead is " + retString);
        }
        return retString;
    }

    public String getTail(Handler h) {
        return "";
    }

    public String format(LogRecord logRecord) {
        StringBuffer sbuffer = new StringBuffer();
        String strTime = this.secureTimestampGenerator != null ? this.secureTimestampGenerator.getTimestamp() : "";
        String toDate = null;
        toDate = !this.isMySQL ? "TO_DATE('" : "STR_TO_DATE('";
        sbuffer.append(toDate);
        sbuffer.append(strTime);
        sbuffer.append("', '");
        sbuffer.append(this.dateTimeFormat);
        sbuffer.append("'), ");
        String tstr = this.formatMessage(logRecord);
        if (tstr == null || tstr.length() <= 0) {
            tstr = "Not Available";
        } else if (tstr.length() > 0) {
            String str1 = tstr;
            if (tstr.indexOf("'") != -1) {
                str1 = this.checkEscapes(tstr, "'", "''");
            }
            String str2 = str1;
            if (this.isMySQL && str1.indexOf("\\") != -1) {
                str2 = this.checkEscapes(str1, "\\", "\\\\");
            }
            tstr = str2;
        }
        sbuffer.append("'").append(tstr).append("', ");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:thisfield3 = #" + sbuffer.toString() + "#");
        }
        String[] allFields = this.lmanager.getAllFields();
        Set selectedFields = this.lmanager.getSelectedFieldSet();
        int len = 0;
        if (allFields != null) {
            len = allFields.length;
        }
        Map logInfoTable = logRecord.getLogInfoMap();
        for (int i = 2; i < len - 1; ++i) {
            if (logInfoTable != null && selectedFields != null && selectedFields.contains(allFields[i])) {
                String tempstr = (String)logInfoTable.get(allFields[i]);
                if (tempstr != null && tempstr.length() > 0 && tempstr.indexOf("'") != -1) {
                    StringTokenizer tmps = new StringTokenizer(tempstr, "'");
                    StringBuffer thisfield = new StringBuffer();
                    if (Debug.messageEnabled()) {
                        Debug.message("DBFormatter:found single-quote in: " + tempstr);
                    }
                    if (tempstr.indexOf("'") == 0) {
                        thisfield.append("''");
                        if (tmps.hasMoreTokens()) {
                            thisfield.append(tmps.nextToken());
                        }
                    } else if (tmps.hasMoreTokens()) {
                        thisfield.append(tmps.nextToken());
                    }
                    while (tmps.hasMoreTokens()) {
                        thisfield.append("''").append(tmps.nextToken());
                    }
                    if (tempstr.indexOf("'", tempstr.length() - 1) != -1) {
                        thisfield.append("''");
                    }
                    tempstr = thisfield.toString();
                }
                if (tempstr == null) {
                    tempstr = "Not Available";
                }
                sbuffer.append("'").append(tempstr).append("', ");
                continue;
            }
            sbuffer.append("'").append("Not Available").append("'").append(", ");
        }
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format1: sbuffer = " + sbuffer.toString());
        }
        if (selectedFields.contains(allFields[len - 1])) {
            String tmpstr = (String)logInfoTable.get(allFields[len - 1]);
            if (tmpstr == null) {
                tmpstr = "Not Available";
            }
            sbuffer.append("'").append(tmpstr).append("'");
        } else {
            sbuffer.append("'").append("Not Available").append("'");
        }
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format2: sbuffer = " + sbuffer.toString());
        }
        return sbuffer.toString();
    }

    public String format(java.util.logging.LogRecord logRecord) {
        if (LogManagerUtil.isAMLoggingMode() && logRecord instanceof ILogRecord) {
            return this.format((LogRecord)logRecord);
        }
        String strTime = this.secureTimestampGenerator != null ? this.secureTimestampGenerator.getTimestamp() : "";
        StringBuffer sbuffer = new StringBuffer();
        String toDate = null;
        toDate = !this.isMySQL ? "TO_DATE('" : "STR_TO_DATE('";
        sbuffer.append(toDate);
        sbuffer.append(strTime);
        sbuffer.append("', '");
        sbuffer.append(this.dateTimeFormat);
        sbuffer.append("'), ");
        String tstr = this.formatMessage(logRecord);
        if (tstr == null || tstr.length() <= 0) {
            tstr = "Not Available";
        } else if (tstr.length() > 0) {
            String str1 = tstr;
            if (tstr.indexOf("'") != -1) {
                str1 = this.checkEscapes(tstr, "'", "''");
            }
            String str2 = str1;
            if (this.isMySQL && str1.indexOf("\\") != -1) {
                str2 = this.checkEscapes(str1, "\\", "\\\\");
            }
            tstr = str2;
        }
        sbuffer.append("'").append(tstr).append("', ");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:thisfield3 = #" + sbuffer.toString() + "#");
        }
        String[] allFields = this.lmanager.getAllFields();
        int len = 0;
        if (allFields != null) {
            len = allFields.length;
        }
        for (int i = 2; i < len - 1; ++i) {
            sbuffer.append("'Not Available'").append(", ");
        }
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format1: sbuffer = " + sbuffer.toString());
        }
        sbuffer.append("'").append("Not Available").append("'");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format2: sbuffer = " + sbuffer.toString());
        }
        return sbuffer.toString();
    }

    private String checkEscapes(String theString, String charToEscape, String doubledChar) {
        StringTokenizer tmps = new StringTokenizer(theString, charToEscape);
        StringBuffer thisfield = new StringBuffer();
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:looking for " + charToEscape + " in data: " + theString);
        }
        if (theString.indexOf(charToEscape) == 0) {
            thisfield.append(doubledChar);
            if (tmps.hasMoreTokens()) {
                thisfield.append(tmps.nextToken());
            }
            if (Debug.messageEnabled()) {
                Debug.message("DBFormatter:thisfield1 = #" + thisfield.toString() + "#");
            }
        } else if (tmps.hasMoreTokens()) {
            thisfield.append(tmps.nextToken());
        }
        while (tmps.hasMoreTokens()) {
            thisfield.append(doubledChar).append(tmps.nextToken());
            if (!Debug.messageEnabled()) continue;
            Debug.message("DBFormatter:thisfield2 = #" + thisfield.toString() + "#");
        }
        if (theString.indexOf(charToEscape, theString.length() - 1) != -1) {
            thisfield.append(doubledChar);
        }
        return thisfield.toString();
    }
}

