/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.session.util;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Crypt;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class SessionUtils {
    public static final short QUERY = 0;
    public static final short SLASH = 1;
    public static final short SEMICOLON = 2;
    static Debug debug = Debug.getInstance((String)"amSessionUtils");
    private static Set trustedSources = null;
    private static final String httpClientIPHeader = SystemProperties.get("com.sun.identity.session.httpClientIPHeader", "proxy-ip");
    private static final boolean SESSION_ENCRYPTION = Boolean.valueOf(SystemProperties.get("com.sun.identity.session.repository.enableEncryption", "false"));

    public static String getSessionId(HttpServletRequest request) {
        String sidString = new SessionID(request).toString();
        if (sidString.length() == 0) {
            sidString = null;
        }
        return sidString;
    }

    public static String encodeURL(SSOToken ssoToken, String url, short encodingScheme, boolean escape) throws SSOException {
        String encodedURL = url;
        try {
            SSOTokenID ssoTokenId = ssoToken.getTokenID();
            SessionID sessionID = new SessionID(((Object)ssoTokenId).toString());
            Session session = Session.getSession(sessionID);
            encodedURL = session.encodeURL(url, encodingScheme, escape);
        }
        catch (Exception e) {
            debug.message("Exception encoding URL ", (Throwable)e);
            throw new SSOException(e);
        }
        return encodedURL;
    }

    public static String encodeURL(SSOToken ssoToken, String url, boolean escape) throws SSOException {
        String encodedURL = url;
        try {
            encodedURL = SessionUtils.encodeURL(ssoToken, url, (short)0, escape);
        }
        catch (Exception e) {
            debug.message("Exception encoding url", (Throwable)e);
            throw new SSOException(e);
        }
        return encodedURL;
    }

    public static InetAddress getClientAddress(HttpServletRequest servletRequest) throws Exception {
        String proxyHeader;
        InetAddress remoteClient = InetAddress.getByName(servletRequest.getRemoteAddr());
        if (SessionUtils.isTrustedSource(remoteClient) && (proxyHeader = servletRequest.getHeader(httpClientIPHeader)) != null) {
            remoteClient = InetAddress.getByName(proxyHeader);
        }
        return remoteClient;
    }

    private static Set getTrustedSourceList() throws SessionException {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        try {
            String rawList = SystemProperties.get("com.sun.am.session.trustedSourceList");
            if (rawList != null) {
                StringTokenizer stk = new StringTokenizer(rawList, ",");
                while (stk.hasMoreTokens()) {
                    result.add(InetAddress.getByName(stk.nextToken()));
                }
            } else {
                Vector psl = WebtopNaming.getPlatformServerList();
                if (psl == null) {
                    throw new SessionException(SessionBundle.rbName, "emptyTrustedSourceList", null);
                }
                Enumeration e = psl.elements();
                while (e.hasMoreElements()) {
                    URL url = new URL((String)e.nextElement());
                    result.add(InetAddress.getByName(url.getHost()));
                }
            }
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
        return result;
    }

    public static boolean isTrustedSource(InetAddress source) throws SessionException {
        if (trustedSources == null) {
            trustedSources = SessionUtils.getTrustedSourceList();
        }
        return trustedSources.contains(source);
    }

    public static byte[] encode(Object obj) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOutStream = new ObjectOutputStream(byteOut);
        objOutStream.writeObject(obj);
        objOutStream.close();
        final byte[] blob = byteOut.toByteArray();
        if (SESSION_ENCRYPTION) {
            return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Crypt.getEncryptor().encrypt(blob);
                }
            });
        }
        return blob;
    }

    public static Object decode(final byte[] blob) throws Exception {
        byte[] decryptedBlob = SESSION_ENCRYPTION ? (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return Crypt.getEncryptor().decrypt(blob);
            }
        }) : blob;
        ByteArrayInputStream byteIn = new ByteArrayInputStream(decryptedBlob);
        ObjectInputStream objInStream = new ObjectInputStream(byteIn);
        return objInStream.readObject();
    }

    public static String getEncryptedStorageKey(SessionID sessionID) throws Exception {
        String sKey = sessionID.getExtension("SK");
        if (SESSION_ENCRYPTION) {
            String strEncrypted = (String)AccessController.doPrivileged(new EncodeAction(sKey, Crypt.getHardcodedKeyEncryptor()));
            return strEncrypted;
        }
        return sKey;
    }

    public static SSOToken getAdminToken() throws SSOException {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (adminToken == null) {
            I18n i18n = I18n.getInstance("amSDK");
            String rbName = i18n.getResBundleName();
            throw new SSOException(rbName, "ums-null-token", null);
        }
        return adminToken;
    }

    public static boolean isAdmin(SSOToken admToken, SSOToken usrToken) {
        if (usrToken == null) {
            debug.error("SessionUtils.isAdmin(): user token is null");
            return false;
        }
        if (admToken == null) {
            debug.error("SessionUtils.isAdmin(): admin token is null");
            return false;
        }
        boolean result = false;
        String usrName = null;
        String admName = null;
        try {
            usrName = usrToken.getPrincipal().getName();
        }
        catch (SSOException ssoEx) {
            debug.error("SessionUtils.isAdmin(): user token failsto get principal");
            return false;
        }
        try {
            admName = admToken.getPrincipal().getName();
        }
        catch (SSOException ssoEx) {
            debug.error("SessionUtils.isAdmin(): admin token fails to get principal");
            return false;
        }
        if (usrName.equalsIgnoreCase(admName)) {
            result = true;
        }
        if (debug.messageEnabled()) {
            debug.message("SessionUtils.isAdmin(): returns " + result + " for user principal: " + usrName + " against admin principal: " + admName);
        }
        return result;
    }

    public static void checkPermissionToSetProperty(SSOToken clientToken, String key, String value) throws SessionException {
        if (InternalSession.isProtectedProperty(key)) {
            if (clientToken == null) {
                if (SessionService.sessionDebug.warningEnabled()) {
                    SessionService.sessionDebug.warning("SessionUtils.checkPermissionToSetProperty(): Attempt to set protected property without client token [" + key + "=" + value + "]");
                }
                throw new SessionException(SessionBundle.getString("protectedPropertyNoClientToken") + " " + key);
            }
            SSOTokenManager ssoTokenManager = null;
            try {
                ssoTokenManager = SSOTokenManager.getInstance();
            }
            catch (SSOException ssoEx) {
                SessionService.sessionDebug.error("SessionUtils.checkPermissionToSetProperty(): Cannot get instance of SSOTokenManager.");
                throw new SessionException(SessionBundle.getString("protectedPropertyNoSSOTokenMgrInstance") + " " + key);
            }
            if (!ssoTokenManager.isValidToken(clientToken)) {
                if (SessionService.sessionDebug.warningEnabled()) {
                    SessionService.sessionDebug.warning("SessionUtils.checkPermissionToSetProperty(): Attempt to set protected property with invalid client token [" + key + "=" + value + "]");
                }
                throw new SessionException(SessionBundle.getString("protectedPropertyInvalidClientToken") + " " + key);
            }
            SSOToken admToken = null;
            try {
                admToken = SessionUtils.getAdminToken();
            }
            catch (SSOException ssoEx) {
                SessionService.sessionDebug.error("SessionUtils.checkPermissionToSetProperty(): Cannot get Admin Token for validation to set protected property [" + key + "=" + value + "]");
                throw new SessionException(SessionBundle.getString("protectedPropertyNoAdminToken") + " " + key);
            }
            if (!SessionUtils.isAdmin(admToken, clientToken)) {
                SessionService.sessionDebug.error("SessionUtils.checkPermissionToSetProperty(): Client does not have permission to set protected property" + key + "=" + value + "]");
                throw new SessionException(SessionBundle.getString("protectedPropertyNoPermission") + " " + key);
            }
        }
    }
}

