/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.UI;

import com.iplanet.am.util.BrowserEncoding;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.services.util.Base64;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AuthViewBeanBase
extends ViewBeanBase {
    private static String[] ignoreList = new String[]{"goto", "encoded", "IDtoken0", "IDtoken1", "IDtoken2", "IDButton", "AMAuthCookie"};
    private Locale accLocale;
    static Debug loginDebug = Debug.getInstance((String)"amLoginViewBean");
    public static final String PAGE_ENCODING = "gx_charset";
    public static final String SERVICE_URI = "ServiceUri";
    public static String serviceUri = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
    protected Locale fallbackLocale;
    public static Set storeCookies = new HashSet();
    public static AMResourceBundleCache rbCache = AMResourceBundleCache.getInstance();
    public ResourceBundle rb = null;

    public AuthViewBeanBase(String pageName) {
        super(pageName);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(PAGE_ENCODING, StaticTextField.class);
        this.registerChild(SERVICE_URI, StaticTextField.class);
    }

    protected View createChild(String name) {
        if (name.equals(PAGE_ENCODING)) {
            return new StaticTextField((ContainerView)this, PAGE_ENCODING, (Object)"");
        }
        if (name.equals(SERVICE_URI)) {
            return new StaticTextField((ContainerView)this, name, (Object)serviceUri);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    protected void setPageEncoding(HttpServletRequest request, HttpServletResponse response) {
        String client_type = AuthClientUtils.getClientType(request);
        String content_type = AuthClientUtils.getContentType(client_type);
        this.accLocale = this.fallbackLocale;
        if (this.accLocale == null) {
            ISLocaleContext localeContext = new ISLocaleContext();
            localeContext.setLocale(request);
            this.accLocale = localeContext.getLocale();
        }
        String charset = AuthClientUtils.getCharSet(client_type, this.accLocale);
        response.setContentType(content_type + ";charset=" + charset);
        String jCharset = BrowserEncoding.mapHttp2JavaCharset(charset);
        if (loginDebug.messageEnabled()) {
            loginDebug.message("In setPageEncoding - charset : " + charset);
            loginDebug.message("In setPageEncoding - JCharset : " + jCharset);
        }
        this.setDisplayFieldValue(PAGE_ENCODING, jCharset);
    }

    public String getEncodedQueryParams(HttpServletRequest request) {
        String returnQueryParams = "";
        StringBuffer queryParams = new StringBuffer();
        queryParams.append("");
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            boolean ignore = false;
            String parameter = (String)parameters.nextElement();
            for (int i = 0; i < ignoreList.length; ++i) {
                if (!parameter.equalsIgnoreCase(ignoreList[i])) continue;
                ignore = true;
                break;
            }
            if (loginDebug.messageEnabled()) {
                loginDebug.message("getEncodedQueryParams: parameter  is:" + parameter);
            }
            if (ignore) continue;
            queryParams.append(parameter);
            String value = request.getParameter(parameter);
            queryParams.append('=');
            if (loginDebug.messageEnabled()) {
                loginDebug.message("getEncodedQueryParams: parameter  value:" + value);
            }
            queryParams.append(value);
            if (!parameters.hasMoreElements()) continue;
            queryParams.append('&');
        }
        String queryParamsString = queryParams.toString();
        if (loginDebug.messageEnabled()) {
            loginDebug.message("getEncodedQueryParams: SunQueryParamsString is:" + queryParamsString);
        }
        if (queryParamsString != null && queryParamsString.length() != 0) {
            returnQueryParams = this.getEncodedInputValue(queryParamsString);
        }
        if (loginDebug.messageEnabled()) {
            loginDebug.message("getEncodedQueryParams:returnQueryParams : " + returnQueryParams);
        }
        return returnQueryParams;
    }

    public String getValidatedInputURL(String inputURL, String encoded, HttpServletRequest request) {
        String returnURL = "";
        if (inputURL != null && inputURL.length() != 0 && !inputURL.equalsIgnoreCase("null")) {
            if (encoded == null || encoded.length() == 0 || encoded.equals("false")) {
                returnURL = this.getEncodedInputURL(inputURL, request);
            } else {
                try {
                    String msg = new String(Base64.decode(inputURL), "UTF-8");
                    returnURL = inputURL;
                }
                catch (RuntimeException rtex) {
                    loginDebug.warning("getValidatedInputURL:RuntimeException");
                }
                catch (UnsupportedEncodingException ueex) {
                    loginDebug.warning("getValidatedInputURL:UnsupportedEncodingException");
                }
            }
        }
        if (loginDebug.messageEnabled()) {
            loginDebug.message("getValidatedInputURL:returnURL : " + returnURL);
        }
        return returnURL;
    }

    private String getEncodedInputURL(String inputURL, HttpServletRequest request) {
        String returnURL = inputURL;
        try {
            URL url = new URL(inputURL);
        }
        catch (MalformedURLException mfe) {
            loginDebug.warning("Input URL is not standard www URL.");
            String requestURL = request.getRequestURL().toString();
            String requestURI = request.getRequestURI();
            int index = requestURL.indexOf(requestURI);
            String newURL = null;
            if (index != -1) {
                newURL = requestURL.substring(0, index) + inputURL;
            } else {
                index = requestURL.indexOf(serviceUri);
                if (index != -1) {
                    newURL = requestURL.substring(0, index) + inputURL;
                }
            }
            try {
                URL url = new URL(newURL);
            }
            catch (MalformedURLException mfe1) {
                loginDebug.warning("Relative URL is not standard www URL.");
                returnURL = "";
            }
        }
        if (returnURL != null && returnURL.length() != 0) {
            try {
                returnURL = Base64.encode(returnURL.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ueex) {
                loginDebug.warning("getEncodedInputURL:UnsupportedEncodingException");
                returnURL = "";
            }
        }
        if (loginDebug.messageEnabled()) {
            loginDebug.message("getEncodedInputURL:returnURL : " + returnURL);
        }
        return returnURL;
    }

    public String getEncodedInputValue(String inputValue) {
        String returnValue = "";
        if (inputValue != null && inputValue.length() != 0 && !inputValue.equalsIgnoreCase("null")) {
            try {
                returnValue = Base64.encode(inputValue.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ueex) {
                loginDebug.warning("getEncodedInputValue:UnsupportedEncodingException");
            }
        }
        if (loginDebug.messageEnabled()) {
            loginDebug.message("getEncodedInputValue:returnValue : " + returnValue);
        }
        return returnValue;
    }

    public Locale getRequestLocale() {
        return this.accLocale;
    }

    public abstract String getTileIndex();
}

