/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntitlementConfiguration {
    public static final String POLICY_EVAL_THREAD_SIZE = "evalThreadSize";
    public static final String POLICY_SEARCH_THREAD_SIZE = "searchThreadSize";
    public static final String POLICY_CACHE_SIZE = "policyCacheSize";
    public static final String INDEX_CACHE_SIZE = "indexCacheSize";
    public static final String RESOURCE_COMPARATOR = "resourceComparator";
    private static Class clazz;
    private static Map<String, EntitlementConfiguration> instances;
    private Subject adminSubject;

    public static EntitlementConfiguration getInstance(Subject adminSubject, String realm) {
        if (clazz == null) {
            return null;
        }
        EntitlementConfiguration impl = instances.get(realm);
        if (impl == null) {
            Class[] parameterTypes = new Class[]{String.class};
            try {
                Constructor constructor = clazz.getConstructor(parameterTypes);
                Object[] args = new Object[]{realm};
                impl = (EntitlementConfiguration)constructor.newInstance(args);
                impl.adminSubject = adminSubject;
                instances.put(realm, impl);
            }
            catch (InstantiationException ex) {
                PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
            }
            catch (SecurityException ex) {
                PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
            }
        }
        return impl;
    }

    public abstract Set<Application> getApplications();

    public abstract void removeApplication(String var1, Set<String> var2) throws EntitlementException;

    public abstract void removeApplication(String var1) throws EntitlementException;

    public abstract void storeApplication(Application var1) throws EntitlementException;

    public abstract Set<ApplicationType> getApplicationTypes();

    public abstract void removeApplicationType(String var1) throws EntitlementException;

    public abstract void storeApplicationType(ApplicationType var1) throws EntitlementException;

    public abstract Set<String> getConfiguration(String var1);

    public abstract Set<String> getSubjectAttributeNames(String var1) throws EntitlementException;

    public abstract void addSubjectAttributeNames(String var1, Set<String> var2) throws EntitlementException;

    public abstract void addApplicationAction(String var1, String var2, Boolean var3) throws EntitlementException;

    public abstract Set<String> getSubjectAttributesCollectorNames();

    public abstract Map<String, Set<String>> getSubjectAttributesCollectorConfiguration(String var1);

    public abstract boolean hasEntitlementDITs();

    public abstract boolean migratedToEntitlementService();

    protected Subject getAdminSubject() {
        return this.adminSubject;
    }

    public abstract boolean xacmlPrivilegeEnabled();

    static {
        instances = new HashMap<String, EntitlementConfiguration>();
        try {
            clazz = Class.forName("com.sun.identity.entitlement.opensso.EntitlementService");
        }
        catch (ClassNotFoundException e) {
            PrivilegeManager.debug.error("EntitlementConfiguration.<init>", (Throwable)e);
        }
    }
}

