/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.PolicyDataStore;
import com.sun.identity.entitlement.PrivilegeIndexStore;
import com.sun.identity.entitlement.ReferralPrivilege;
import com.sun.identity.entitlement.opensso.PrivilegeUtils;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OpenSSOPolicyDataStore
extends PolicyDataStore {
    private static final String REALM_DN_TEMPLATE = "ou=Policies,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMPolicyService,ou=services,{0}";

    public void addPolicy(Subject adminSubject, String realm, Object policy) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        if (policy instanceof Policy || policy instanceof com.sun.identity.entitlement.xacml3.core.Policy) {
            String name = PrivilegeUtils.getPolicyName(policy);
            String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
            if (adminToken == null) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(207, params);
            }
            try {
                this.createParentNode(adminToken, realm);
                SMSEntry s = new SMSEntry(adminToken, dn);
                HashMap map = new HashMap();
                HashSet<String> setServiceID = new HashSet<String>(2);
                map.put("sunserviceID", setServiceID);
                setServiceID.add("NamedPolicy");
                HashSet<String> setObjectClass = new HashSet<String>(4);
                map.put("objectclass", setObjectClass);
                setObjectClass.add("top");
                setObjectClass.add("sunServiceComponent");
                HashSet<String> setValue = new HashSet<String>(2);
                map.put("sunKeyValue", setValue);
                setValue.add(PrivilegeUtils.policyToXML(policy));
                s.setAttributes(map);
                s.save();
                PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(adminSubject, realm);
                pis.add(PrivilegeUtils.policyObjectToPrivileges(policy));
            }
            catch (PolicyException e) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(202, params, e);
            }
            catch (SSOException e) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(202, params, (Throwable)((Object)e));
            }
            catch (SMSException e) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(202, params, e);
            }
        }
    }

    private void createParentNode(SSOToken adminToken, String realm) throws SSOException, SMSException {
        ServiceConfig orgConf = this.getOrgConfig(adminToken, realm);
        Set subConfigNames = orgConf.getSubConfigNames();
        if (!subConfigNames.contains("Policies")) {
            orgConf.addSubConfig("Policies", "Policies", 0, null);
        }
    }

    private ServiceConfig getOrgConfig(SSOToken adminToken, String realm) throws SMSException, SSOException {
        ServiceConfigManager mgr = new ServiceConfigManager("iPlanetAMPolicyService", adminToken);
        ServiceConfig orgConf = mgr.getOrganizationConfig(realm, null);
        if (orgConf == null) {
            mgr.createOrganizationConfig(realm, null);
            orgConf = mgr.getOrganizationConfig(realm, null);
        }
        return orgConf;
    }

    public Object getPolicy(Subject adminSubject, String realm, String name) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        if (adminToken == null) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(209, params);
        }
        String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
        if (!SMSEntry.checkIfEntryExists(dn, adminToken)) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(203, params);
        }
        try {
            SMSEntry s = new SMSEntry(adminToken, dn);
            Map map = s.getAttributes();
            Set xml = (Set)map.get("sunKeyValue");
            String strXML = (String)xml.iterator().next();
            return this.createPolicy(adminToken, realm, strXML);
        }
        catch (SSOException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(204, params, (Throwable)((Object)ex));
        }
        catch (SMSException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(204, params, ex);
        }
        catch (Exception ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(204, params, ex);
        }
    }

    public ReferralPrivilege getReferral(Subject adminSubject, String realm, String name) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        if (adminToken == null) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(262, params);
        }
        String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
        if (!SMSEntry.checkIfEntryExists(dn, adminToken)) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(263, params);
        }
        try {
            SMSEntry s = new SMSEntry(adminToken, dn);
            Map map = s.getAttributes();
            Set set = (Set)map.get("sunKeyValue");
            String xml = (String)set.iterator().next();
            Set<IPrivilege> privileges = PrivilegeUtils.policyToPrivileges(this.createPolicy(adminToken, realm, xml));
            return (ReferralPrivilege)privileges.iterator().next();
        }
        catch (SSOException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(204, params, (Throwable)((Object)ex));
        }
        catch (SMSException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(204, params, ex);
        }
        catch (Exception ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(204, params, ex);
        }
    }

    private Object createPolicy(SSOToken adminToken, String realm, String xml) throws Exception, SSOException, PolicyException {
        Policy policy = null;
        if (xml.startsWith("xmlpolicy=")) {
            xml = xml.substring(10);
        }
        Document doc = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(xml.getBytes("UTF8")));
        if (!EntitlementConfiguration.getInstance(SubjectUtils.createSubject(adminToken), "/").xacmlPrivilegeEnabled()) {
            PolicyManager pm = new PolicyManager(adminToken, realm);
            Node rootNode = XMLUtils.getRootNode((Document)doc, (String)"Policy");
            policy = new Policy(pm, rootNode);
        }
        return policy;
    }

    public void removePolicy(Subject adminSubject, String realm, String name) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        if (adminToken == null) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(211, params);
        }
        String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
        if (!SMSEntry.checkIfEntryExists(dn, adminToken)) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(203, params);
        }
        try {
            SMSEntry s = new SMSEntry(adminToken, dn);
            s.delete();
            PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(adminSubject, realm);
            pis.delete(name);
        }
        catch (SSOException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(205, params, (Throwable)((Object)ex));
        }
        catch (SMSException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(205, params, ex);
        }
    }

    private static String getPolicyDistinguishedName(String realm, String name) {
        return "ou=" + name + "," + OpenSSOPolicyDataStore.getStoreBaseDN(realm);
    }

    private static String getStoreBaseDN(String realm) {
        Object[] args = new Object[]{DNMapper.orgNameToDN(realm)};
        return MessageFormat.format(REALM_DN_TEMPLATE, args);
    }

    public void modifyPolicy(Subject adminSubject, String realm, Object policy) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        if (policy instanceof Policy || policy instanceof com.sun.identity.entitlement.xacml3.core.Policy) {
            String name = PrivilegeUtils.getPolicyName(policy);
            String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
            if (adminToken == null) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(208, params);
            }
            try {
                SMSEntry s = new SMSEntry(adminToken, dn);
                HashMap map = new HashMap();
                HashSet<String> setObjectClass = new HashSet<String>(4);
                map.put("objectclass", setObjectClass);
                setObjectClass.add("top");
                setObjectClass.add("sunServiceComponent");
                HashSet<String> setValue = new HashSet<String>(2);
                map.put("sunKeyValue", setValue);
                setValue.add(PrivilegeUtils.policyToXML(policy));
                s.setAttributes(map);
                s.save();
                PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(adminSubject, realm);
                pis.delete(name);
                pis.add(PrivilegeUtils.policyToPrivileges(policy));
            }
            catch (SSOException e) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(206, params, (Throwable)((Object)e));
            }
            catch (SMSException e) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(206, params, e);
            }
            catch (PolicyException e) {
                Object[] params = new Object[]{name};
                throw new EntitlementException(206, params, e);
            }
        }
    }

    public void addReferral(Subject adminSubject, String realm, ReferralPrivilege referral) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        String name = referral.getName();
        String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
        if (adminToken == null) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(260, params);
        }
        try {
            this.createParentNode(adminToken, realm);
            SMSEntry s = new SMSEntry(adminToken, dn);
            HashMap map = new HashMap();
            HashSet<String> setServiceID = new HashSet<String>(2);
            map.put("sunserviceID", setServiceID);
            setServiceID.add("NamedPolicy");
            HashSet<String> setObjectClass = new HashSet<String>(4);
            map.put("objectclass", setObjectClass);
            setObjectClass.add("top");
            setObjectClass.add("sunServiceComponent");
            HashSet<String> setValue = new HashSet<String>(2);
            map.put("sunKeyValue", setValue);
            Policy p = PrivilegeUtils.referralPrivilegeToPolicy(realm, referral);
            setValue.add(p.toXML());
            s.setAttributes(map);
            s.save();
            PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(adminSubject, realm);
            HashSet<IPrivilege> tmp = new HashSet<IPrivilege>();
            tmp.add(referral);
            pis.add(tmp);
        }
        catch (PolicyException e) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(261, params, e);
        }
        catch (SSOException e) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(261, params, (Throwable)((Object)e));
        }
        catch (SMSException e) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(261, params, e);
        }
    }

    public void modifyReferral(Subject adminSubject, String realm, ReferralPrivilege referral) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        String name = referral.getName();
        String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
        if (adminToken == null) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(264, params);
        }
        try {
            SMSEntry s = new SMSEntry(adminToken, dn);
            HashMap map = new HashMap();
            HashSet<String> setObjectClass = new HashSet<String>(4);
            map.put("objectclass", setObjectClass);
            setObjectClass.add("top");
            setObjectClass.add("sunServiceComponent");
            HashSet<String> setValue = new HashSet<String>(2);
            map.put("sunKeyValue", setValue);
            setValue.add(referral.toJSON());
            s.setAttributes(map);
            s.save();
            PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(adminSubject, realm);
            pis.deleteReferral(name);
            HashSet<IPrivilege> tmp = new HashSet<IPrivilege>();
            tmp.add(referral);
            pis.add(tmp);
        }
        catch (SSOException e) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(265, params, (Throwable)((Object)e));
        }
        catch (SMSException e) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(265, params, e);
        }
    }

    public void removeReferral(Subject adminSubject, String realm, String name) throws EntitlementException {
        SSOToken adminToken = SubjectUtils.getSSOToken(adminSubject);
        if (adminToken == null) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(266, params);
        }
        String dn = OpenSSOPolicyDataStore.getPolicyDistinguishedName(realm, name);
        if (!SMSEntry.checkIfEntryExists(dn, adminToken)) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(263, params);
        }
        try {
            SMSEntry s = new SMSEntry(adminToken, dn);
            s.delete();
            PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(adminSubject, realm);
            pis.deleteReferral(name);
        }
        catch (SSOException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(205, params, (Throwable)((Object)ex));
        }
        catch (SMSException ex) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(205, params, ex);
        }
    }
}

