/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandlerImplUtils;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UserDiscoEntryHandler
implements DiscoEntryHandler {
    private static final String USER_ATTR_NAME = "sunIdentityServerDiscoEntries";
    private static final String DISCO = "disco";

    public UserDiscoEntryHandler() {
        DiscoEntryHandlerImplUtils.debug.message("in UserDiscoEntryHandler.constructor");
    }

    public Map getDiscoEntries(String userID, List reqServiceTypes) {
        DiscoEntryHandlerImplUtils.debug.message("in UserDiscoEntryHandler.getDiscoEntries");
        Map results = new HashMap();
        try {
            DataStoreProvider store = DataStoreProviderManager.getInstance().getDataStoreProvider(DISCO);
            if (DiscoEntryHandlerImplUtils.getUserDiscoEntries(store, userID, USER_ATTR_NAME, results) && !DiscoEntryHandlerImplUtils.setUserDiscoEntries(store, userID, USER_ATTR_NAME, results.values())) {
                DiscoEntryHandlerImplUtils.debug.error("UserDiscoEntryHandler.getDiscoEntries: couldn't set missing entryID to entry.");
            }
            results = DiscoEntryHandlerImplUtils.getQueryResults(results, reqServiceTypes);
        }
        catch (Exception e) {
            DiscoEntryHandlerImplUtils.debug.error("UserDiscoEntryHandler.getDiscoEntries:", (Throwable)e);
        }
        return results;
    }

    public Map modifyDiscoEntries(String userID, List removes, List inserts) {
        DiscoEntryHandlerImplUtils.debug.message("in UserDiscoEntryHandler.modifyDiscoEntries");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("STATUS_CODE", "Failed");
        HashMap discoEntries = new HashMap();
        DataStoreProvider store = null;
        try {
            store = DataStoreProviderManager.getInstance().getDataStoreProvider(DISCO);
            DiscoEntryHandlerImplUtils.getUserDiscoEntries(store, userID, USER_ATTR_NAME, discoEntries);
        }
        catch (Exception e) {
            DiscoEntryHandlerImplUtils.debug.error("UserDiscoEntryHandler.modifyDiscoEntries: Exception:", (Throwable)e);
            return result;
        }
        if (removes != null && !removes.isEmpty()) {
            if (DiscoEntryHandlerImplUtils.debug.messageEnabled()) {
                DiscoEntryHandlerImplUtils.debug.message("UserDiscoEntryHandler.modifyDiscoEntries: handling " + removes.size() + " removes.");
            }
            if (!DiscoEntryHandlerImplUtils.handleRemoves(discoEntries, removes)) {
                return result;
            }
        }
        HashSet results = new HashSet();
        results.addAll(discoEntries.values());
        List newEntryIDs = null;
        if (inserts != null && inserts.size() != 0) {
            Map insertResults;
            if (DiscoEntryHandlerImplUtils.debug.messageEnabled()) {
                DiscoEntryHandlerImplUtils.debug.message("UserDiscoEntryHandler.modifyDiscoEntries: handling " + inserts.size() + " inserts.");
            }
            if (!((String)(insertResults = DiscoEntryHandlerImplUtils.handleInserts(results, inserts)).get("STATUS_CODE")).equals("OK")) {
                return result;
            }
            newEntryIDs = (List)insertResults.get("newEntryIDs");
        }
        if (!DiscoEntryHandlerImplUtils.setUserDiscoEntries(store, userID, USER_ATTR_NAME, results)) {
            DiscoEntryHandlerImplUtils.debug.error("UserDiscoEntryHandler.modifyDiscoEntries: couldn't set DiscoEntries through DiscoEntryHandler.");
            return result;
        }
        if (DiscoEntryHandlerImplUtils.debug.messageEnabled()) {
            DiscoEntryHandlerImplUtils.debug.message("UserDiscoEntryHandler.modifyDiscoEntries: set DiscoEntries through DiscoEntryHandler successfully.");
        }
        result.put("STATUS_CODE", "OK");
        if (newEntryIDs != null && newEntryIDs.size() != 0) {
            result.put("newEntryIDs", newEntryIDs);
        }
        return result;
    }
}

