/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.xmlenc;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.xmlenc.AMEncryptionProvider;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.EncryptionUtils;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedData;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.EncryptionMethod;
import com.sun.org.apache.xml.internal.security.encryption.Reference;
import com.sun.org.apache.xml.internal.security.encryption.ReferenceList;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSEncryptionProvider
extends AMEncryptionProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document encryptAndReplaceWSSElements(Document doc, Map elmMap, String encDataEncAlg, int encDataEncAlgStrength, String certAlias, int kekStrength, String tokenType, String providerID) throws EncryptionException {
        Document resultDoc = null;
        PublicKey kek = this.keyProvider.getPublicKey(certAlias);
        if (doc == null || elmMap == null || kek == null) {
            EncryptionUtils.debug.error("WSSEncryptionProvider.encryptAndReplaceWSSElements: Null values for doc or elements map or public key");
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        if (EncryptionUtils.debug.messageEnabled()) {
            EncryptionUtils.debug.message("WSSEncryptionProvider.encryptAndReplaceWSSElements: DOC input = " + WSSUtils.print(doc));
        }
        Element root = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
        SecretKey secretKeyEncData = null;
        String cacheKey = providerID + encDataEncAlg + encDataEncAlgStrength;
        if (cacheKey != null) {
            if (keyMap.containsKey(cacheKey)) {
                secretKeyEncData = (SecretKey)keyMap.get(cacheKey);
                if (!secretKeyEncData.getAlgorithm().equals(encDataEncAlg)) {
                    secretKeyEncData = this.generateSecretKey(encDataEncAlg, encDataEncAlgStrength);
                }
            } else {
                secretKeyEncData = this.generateSecretKey(encDataEncAlg, encDataEncAlgStrength);
                keyMap.put(cacheKey, secretKeyEncData);
            }
        } else {
            secretKeyEncData = this.generateSecretKey(encDataEncAlg, encDataEncAlgStrength);
        }
        if (secretKeyEncData == null) {
            throw new EncryptionException(EncryptionUtils.bundle.getString("generateKeyError"));
        }
        try {
            XMLCipher cipher = null;
            String keyEncAlg = kek.getAlgorithm();
            if (keyEncAlg.equals("RSA")) {
                cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            } else if (keyEncAlg.equals("DESede")) {
                cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes");
            } else {
                if (!keyEncAlg.equals("AES")) throw new EncryptionException(EncryptionUtils.bundle.getString("unsupportedKeyAlg"));
                if (kekStrength == 0 || kekStrength == 128) {
                    cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
                } else if (kekStrength == 192) {
                    cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192");
                } else {
                    if (kekStrength != 256) throw new EncryptionException(EncryptionUtils.bundle.getString("invalidKeyStrength"));
                    cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
                }
            }
            cipher.init(3, (Key)kek);
            EncryptedKey encryptedKey = cipher.encryptKey(doc, (Key)secretKeyEncData);
            KeyInfo insideKi = new KeyInfo(doc);
            X509Data x509Data = new X509Data(doc);
            x509Data.addCertificate((X509Certificate)this.keyProvider.getCertificate(kek));
            insideKi.add(x509Data);
            Element securityTokenRef = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            String secRefId = SAMLUtils.generateID();
            securityTokenRef.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", secRefId);
            insideKi.addUnknownElement(securityTokenRef);
            IdResolver.registerElementById((Element)securityTokenRef, (String)secRefId);
            Element reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
            reference.setPrefix("wsse");
            String searchType = null;
            if ("urn:sun:wss:x509token".equals(tokenType)) {
                reference.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                searchType = "BinarySecurityToken";
            } else if ("urn:sun:wss:usernametoken".equals(tokenType)) {
                reference.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
                searchType = "UsernameToken";
            } else if ("urn:sun:wss:samltoken".equals(tokenType)) {
                reference.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                searchType = "Assertion";
            } else if ("urn:sun:wss:saml2token".equals(tokenType)) {
                reference.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
                searchType = "Assertion";
            }
            Element bsf = (Element)root.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", searchType).item(0);
            String tokenId = null;
            if (bsf != null) {
                tokenId = bsf.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                reference.setAttributeNS(null, "URI", "#" + tokenId);
            }
            securityTokenRef.appendChild(reference);
            encryptedKey.setKeyInfo(insideKi);
            ReferenceList refList = cipher.createReferenceList(1);
            if (refList != null) {
                Set<Object> wsu_ids_set;
                Reference dataRef = null;
                Collection wsu_ids = elmMap.values();
                Set<Object> set = wsu_ids_set = wsu_ids != null ? new HashSet(wsu_ids) : Collections.EMPTY_SET;
                if (wsu_ids_set != null) {
                    for (String string : wsu_ids_set) {
                        dataRef = refList.newDataReference("#" + string);
                        refList.add(dataRef);
                    }
                }
                encryptedKey.setReferenceList(refList);
            }
            String encAlgorithm = this.getEncryptionAlgorithm(encDataEncAlg, encDataEncAlgStrength);
            for (Map.Entry me : elmMap.entrySet()) {
                Element elm = (Element)me.getKey();
                String string = (String)me.getValue();
                cipher = XMLCipher.getInstance((String)encAlgorithm);
                cipher.init(1, (Key)secretKeyEncData);
                EncryptedData builder = cipher.getEncryptedData();
                builder.setId(string);
                EncryptionMethod encMethod = cipher.createEncryptionMethod(encAlgorithm);
                builder.setEncryptionMethod(encMethod);
                doc = cipher.doFinal(doc, elm);
            }
            root.appendChild(cipher.martial(doc, encryptedKey));
            resultDoc = doc;
            if (!EncryptionUtils.debug.messageEnabled()) return resultDoc;
            EncryptionUtils.debug.message("WSSEncryptionProvider.encryptAndReplaceWSSElements: Encrypted DOC = " + WSSUtils.print(resultDoc));
            return resultDoc;
        }
        catch (Exception xe) {
            EncryptionUtils.debug.error("WSSEncryptionProvider.encryptAndReplaceWSSElements: XML Encryption error : ", (Throwable)xe);
            throw new EncryptionException(xe);
        }
    }
}

