/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.authentication.spi.AMAuthCallBackImpl;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.UserNamePasswordValidationException;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.ServiceConfig;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class LDAP
extends AMLoginModule {
    private static HashMap orgMap = new HashMap();
    private static final long DEFAULT_SERVER_CHECK_INTERVAL = 15L;
    private static final String USER_CREATION_ATTR = "iplanet-am-ldap-user-creation-attr-list";
    private static final String INVALID_CHARS = "iplanet-am-auth-ldap-invalid-chars";
    private static final String PIPE_SEPARATOR = "|";
    private static boolean ldapSSL = false;
    ResourceBundle bundle = null;
    protected String validatedUserID;
    private String userName;
    private String userPassword;
    private String regEx;
    private String currentConfigName;
    private String bindDN;
    private Iterator subConfigNamesIter = null;
    private ServiceConfig sc;
    private boolean firstTry = true;
    private int currentState;
    private boolean primary = true;
    private int previousScreen;
    private final int PASSWORD_CHANGE = 2;
    private final int PASSWORD_EXPIRED_SCREEN = 3;
    private final int USER_INACTIVE = 4;
    private LDAPAuthUtils ldapUtil;
    private static volatile FailbackManager fMgr;
    private boolean isReset;
    private int primaryServerPort;
    private String primaryServerHost;
    private boolean isProfileCreationEnabled;
    private boolean getCredentialsFromSharedState;
    private AMAuthCallBackImpl callbackImpl = null;
    private long interval = 15L;
    private Set userCreationAttrs = new HashSet();
    private HashMap userAttrMap = new HashMap();
    private Map sharedState;
    private String serverHost;
    private int serverPort;
    public Map currentConfig;
    protected Debug debug = Debug.getInstance((String)this.amAuthLDAP);
    protected String amAuthLDAP = "amAuthLDAP";
    protected Principal userPrincipal;

    public void init(Subject subject, Map sharedState, Map options) {
        this.sc = (ServiceConfig)options.get("ServiceConfig");
        this.currentConfig = options;
        this.currentConfigName = (String)options.get("moduleInstanceName");
        this.primary = this.getPrimaryFlag(this.currentConfigName);
        java.util.Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(this.amAuthLDAP, locale);
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAP resbundle locale=" + locale);
        }
        this.sharedState = sharedState;
        if (this.debug.messageEnabled()) {
            this.debug.message("Host: " + AuthD.directoryHostName + "\nPORT : " + AuthD.directoryPort);
        }
    }

    public boolean initializeLDAP() throws AuthLoginException {
        block23: {
            this.debug.message("LDAP initialize()");
            this.serverHost = null;
            try {
                String baseDN;
                if (this.currentConfig == null) break block23;
                try {
                    String checkAttr = "iplanet-am-auth-ldap-server-check";
                    this.interval = Long.parseLong(CollectionHelper.getServerMapAttr((Map)this.currentConfig, (String)checkAttr));
                }
                catch (NumberFormatException nfe) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("Server Check Interval is not set.\nSetting it to default value 15 min");
                    }
                    this.interval = 15L;
                }
                this.setInterval(this.interval);
                if (this.primary) {
                    this.serverHost = CollectionHelper.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server");
                    if (this.serverHost == null) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("No primary server for confing " + this.currentConfigName);
                        }
                        return false;
                    }
                } else {
                    this.serverHost = CollectionHelper.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server2");
                    if (this.serverHost == null) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("No secondary server for confing " + this.currentConfigName);
                        }
                        return false;
                    }
                }
                if ((baseDN = CollectionHelper.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-base-dn")) == null) {
                    this.debug.error("BaseDN for search is invalid: " + baseDN);
                }
                this.bindDN = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-dn", (String)"");
                String bindPassword = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-passwd", (String)"");
                String userNamingAttr = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-user-naming-attribute", (String)"uid");
                Set userSearchAttrs = (Set)this.currentConfig.get("iplanet-am-auth-ldap-user-search-attributes");
                String searchFilter = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-filter", (String)"");
                boolean ssl = Boolean.valueOf(CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-ssl-enabled", (String)"false"));
                this.getUserCreationAttrs(this.currentConfig);
                String tmp = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-scope", (String)"SUBTREE");
                String authLevel = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-auth-level");
                if (authLevel != null) {
                    try {
                        this.setAuthLevel(Integer.parseInt(authLevel));
                    }
                    catch (Exception e) {
                        this.debug.error("Unable to set auth level " + authLevel);
                    }
                }
                int searchScope = 2;
                if (tmp.equalsIgnoreCase("OBJECT")) {
                    searchScope = 0;
                } else if (tmp.equalsIgnoreCase("ONELEVEL")) {
                    searchScope = 1;
                }
                String returnUserDN = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-return-user-dn", (String)"true");
                this.regEx = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)INVALID_CHARS);
                int index = this.serverHost.indexOf(58);
                this.serverPort = 389;
                if (index != -1) {
                    this.serverPort = Integer.parseInt(this.serverHost.substring(index + 1));
                    this.serverHost = this.serverHost.substring(0, index);
                }
                if (!this.primary) {
                    String poolKey;
                    String adminPoolStatus;
                    this.primaryServerHost = CollectionHelper.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server");
                    this.primaryServerPort = 389;
                    int colonIndex = this.primaryServerHost.indexOf(58);
                    if (colonIndex != -1) {
                        this.primaryServerPort = Integer.parseInt(this.primaryServerHost.substring(colonIndex + 1));
                        this.primaryServerHost = this.primaryServerHost.substring(0, colonIndex);
                    }
                    if (LDAPAuthUtils.connectionPoolsStatus != null && ((adminPoolStatus = (String)LDAPAuthUtils.connectionPoolsStatus.get(poolKey = this.primaryServerHost + ":" + this.primaryServerPort + ":" + this.bindDN)) == null || adminPoolStatus.equals("UP"))) {
                        this.setPrimaryFlag(this.currentConfigName, true);
                        this.primary = true;
                        this.serverHost = this.primaryServerHost;
                        this.serverPort = this.primaryServerPort;
                    }
                }
                this.isProfileCreationEnabled = this.isDynamicProfileCreationEnabled();
                this.ldapUtil = new LDAPAuthUtils(this.serverHost, this.serverPort, ssl, this.bundle, baseDN, this.debug);
                this.ldapUtil.setScope(searchScope);
                this.ldapUtil.setFilter(searchFilter);
                this.ldapUtil.setUserNamingAttribute(userNamingAttr);
                this.ldapUtil.setUserSearchAttribute(userSearchAttrs);
                this.ldapUtil.setAuthPassword(bindPassword);
                this.ldapUtil.setAuthDN(this.bindDN);
                this.ldapUtil.setReturnUserDN(returnUserDN);
                this.ldapUtil.setUserAttributes(this.userCreationAttrs);
                this.ldapUtil.setDynamicProfileCreationEnabled(this.isProfileCreationEnabled);
                if (this.debug.messageEnabled()) {
                    this.debug.message("bindDN-> " + this.bindDN + "\nbaseDN-> " + baseDN + "\nuserNamingAttr-> " + userNamingAttr + "\nuserSearchAttr(s)-> " + userSearchAttrs + "\nuserCreationAttrs-> " + this.userCreationAttrs + "\nsearchFilter-> " + searchFilter + "\nsearchScope-> " + searchScope + "\nssl-> " + ssl + "\nauthLevel: " + authLevel + "\nHost: " + this.serverHost + "\nPORT : " + this.serverPort + "\nPattern : " + this.regEx);
                }
                return true;
            }
            catch (Exception ex) {
                this.debug.error("Init Exception", (Throwable)ex);
                throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null, ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPrimaryFlag(String configName) {
        HashMap hashMap = orgMap;
        synchronized (hashMap) {
            String reqOrg = this.getRequestOrg();
            HashMap<String, String> flags = (HashMap<String, String>)orgMap.get(reqOrg);
            if (flags == null) {
                flags = new HashMap<String, String>();
                flags.put(configName, "true");
                orgMap.put(reqOrg, flags);
                return true;
            }
            String flag = (String)flags.get(configName);
            if (flag == null) {
                flags.put(configName, "true");
                return true;
            }
            return flag.equals("true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPrimaryFlag(String configName, boolean flag) {
        HashMap hashMap = orgMap;
        synchronized (hashMap) {
            String reqOrg = this.getRequestOrg();
            HashMap<String, String> flags = (HashMap<String, String>)orgMap.get(reqOrg);
            if (flags == null) {
                flags = new HashMap<String, String>();
                orgMap.put(reqOrg, flags);
            }
            if (flag) {
                flags.put(configName, "true");
            } else {
                flags.put(configName, "false");
            }
        }
    }

    private boolean getSubConfig() {
        block7: {
            this.firstTry = true;
            try {
                if (this.subConfigNamesIter == null && this.sc != null) {
                    Set subConfigNames = this.sc.getSubConfigNames();
                    if (subConfigNames == null || subConfigNames.size() == 0) {
                        return false;
                    }
                    this.subConfigNamesIter = subConfigNames.iterator();
                }
                if (this.subConfigNamesIter != null) {
                    while (this.subConfigNamesIter.hasNext()) {
                        String subConfigName = (String)this.subConfigNamesIter.next();
                        ServiceConfig ssc = this.sc.getSubConfig(subConfigName);
                        if (ssc == null) continue;
                        if (this.debug.messageEnabled()) {
                            this.debug.message("LDAP.getSubConfig subConfigName = " + subConfigName);
                        }
                        this.currentConfig = ssc.getAttributes();
                        this.currentConfigName = subConfigName;
                        this.primary = this.getPrimaryFlag(subConfigName);
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                if (!this.debug.warningEnabled()) break block7;
                this.debug.warning("LDAP.getSubConfig unable to get sub config", (Throwable)ex);
            }
        }
        return false;
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        this.currentState = state;
        int newState = 0;
        try {
            if (this.currentState == 1) {
                if (callbacks != null && callbacks.length == 0) {
                    this.userName = (String)this.sharedState.get(this.getUserKey());
                    this.userPassword = (String)this.sharedState.get(this.getPwdKey());
                    if (this.userName == null || this.userPassword == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    this.userName = ((NameCallback)callbacks[0]).getName();
                    this.userPassword = this.charToString(((PasswordCallback)callbacks[1]).getPassword(), callbacks[1]);
                }
                if (this.userPassword == null || this.userPassword.length() == 0) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("LDAP.process: Password is null/empty");
                    }
                    throw new InvalidPasswordException("amAuth", "invalidPasswd", null);
                }
                this.storeUsernamePasswd(this.userName, this.userPassword);
                if (this.isSuperAdmin(this.userName)) {
                    this.ldapUtil = new LDAPAuthUtils(AuthD.directoryHostName, AuthD.directoryPort, ldapSSL, this.bundle, this.debug);
                    this.ldapUtil.authenticateSuperAdmin(this.userName, this.userPassword);
                    if (this.ldapUtil.getState() == 26) {
                        this.validatedUserID = this.userName;
                        return -1;
                    }
                    this.debug.message("Invalid adminID or admin Password");
                    this.setFailureID(this.ldapUtil.getUserId(this.userName));
                    throw new AuthLoginException(this.amAuthLDAP, "InvalidUP", null);
                }
                if (this.initializeLDAP()) {
                    this.validateUserName(this.userName, this.regEx);
                    this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                    newState = this.ldapUtil.getState();
                } else {
                    newState = 31;
                }
                boolean passwordValidationSuccessFlag = true;
                if (newState == 26) {
                    try {
                        this.validatePassword(this.userPassword);
                    }
                    catch (UserNamePasswordValidationException upve) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("Password does not satisfy password policy rules specified in OpenSSO");
                        }
                        this.isReset = true;
                        String invalidMsg = this.bundle.getString("PasswordInvalid");
                        this.replaceHeader(2, invalidMsg);
                        this.currentState = 2;
                        passwordValidationSuccessFlag = false;
                    }
                }
                if (passwordValidationSuccessFlag) {
                    this.processLoginScreen(newState);
                }
                return this.currentState;
            }
            if (this.currentState == 2) {
                int pwdAction;
                if (this.debug.messageEnabled()) {
                    this.debug.message("you are in PWd Screen:" + this.currentState);
                }
                if ((pwdAction = ((ConfirmationCallback)callbacks[3]).getSelectedIndex()) == 0) {
                    String oldPassword = this.charToString(((PasswordCallback)callbacks[0]).getPassword(), callbacks[0]);
                    String newPassword = this.charToString(((PasswordCallback)callbacks[1]).getPassword(), callbacks[1]);
                    String confirmPassword = this.charToString(((PasswordCallback)callbacks[2]).getPassword(), callbacks[2]);
                    try {
                        this.validatePassword(newPassword);
                        this.ldapUtil.changePassword(oldPassword, newPassword, confirmPassword);
                        newState = this.ldapUtil.getState();
                        this.processPasswordScreen(newState);
                        if (this.debug.messageEnabled()) {
                            this.debug.message("Password change state :" + newState);
                        }
                    }
                    catch (UserNamePasswordValidationException upve) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("Password could not be validated, need a different password");
                        }
                        String invalidMsg = this.bundle.getString("NewPasswordInvalid");
                        this.replaceHeader(2, invalidMsg);
                        this.currentState = 2;
                    }
                    return this.currentState;
                }
                if (this.isReset) {
                    this.isReset = false;
                    return 1;
                }
                this.validatedUserID = this.ldapUtil.getUserId();
                return -1;
            }
            this.setFailureID(this.ldapUtil.getUserId(this.userName));
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
        }
        catch (LDAPUtilException ex) {
            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            this.setFailureID(this.ldapUtil != null ? this.ldapUtil.getUserId(this.userName) : this.userName);
            switch (ex.getLDAPResultCode()) {
                case 32: {
                    this.debug.message("The specified user does not exist.");
                    throw new AuthLoginException(this.amAuthLDAP, "NoUser", null);
                }
                case 49: {
                    this.debug.message("Invalid password.");
                    String failureUserID = this.ldapUtil.getUserId();
                    throw new InvalidPasswordException(this.amAuthLDAP, "InvalidUP", null, failureUserID, null);
                }
                case 53: {
                    this.debug.message("Unwilling to perform. Account inactivated.");
                    this.currentState = 4;
                    return this.currentState;
                }
                case 48: {
                    this.debug.message("Inappropriate authentication.");
                    throw new AuthLoginException(this.amAuthLDAP, "InappAuth", null);
                }
                case 19: {
                    this.debug.message("Exceed password retry limit.");
                    throw new AuthLoginException(this.amAuthLDAP, "ExceedRetryLimit", null);
                }
            }
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
        }
        catch (UserNamePasswordValidationException upve) {
            this.debug.message("Invalid Characters detected");
            throw new AuthLoginException(upve);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new LDAPPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.validatedUserID = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.userName = null;
        this.userPassword = null;
        this.regEx = null;
        this.subConfigNamesIter = null;
        this.sc = null;
        this.userCreationAttrs = null;
        this.userAttrMap = null;
        this.sharedState = null;
        this.currentConfig = null;
        this.amAuthLDAP = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLoginScreen(int newState) throws AuthLoginException {
        try {
            switch (newState) {
                case 26: {
                    this.validatedUserID = this.ldapUtil.getUserId();
                    this.createProfile();
                    this.currentState = -1;
                    this.setForceCallbacksRead(false);
                    break;
                }
                case 21: {
                    String fmtMsg = this.bundle.getString("PasswordExp");
                    String msg = Locale.formatMessage((String)fmtMsg, (Object)this.ldapUtil.getExpTime());
                    this.setForceCallbacksRead(true);
                    this.forceCallbacksInit();
                    this.replaceHeader(2, msg);
                    this.currentState = 2;
                    break;
                }
                case 32: {
                    this.isReset = true;
                    String resetMsg = this.bundle.getString("PasswordReset");
                    this.setForceCallbacksRead(true);
                    this.forceCallbacksInit();
                    this.replaceHeader(2, resetMsg);
                    this.currentState = 2;
                    break;
                }
                case 20: {
                    this.currentState = 3;
                    break;
                }
                case 1: {
                    if (!this.getSubConfig()) {
                        throw new LDAPUtilException("noUserMatchFound", null);
                    }
                    if (this.initializeLDAP()) {
                        this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                        newState = this.ldapUtil.getState();
                    } else {
                        newState = 31;
                    }
                    this.processLoginScreen(newState);
                    break;
                }
                case 31: {
                    if (this.firstTry) {
                        String key = this.serverHost + ":" + this.serverPort + ":" + this.bindDN;
                        HashMap hashMap = LDAPAuthUtils.connectionPoolsStatus;
                        synchronized (hashMap) {
                            LDAPAuthUtils.connectionPoolsStatus.put(key, "DOWN");
                        }
                        this.firstTry = false;
                        this.primary = !this.primary;
                        this.setPrimaryFlag(this.currentConfigName, this.primary);
                        if (fMgr == null || fMgr.scheduledExecutionTime() == -1L) {
                            fMgr = new FailbackManager();
                            SystemTimer.getTimer().schedule((TaskRunnable)fMgr, new Date(System.currentTimeMillis() / 1000L * 1000L));
                        } else if (this.interval < LDAP.fMgr.runPeriod) {
                            LDAP.fMgr.runPeriod = this.interval;
                        }
                        if (this.initializeLDAP()) {
                            this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                            newState = this.ldapUtil.getState();
                            this.processLoginScreen(newState);
                            break;
                        }
                    }
                    if (!this.getSubConfig()) {
                        throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
                    }
                    if (this.initializeLDAP()) {
                        this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                        newState = this.ldapUtil.getState();
                    } else {
                        newState = 31;
                    }
                    this.processLoginScreen(newState);
                    break;
                }
            }
        }
        catch (LDAPUtilException ex) {
            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                this.getCredentialsFromSharedState = false;
                this.currentState = 1;
                return;
            }
            if (newState != 1) {
                this.debug.error("Unknown Login State:", (Throwable)((Object)ex));
            }
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null, (Throwable)((Object)ex));
        }
    }

    private void processPasswordScreen(int newState) throws AuthLoginException {
        switch (newState) {
            case 28: {
                this.validatedUserID = this.ldapUtil.getUserId();
                this.createProfile();
                this.currentState = -1;
                try {
                    this.callbackImpl = AMAuthCallBackImpl.getInstance(this.getRequestOrg());
                    Long now = new Long(System.currentTimeMillis());
                    this.callbackImpl.processedPasswordChange(now, this.validatedUserID);
                }
                catch (AMAuthCallBackException acbe) {
                    if (!this.debug.errorEnabled()) break;
                    this.debug.error("process : unable to get AMAuthCallBackImpl instance or callback module raised an exception.", (Throwable)((Object)acbe));
                }
                break;
            }
            case 25: {
                this.replaceHeader(2, this.bundle.getString("PInvalid"));
                this.currentState = 2;
                break;
            }
            case 23: {
                this.replaceHeader(2, this.bundle.getString("PasswdMismatch"));
                this.currentState = 2;
                break;
            }
            case 24: {
                this.replaceHeader(2, this.bundle.getString("UPSame"));
                this.currentState = 2;
                break;
            }
            case 27: {
                this.replaceHeader(2, this.bundle.getString("PasswdSame"));
                this.currentState = 2;
                break;
            }
            case 30: {
                this.replaceHeader(2, this.bundle.getString("PasswdMinChars"));
                this.currentState = 2;
                break;
            }
            case 29: {
                this.replaceHeader(2, this.bundle.getString("UPsame"));
                this.currentState = 2;
                break;
            }
        }
    }

    private void createProfile() {
        if (this.isProfileCreationEnabled && this.userCreationAttrs.size() > 0) {
            Map userAttributeValues = this.ldapUtil.getUserAttributeValues();
            if (this.debug.messageEnabled()) {
                this.debug.message("user creation attributes: " + userAttributeValues);
            }
            Map userValues = this.getAttributeMap(userAttributeValues);
            this.setUserAttributes(userValues);
        }
    }

    private String charToString(char[] tmpPassword, Callback cbk) {
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)cbk).clearPassword();
        return new String(pwd);
    }

    private void setReplaceText(int state, int index, String msg) throws AuthLoginException {
        this.debug.message("Entered in setReplaceText");
        Callback[] callbacks2 = this.getCallback(2);
        this.resetCallback(state, 0);
        String origMsg = ((PasswordCallback)callbacks2[0]).getPrompt();
        int idx = origMsg.indexOf("#REPLACE#");
        String setMsg = msg + origMsg.substring(idx + 9);
        this.replaceCallback(state, 0, new PasswordCallback(setMsg, ((PasswordCallback)callbacks2[0]).isEchoOn()));
        if (this.debug.messageEnabled()) {
            this.debug.message("origmessage:" + origMsg + ":::+setMsg" + setMsg);
        }
    }

    private void setInterval(long iVal) {
        this.interval = iVal * 60000L;
    }

    private void getUserCreationAttrs(Map currentConfig) {
        Set attrs = (Set)currentConfig.get(USER_CREATION_ATTR);
        if (this.debug.messageEnabled()) {
            this.debug.message("attrs is : " + attrs);
        }
        if (attrs != null && !attrs.isEmpty()) {
            for (String userAttr : attrs) {
                int i = userAttr.indexOf(PIPE_SEPARATOR);
                if (i != -1) {
                    String localAttr = userAttr.substring(0, i);
                    String extAttr = userAttr.substring(i + 1, userAttr.length());
                    if (extAttr == null || extAttr.length() == 0) {
                        this.userCreationAttrs.add(localAttr);
                        this.userAttrMap.put(localAttr, localAttr);
                        continue;
                    }
                    this.userCreationAttrs.add(extAttr);
                    this.userAttrMap.put(localAttr, extAttr);
                    continue;
                }
                this.userCreationAttrs.add(userAttr);
                this.userAttrMap.put(userAttr, userAttr);
            }
        }
    }

    private Map getAttributeMap(Map attributeValues) {
        if (this.debug.messageEnabled()) {
            this.debug.message("In getAttribute Map: " + attributeValues);
        }
        HashMap<String, Set> newAttrMap = new HashMap<String, Set>();
        for (String key : this.userAttrMap.keySet()) {
            String value = (String)this.userAttrMap.get(key);
            Set newValue = (Set)attributeValues.get(value);
            if (this.debug.messageEnabled()) {
                this.debug.message("key is : " + key);
                this.debug.message("value is : " + newValue);
            }
            if (newValue == null) continue;
            newAttrMap.put(key, newValue);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("New attr map is : " + newAttrMap);
        }
        return newAttrMap;
    }

    static {
        ldapSSL = Boolean.valueOf(SystemProperties.get("com.iplanet.am.directory.ssl.enabled", "false"));
    }

    class FailbackManager
    extends GeneralTaskRunnable {
        public long runPeriod;

        public FailbackManager() {
            this.runPeriod = LDAP.this.interval;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean foundDown = true;
            try {
                foundDown = false;
                Set set1 = LDAPAuthUtils.connectionPoolsStatus.keySet();
                for (String key : set1) {
                    String status = (String)LDAPAuthUtils.connectionPoolsStatus.get(key);
                    if (!status.equals("DOWN")) continue;
                    foundDown = true;
                    if (LDAP.this.debug.messageEnabled()) {
                        LDAP.this.debug.message("Checking for server " + key);
                    }
                    StringTokenizer st = new StringTokenizer(key, ":");
                    String downHost = st.nextToken();
                    String downPort = st.nextToken();
                    if (downHost == null || downHost.length() == 0 || downPort == null || downPort.length() == 0) continue;
                    int intPort = Integer.valueOf(downPort);
                    LDAPConnection ldapConn = null;
                    try {
                        ldapConn = new LDAPConnection();
                        ldapConn.connect(downHost, intPort);
                        if (!ldapConn.isConnected()) continue;
                        LDAPAuthUtils.connectionPoolsStatus.put(key, "UP");
                    }
                    catch (LDAPException e) {}
                    continue;
                    finally {
                        if (ldapConn == null) continue;
                        ldapConn.disconnect();
                    }
                }
            }
            catch (Exception exp) {
                LDAP.this.debug.error("Error in Fallback Manager Thread", (Throwable)exp);
            }
            if (!foundDown) {
                this.runPeriod = -1L;
            }
        }
    }
}

