/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IDefinition;
import com.sun.identity.cli.SubCommand;
import com.sun.identity.cli.annotation.DefinitionClassInfo;
import com.sun.identity.cli.annotation.Macro;
import com.sun.identity.cli.annotation.SubCommandInfo;
import com.sun.identity.cli.tools.CLIDefinitionGenerator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class CLIDefinitionBase
implements IDefinition {
    private List<SubCommand> subCommands = new ArrayList<SubCommand>();
    private String definitionClass;
    private String logName;
    protected ResourceBundle rb;

    public CLIDefinitionBase(String definitionClass) throws CLIException {
        this.definitionClass = definitionClass;
    }

    private Class getDefinitionClass() throws CLIException {
        try {
            return Class.forName(this.definitionClass);
        }
        catch (ClassNotFoundException e) {
            throw new CLIException(e, 4);
        }
    }

    private void getProductName(Class clazz) throws CLIException {
        try {
            Field pdtField = clazz.getDeclaredField("product");
            if (pdtField == null) {
                throw new CLIException("Incorrect Definiton, class" + this.definitionClass + " missing product field", 5);
            }
            DefinitionClassInfo classInfo = pdtField.getAnnotation(DefinitionClassInfo.class);
            this.rb = ResourceBundle.getBundle(classInfo.resourceBundle());
            this.logName = classInfo.logName();
        }
        catch (NoSuchFieldException e) {
            throw new CLIException(e, 5);
        }
    }

    private void getCommands(Class clazz) throws CLIException {
        Field[] fields;
        for (Field fld : fields = clazz.getDeclaredFields()) {
            SubCommandInfo info = fld.getAnnotation(SubCommandInfo.class);
            if (info == null) continue;
            if (info.implClassName() == null || info.description() == null) {
                throw new CLIException("Incorrect Definiton, class" + this.definitionClass + " missing product field", 5);
            }
            List mandatoryOptions = CLIDefinitionGenerator.toList(info.mandatoryOptions());
            List optionalOptions = CLIDefinitionGenerator.toList(info.optionalOptions());
            List optionAliases = CLIDefinitionGenerator.toList(info.optionAliases());
            if (info.macro() != null && info.macro().length() > 0) {
                try {
                    Field fldMarco = clazz.getDeclaredField(info.macro());
                    Macro macroInfo = fldMarco.getAnnotation(Macro.class);
                    CLIDefinitionGenerator.appendToList(mandatoryOptions, macroInfo.mandatoryOptions());
                    CLIDefinitionGenerator.appendToList(optionalOptions, macroInfo.optionalOptions());
                    CLIDefinitionGenerator.appendToList(optionAliases, macroInfo.optionAliases());
                }
                catch (NoSuchFieldException e) {
                    throw new CLIException(e, 5);
                }
            }
            boolean webSupport = info.webSupport().equals("true");
            String subcmdName = fld.getName().replace('_', '-');
            this.subCommands.add(new SubCommand(this, this.rb, subcmdName, mandatoryOptions, optionalOptions, optionAliases, info.implClassName(), webSupport));
        }
    }

    public void init(Locale locale) throws CLIException {
        Class defClass = this.getDefinitionClass();
        this.getProductName(defClass);
        this.getCommands(defClass);
    }

    public List getSubCommands() {
        return this.subCommands;
    }

    public String getLogName() {
        return this.logName;
    }

    public SubCommand getSubCommand(String name) {
        SubCommand result = null;
        Iterator<SubCommand> i = this.subCommands.iterator();
        while (i.hasNext() && result == null) {
            SubCommand cmd = i.next();
            if (!cmd.getName().equals(name)) continue;
            result = cmd;
        }
        return result;
    }
}

