/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class RealmRemoveAttribute
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        String attributeName = this.getStringOptionValue("attributename");
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{realm, serviceName, attributeName};
            this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_REALM_ATTRIBUTE", params);
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            ocm.removeAttribute(serviceName, attributeName);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("remove-attribute-from-realm-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_REALM_ATTRIBUTE", params);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmRemoveAttribute.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_REALM_ATTRIBUTE", args);
            throw new CLIException(e, 127);
        }
    }
}

