/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class ListSites
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_LIST_SITES", null);
            Set sites = SiteConfiguration.getSites(adminSSOToken);
            if (sites != null && !sites.isEmpty()) {
                Iterator i = sites.iterator();
                while (i.hasNext()) {
                    outputWriter.printlnMessage((String)i.next());
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("list-sites-no-instances"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_LIST_SITES", null);
        }
        catch (SSOException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("ListSites.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_LIST_SITES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("ListSites.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_LIST_SITES", args);
            throw new CLIException(e, 127);
        }
    }
}

