/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.dm.ContainerViewBean;
import com.sun.identity.console.dm.GeneralPropertiesBase;
import com.sun.identity.console.dm.model.ContainerModel;
import com.sun.identity.console.dm.model.ContainerModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.text.MessageFormat;

public class ContainerPropertiesBase
extends GeneralPropertiesBase {
    private static final String CONTAINER_TABS = "container";
    public static final String PAGE_TITLE = "pgtitle";
    public CCPageTitleModel ptModel = null;
    public ContainerModel model = null;

    public ContainerPropertiesBase(String name) {
        super(name);
    }

    protected void registerChildren() {
        this.registerChild("tabCommon", CCTabs.class);
        super.registerChildren();
    }

    protected void createTabModel() {
        if (this.tabModel == null) {
            AMViewConfig amconfig = AMViewConfig.getInstance();
            String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
            this.tabModel = amconfig.getTabsModel(CONTAINER_TABS, realmName, this.getRequestContext().getRequest());
        }
    }

    protected void forwardToContainerView(RequestInvocationEvent event) {
        String tmp = (String)this.getPageSessionAttribute("currentOrganization");
        this.setPageSessionAttribute("CurrentProfileView", (Serializable)((Object)tmp));
        tmp = (String)this.getPageSessionAttribute("PreviousTabID");
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)tmp));
        ContainerViewBean vb = (ContainerViewBean)this.getViewBean(ContainerViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        this.model = new ContainerModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        return this.model;
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        try {
            AMViewBeanBase vb = this.getTabNodeAssociatedViewBean(CONTAINER_TABS, nodeID);
            String tmp = (String)this.getPageSessionAttribute("currentOrganization");
            vb.setPageSessionAttribute("currentOrganization", (Serializable)((Object)tmp));
            tmp = (String)this.getPageSessionAttribute("CurrentProfileView");
            vb.setPageSessionAttribute("CurrentProfileView", (Serializable)((Object)tmp));
            tmp = (String)this.getPageSessionAttribute("PreviousTabID");
            vb.setPageSessionAttribute("PreviousTabID", (Serializable)((Object)tmp));
            this.unlockPageTrailForSwapping();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.forwardTo();
        }
    }

    protected void setPageTitle(String title) {
        Object[] tmp = new String[]{this.getDisplayName()};
        this.ptModel.setPageTitleText(MessageFormat.format(this.model.getLocalizedString(title), tmp));
    }

    protected String getBreadCrumbDisplayName() {
        AMModel model = this.getModel();
        Object[] arg = new String[]{this.getDisplayName()};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.directorymanager.container.edit"), arg);
    }

    private String getDisplayName() {
        String name = (String)this.getPageSessionAttribute("CurrentProfileView");
        AMModel model = this.getModel();
        if (name == null || name.length() == 0) {
            name = model.getStartDSDN();
        }
        return AMFormatUtils.DNToName(model, name);
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("breadcrumbs.directorymanager.container");
    }

    protected boolean startPageTrail() {
        return false;
    }
}

