/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class ActionDecision {
    static final String ACTION_DECISION = "ActionDecision";
    static final String ADVICES = "Advices";
    static final String VALUES = "Values";
    static final String TIME_TO_LIVE = "timeToLive";
    static Debug debug = Debug.getInstance((String)"amPolicy");
    private String actionName;
    private Set values;
    private long timeToLive = Long.MAX_VALUE;
    private Map advices;
    private static long clientClockSkew = 0L;

    public ActionDecision() {
    }

    public ActionDecision(String actionName, Set values) {
        this.actionName = actionName;
        this.values = values;
    }

    public ActionDecision(String actionName, Set values, Map advices, long timeToLive) {
        this.actionName = actionName;
        this.values = values;
        this.advices = advices;
        this.timeToLive = timeToLive;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setValues(Set values) {
        this.values = values;
    }

    public Set getValues() {
        return this.values;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setAdvices(Map advices) {
        this.advices = advices;
    }

    public Map getAdvices() {
        return this.advices;
    }

    public String toString() {
        return this.actionName + "=" + this.values;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(ACTION_DECISION).append(" ");
        sb.append(TIME_TO_LIVE).append("=").append(PolicyUtils.quote(this.timeToLive) + ">");
        sb.append("\r\n");
        sb.append(PolicyUtils.attributeValuePairToXMLString(this.getActionName(), this.values));
        sb.append("<").append(ADVICES).append(">").append("\r\n");
        if (this.advices != null) {
            sb.append(PolicyUtils.mapToXMLString(this.advices));
        }
        sb.append("</").append(ADVICES).append(">").append("\r\n");
        sb.append("</").append(ACTION_DECISION).append(">").append("\r\n");
        return sb.toString();
    }

    public static ActionDecision parseActionDecision(Node actionDecisionNode) throws PolicyException {
        ActionDecision actionDecision = null;
        Set nodeSet = XMLUtils.getChildNodes((Node)actionDecisionNode, (String)"AttributeValuePair");
        if (nodeSet == null || nodeSet.isEmpty()) {
            debug.error("parseActionDecision: missing element AttributeValuePair");
            return null;
        }
        Iterator nodes = nodeSet.iterator();
        Node node2 = (Node)nodes.next();
        String actionName = PolicyUtils.getAttributeName(node2);
        Set actionValues = PolicyUtils.getAttributeValues(node2);
        actionDecision = new ActionDecision(actionName, actionValues);
        long timeToLive = Long.MAX_VALUE;
        String ttlString = XMLUtils.getNodeAttributeValue((Node)actionDecisionNode, (String)TIME_TO_LIVE);
        if (ttlString != null) {
            try {
                timeToLive = Long.parseLong(ttlString);
                if (timeToLive != Long.MAX_VALUE) {
                    timeToLive += clientClockSkew;
                }
            }
            catch (Exception e) {
                debug.error("Error while parsing timeToLive in  ActionDecision:" + ttlString);
                Object[] args = new Object[]{new Long(timeToLive)};
                throw new PolicyException("amPolicy", "invalid_time_to_live", args, e);
            }
        }
        actionDecision.setTimeToLive(timeToLive);
        HashMap<String, Set> advices = new HashMap<String, Set>();
        nodeSet = XMLUtils.getChildNodes((Node)actionDecisionNode, (String)ADVICES);
        if (nodeSet != null && (nodeSet = XMLUtils.getChildNodes((Node)(node2 = (Node)(nodes = nodeSet.iterator()).next()), (String)"AttributeValuePair")) != null) {
            for (Node node2 : nodeSet) {
                String adviceName = PolicyUtils.getAttributeName(node2);
                if (adviceName == null) continue;
                Set adviceMessages = PolicyUtils.getAttributeValues(node2);
                advices.put(adviceName, adviceMessages);
            }
        }
        actionDecision.setAdvices(advices);
        return actionDecision;
    }

    public Object clone() {
        ActionDecision clone = new ActionDecision();
        clone.actionName = this.actionName;
        clone.timeToLive = this.timeToLive;
        if (this.values != null) {
            Iterator valuesIter = this.values.iterator();
            clone.values = new HashSet(this.values.size());
            while (valuesIter.hasNext()) {
                clone.values.add(valuesIter.next());
            }
        }
        if (this.advices != null) {
            Iterator adviceIter = this.advices.keySet().iterator();
            clone.advices = new HashMap(this.advices.size());
            while (adviceIter.hasNext()) {
                String key = (String)adviceIter.next();
                clone.advices.put(key, this.advices.get(key));
            }
        }
        return clone;
    }

    public static void setClientClockSkew(long skew) {
        clientClockSkew = skew;
    }
}

