/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.DSConfigMgrBase;
import com.iplanet.services.ldap.IDSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.XMLException;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.JCECrypt;
import com.sun.identity.shared.StringUtils;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;

public class BootstrapCreator {
    private static BootstrapCreator instance = new BootstrapCreator();
    private static boolean isUnix = System.getProperty("path.separator").equals(":");
    static final String template = "@DS_PROTO@://@DS_HOST@/@INSTANCE_NAME@?user=@DSAMEUSER_NAME@&pwd=@DSAMEUSER_PWD@&dsbasedn=@BASE_DN@&dsmgr=@BIND_DN@&dspwd=@BIND_PWD@&ver=1.0";

    private BootstrapCreator() {
    }

    public static BootstrapCreator getInstance() {
        return instance;
    }

    public static void updateBootstrap() throws ConfigurationException {
        try {
            DSConfigMgrBase dsCfg = new DSConfigMgrBase();
            dsCfg.parseServiceConfigXML();
            instance.update(dsCfg);
        }
        catch (XMLException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (SMSException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (SSOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static void createBootstrap() throws ConfigurationException {
        try {
            instance.update(DSConfigMgr.getDSConfigMgr());
        }
        catch (LDAPServiceException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    private void update(IDSConfigMgr dsCfg) throws ConfigurationException {
        try {
            String bootstrapString = this.getBootStrapURL(dsCfg);
            String baseDir = SystemProperties.get("com.iplanet.services.configpath");
            String file = baseDir + "/" + "bootstrap";
            if (isUnix) {
                Runtime.getRuntime().exec("/bin/chmod 600 " + file);
                Thread.sleep(3000L);
            }
            AMSetupServlet.writeToFile(file, bootstrapString);
            if (isUnix) {
                Runtime.getRuntime().exec("/bin/chmod 400 " + file);
            }
        }
        catch (InterruptedException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public String getBootStrapURL(IDSConfigMgr dsCfg) throws ConfigurationException {
        String bootstrapStr = null;
        try {
            ServerInstance svrCfg;
            ServerGroup sg = dsCfg.getServerGroup("sms");
            ServerGroup defaultGroup = dsCfg.getServerGroup("default");
            if (sg == null) {
                sg = defaultGroup;
                svrCfg = dsCfg.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            } else {
                svrCfg = sg.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            }
            ServerInstance userInstance = defaultGroup.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            String dsameUserName = userInstance.getAuthID();
            String dsameUserPwd = JCECrypt.encode(userInstance.getPasswd());
            String connDN = svrCfg.getAuthID();
            String connPwd = JCECrypt.encode(svrCfg.getPasswd());
            String rootSuffix = svrCfg.getBaseDN();
            Collection serverList = sg.getServersList();
            StringBuffer bootstrap = new StringBuffer();
            for (Server serverObj : serverList) {
                Server.Type connType = serverObj.getConnectionType();
                String proto = connType.equals(Server.Type.CONN_SIMPLE) ? "ldap" : "ldaps";
                String url = StringUtils.strReplaceAll((String)template, (String)"@DS_PROTO@", (String)proto);
                String host = serverObj.getServerName() + ":" + serverObj.getPort();
                url = StringUtils.strReplaceAll((String)url, (String)"@DS_HOST@", (String)host);
                url = StringUtils.strReplaceAll((String)url, (String)"@INSTANCE_NAME@", (String)URLEncoder.encode(SystemProperties.getServerInstanceName(), "UTF-8"));
                url = StringUtils.strReplaceAll((String)url, (String)"@DSAMEUSER_NAME@", (String)URLEncoder.encode(dsameUserName, "UTF-8"));
                url = StringUtils.strReplaceAll((String)url, (String)"@DSAMEUSER_PWD@", (String)URLEncoder.encode(dsameUserPwd, "UTF-8"));
                url = StringUtils.strReplaceAll((String)url, (String)"@BASE_DN@", (String)URLEncoder.encode(rootSuffix, "UTF-8"));
                url = StringUtils.strReplaceAll((String)url, (String)"@BIND_DN@", (String)URLEncoder.encode(connDN, "UTF-8"));
                url = StringUtils.strReplaceAll((String)url, (String)"@BIND_PWD@", (String)URLEncoder.encode(connPwd, "UTF-8"));
                bootstrap.append(url).append("\n");
            }
            bootstrapStr = bootstrap.toString();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        return bootstrapStr;
    }
}

