/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerServerEntryImpl;
import com.sun.identity.monitoring.SsoServerTopology;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SsoServerTopologyImpl
extends SsoServerTopology {
    private static Debug debug = null;
    private static String myMibName;

    public SsoServerTopologyImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init(myMib, null);
    }

    public SsoServerTopologyImpl(SnmpMib myMib, MBeanServer server) {
        super(myMib, server);
        myMibName = myMib.getMibName();
        this.init(myMib, server);
    }

    private void init(SnmpMib myMib, MBeanServer server) {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
        String classModule = "SsoServerTopologyImpl.init:";
        Hashtable ntbl = Agent.getNamingTable();
        Hashtable sidtbl = Agent.getSiteIdTable();
        HashMap u2stbl = Agent.getURLToSiteTable();
        Set sidKeys = sidtbl.keySet();
        for (String svrId : sidKeys) {
            String siteId = (String)sidtbl.get(svrId);
            String svrURL = (String)ntbl.get(svrId);
            URL url = null;
            String proto = null;
            String host = null;
            int port = 0;
            String path = null;
            try {
                url = new URL(svrURL);
                proto = url.getProtocol();
                host = url.getHost();
                port = url.getPort();
                path = url.getPath();
            }
            catch (MalformedURLException mue) {
                debug.error(classModule + "invalid URL: " + svrURL + "; " + mue.getMessage());
            }
            Integer iport = new Integer(1);
            Integer iid = new Integer(0);
            try {
                iport = new Integer(port);
                iid = new Integer(svrId);
            }
            catch (NumberFormatException nfe) {
                debug.error(classModule + "invalid port (" + port + ") or server id (" + svrId + "): " + nfe.getMessage(), (Throwable)nfe);
            }
            SsoServerServerEntryImpl ssrv = new SsoServerServerEntryImpl(myMib);
            ssrv.SsoServerServerPort = iport;
            ssrv.SsoServerServerHostName = host;
            ssrv.SsoServerServerProtocol = proto;
            ssrv.SsoServerServerId = iid;
            ssrv.SsoServerServerStatus = new Integer(1);
            ObjectName svrName = ssrv.createSsoServerServerEntryObjectName(server);
            try {
                this.SsoServerServerTable.addEntry(ssrv, svrName);
                if (server == null || svrName == null) continue;
                server.registerMBean(ssrv, svrName);
            }
            catch (Exception ex) {
                debug.error(classModule + svrURL, (Throwable)ex);
            }
        }
        boolean sidmapIndx = true;
        for (String svrId : sidKeys) {
            String siteId = (String)sidtbl.get(svrId);
            Integer sid = new Integer(0);
            if (debug.messageEnabled()) {
                debug.message(classModule + "svrId = " + svrId + ", siteId = " + siteId);
            }
            try {
                sid = new Integer(siteId);
            }
            catch (NumberFormatException nfe) {
                debug.error(classModule + "invalid siteid (" + siteId + "): " + nfe.getMessage(), (Throwable)nfe);
            }
        }
    }
}

