/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.security.keystore.AMPassword;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.StringTokenizer;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public abstract class SecureLogHelper {
    static int keyLength = 168;
    static String currentKeyName = null;
    static String loggerKey = "Logger";
    static String verifier = "Verifier";
    static final String initialKey = "InitialKey";
    static final String currentKey = "CurrentKey";
    static final String currentSignature = "CurrentSignature";
    byte[] currentLoggerKey = null;
    byte[] currentVerifierKey = null;
    byte[] currentVerifierSignature = null;
    byte[] lastMac = null;
    byte[] currentMAC = null;
    byte[] lastLoggerKey = null;
    String logFileName = null;
    String verifierFileName = null;
    boolean loggerInitialized = false;
    boolean verifierInitialized = false;
    boolean LoggerLastLine = false;
    boolean VerifierLastLine = false;
    AMPassword loggerPass = null;
    AMPassword verifierPass = null;
    static String signingAlgorithm = null;

    public abstract byte[] signMAC(byte[] var1) throws Exception;

    abstract byte[] readFromSecretStore(String var1, String var2, AMPassword var3) throws Exception;

    abstract void writeToSecretStore(byte[] var1, String var2, AMPassword var3, String var4) throws Exception;

    public abstract boolean verifySignature(byte[] var1, byte[] var2) throws Exception;

    abstract void initializeKeyStoreManager(AMPassword var1) throws Exception;

    public synchronized void initializeSecureLogHelper(String loggerFileName, AMPassword LoggerPassword, String verFileName, AMPassword verifierPassword) throws Exception {
        this.logFileName = loggerFileName;
        this.verifierFileName = verFileName;
        this.loggerPass = LoggerPassword;
        AMPassword tempVerifierPass = verifierPassword;
        this.loggerInitialized = this.isInitialized(loggerFileName, this.loggerPass);
        if (!this.loggerInitialized) {
            this.initializeKeyStoreManager(LoggerPassword);
            KeyGenerator keygen = KeyGenerator.getInstance("DESede");
            SecretKey k0 = keygen.generateKey();
            this.currentLoggerKey = k0.getEncoded();
            this.writeToSecretStore(this.currentLoggerKey, loggerFileName, this.loggerPass, initialKey);
            this.loggerInitialized = true;
            this.writeToSecretStore(this.currentLoggerKey, loggerFileName, this.loggerPass, currentKey);
            this.writeToSecretStore(this.currentLoggerKey, this.verifierFileName, tempVerifierPass, initialKey);
        } else {
            if (Debug.messageEnabled()) {
                Debug.message(this.logFileName + " Logger Module is already " + " initialized");
            }
            this.currentLoggerKey = this.readFromSecretStore(loggerFileName, currentKey, this.loggerPass);
        }
    }

    public synchronized void initializeVerifier(String verFileName, AMPassword oldPassword, AMPassword newPassword) throws Exception {
        this.verifierFileName = verFileName;
        AMPassword oldPass = oldPassword;
        this.verifierPass = newPassword;
        this.initializeKeyStoreManager(this.verifierPass);
        this.verifierInitialized = oldPassword != null ? this.isInitialized(verFileName, this.verifierPass) : true;
        if (!this.verifierInitialized) {
            this.currentVerifierKey = this.readFromSecretStore(this.verifierFileName, initialKey, oldPass);
            AMPassword newverpass = this.verifierPass;
            this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, this.verifierPass, initialKey);
            this.verifierInitialized = true;
            this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, newverpass, currentKey);
        } else {
            this.currentVerifierKey = this.readFromSecretStore(this.verifierFileName, currentKey, this.verifierPass);
        }
    }

    public synchronized void reinitializeVerifier(String verFileName, AMPassword password) throws Exception {
        this.initializeKeyStoreManager(password);
        this.verifierInitialized = this.isInitialized(verFileName, password);
        if (!this.verifierInitialized) {
            throw new Exception(this.logFileName + " Verifier is not initialized");
        }
        this.currentVerifierKey = this.readFromSecretStore(this.verifierFileName, initialKey, password);
        AMPassword newverpass = (AMPassword)password.clone();
        this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, newverpass, currentKey);
    }

    public byte[] getLastMAC() {
        return this.currentMAC;
    }

    public byte[] getLastSignatureBytes() throws Exception {
        return this.readFromSecretStore(this.logFileName, currentSignature, this.loggerPass);
    }

    public String getLoggerFileName() {
        return this.logFileName;
    }

    public String getVerifierFileName() {
        return this.verifierFileName;
    }

    public synchronized byte[] generateLogEntryMAC(String LogEntry) throws Exception {
        byte[] key = null;
        this.lastMac = this.currentMAC;
        key = this.readFromSecretStore(this.logFileName, currentKey, this.loggerPass);
        if (this.currentLoggerKey != null && !this.equalByteArrays(this.currentLoggerKey, key)) {
            throw new Exception("Possible Intrusion or  Misconfiguration");
        }
        this.currentLoggerKey = key;
        this.currentMAC = this.getDigest(LogEntry, this.currentLoggerKey);
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(this.currentLoggerKey);
        this.currentLoggerKey = md.digest();
        this.writeToSecretStore(this.currentLoggerKey, this.logFileName, this.loggerPass, currentKey);
        return this.currentMAC;
    }

    public boolean verifyMAC(String LogEntry, byte[] mac) throws Exception {
        boolean macValid = false;
        try {
            byte[] verifierKey = this.readFromSecretStore(this.verifierFileName, currentKey, this.verifierPass);
            if (this.currentVerifierKey != null && !new String(this.currentVerifierKey).equals(new String(verifierKey))) {
                throw new Exception(this.verifierFileName + " Possible Intrusion or " + " Misconfiguration");
            }
            this.currentVerifierKey = verifierKey;
            byte[] digest = this.getDigest(LogEntry, this.currentVerifierKey);
            if (this.equalByteArrays(mac, digest)) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(this.currentVerifierKey);
                this.currentVerifierKey = md.digest();
                this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, this.verifierPass, currentKey);
                macValid = true;
            }
        }
        catch (Exception e) {
            Debug.error("SecureLogHelper.verifyMAC() :  Exception : ", e);
        }
        return macValid;
    }

    public void setLastLineforLogger(boolean islastLine) {
        this.LoggerLastLine = islastLine;
        if (this.lastLoggerKey == null) {
            this.lastLoggerKey = new byte[this.currentLoggerKey.length];
        }
        System.arraycopy(this.currentLoggerKey, 0, this.lastLoggerKey, 0, this.currentLoggerKey.length);
    }

    public void setLastLineforVerifier(boolean islastLine) {
        this.VerifierLastLine = islastLine;
    }

    public boolean isIntrusionTrue() {
        boolean intrusion = false;
        if (this.LoggerLastLine && this.VerifierLastLine) {
            intrusion = !new String(this.currentVerifierKey).equals(new String(this.lastLoggerKey));
        }
        return intrusion;
    }

    public String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            this.bytetohex((byte)(block[i] + 128), buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public void bytetohex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    public static byte[] toByteArray(String str) {
        int len = str.length();
        StringTokenizer st = new StringTokenizer(str, ":");
        String[] newStrArray = new String[st.countTokens()];
        int j = 0;
        while (st.hasMoreTokens()) {
            newStrArray[j] = st.nextToken();
            ++j;
        }
        byte[] ret = new byte[newStrArray.length];
        for (int i = 0; i < newStrArray.length; ++i) {
            int tmp = Integer.parseInt(newStrArray[i], 16);
            ret[i] = (byte)(tmp - 128);
        }
        return ret;
    }

    public boolean equalByteArrays(byte[] buf1, byte[] buf2) throws IOException {
        ByteArrayInputStream b1 = new ByteArrayInputStream(buf1);
        ByteArrayInputStream b2 = new ByteArrayInputStream(buf2);
        int i = 0;
        while (i < b1.available()) {
            int byte2;
            int byte1 = b1.read();
            if (byte1 == (byte2 = b2.read())) continue;
            b1.close();
            b2.close();
            return false;
        }
        b1.close();
        b2.close();
        return true;
    }

    public byte[] getDigest(String LogEntry, byte[] keyMaterial) throws Exception {
        MessageDigest md1 = MessageDigest.getInstance("SHA");
        MessageDigest md2 = MessageDigest.getInstance("SHA");
        md2.update(LogEntry.getBytes());
        md2.update(keyMaterial);
        md1.update(keyMaterial);
        keyMaterial = null;
        md1.update(md2.digest());
        return md1.digest();
    }

    public static void setLoggerKeyName(String name) {
        loggerKey = name;
    }

    public static String getLoggerKeyName() {
        return loggerKey;
    }

    boolean isInitialized(String filename, AMPassword password) {
        boolean isInitialized;
        block2: {
            isInitialized = false;
            try {
                byte[] k0 = null;
                FileInputStream infile = null;
                infile = new FileInputStream(filename);
                k0 = this.readFromSecretStore(filename, currentKey, password);
                isInitialized = k0 != null;
                infile.close();
            }
            catch (Exception e) {
                if (!Debug.messageEnabled()) break block2;
                Debug.message("SecureLogHelper.isInitialized() : " + e.getMessage() + " : returning false");
            }
        }
        return isInitialized;
    }

    static {
        try {
            signingAlgorithm = LogManagerUtil.getLogManager().getProperty("iplanet-am-logging-secure-signing-algorithm");
        }
        catch (Exception e) {
            signingAlgorithm = "SHA1withRSA";
        }
    }
}

