/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.spi;

import com.iplanet.security.x509.CertUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.logging.LogUtil;
import com.sun.identity.wss.security.SAML11AssertionValidator;
import com.sun.identity.wss.security.SAML2AssertionValidator;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.sts.ClientUserToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSClientUserToken;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.identity.wss.sts.config.FAMSTSConfiguration;
import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMSTSAttributeProvider
implements STSAttributeProvider {
    private static final String FAM_TOKEN = "FAMToken";
    private static final String SAML_ATTRIBUTE_MAP = "SAMLAttributeMapping";
    private static final String NAMEID_MAPPER_CLASS = "NameIDMapper";
    private static final String ATTR_NAMESPACE = "AttributeNamespace";
    private static final String STS = "sts";
    private static final String MEMBERSHIPS = "Memberships";
    private static final String INCLUDE_MEMBERSHIPS = "includeMemberships";
    private static final String defaultNS = "http://example.com";
    private Map attributeMap = new HashMap();
    private SSOToken ssoToken = null;

    public Map<QName, List<String>> getClaimedAttributes(Subject subject, String appliesTo, String tokenType, Claims claims) {
        Map<QName, List<String>> memberships;
        boolean includeMemberships;
        String subjectName = this.getSubjectNameFromCustomToken(subject);
        if (subjectName == null) {
            subjectName = this.getAuthenticatedSubject(subject);
            if (STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: subject is null from authenticated subject");
            }
        }
        if (subjectName == null) {
            if (STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: subject is null from custom tokens");
            }
            Element samlAssertionE = null;
            Iterator<Object> iter = subject.getPublicCredentials().iterator();
            Object object = iter.next();
            if (object instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)object;
                subjectName = CertUtils.getSubjectName((X509Certificate)cert);
            } else if (object instanceof XMLStreamReader) {
                XMLStreamReader reader = (XMLStreamReader)object;
                Object cert = null;
                try {
                    samlAssertionE = SAMLUtil.createSAMLAssertion((XMLStreamReader)reader);
                    this.parseSAMLAssertion(samlAssertionE, subject);
                }
                catch (Exception ex) {
                    STSUtils.debug.error("FAMSTSAttributeProvider.getClaimedAttributes: assertion validation failed");
                }
            } else if (object instanceof Element && (samlAssertionE = (Element)object).getLocalName().equals("Assertion")) {
                this.parseSAMLAssertion(samlAssertionE, subject);
            }
        }
        if (subjectName == null) {
            Iterator<Principal> iterator;
            Set<Principal> principals;
            if (STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: subject from X509certificate is null Checking in subject principals");
            }
            if ((principals = subject.getPrincipals()) != null && (iterator = principals.iterator()).hasNext()) {
                String cnName = principals.iterator().next().getName();
                String[] cnNameParts = cnName.split(",");
                if (cnNameParts.length == 1 && cnNameParts[0].indexOf("=") != -1) {
                    int pos = cnNameParts[0].indexOf("=");
                    subjectName = cnNameParts[0].substring(pos + 1);
                } else {
                    subjectName = cnName;
                }
            }
        }
        if (STSUtils.debug.messageEnabled()) {
            STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: subjectName : " + subjectName);
        }
        if (subjectName == null) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getClaimed Subject could not found.");
            return null;
        }
        String[] data = new String[]{subjectName};
        LogUtil.access(Level.INFO, "IDENTITY_SUBJECT_NAME", data, null);
        HashMap<QName, List<String>> attrs = new HashMap<QName, List<String>>();
        String namespace = defaultNS;
        Set tmp = null;
        Map agentConfig = null;
        FAMSTSConfiguration stsConfig = new FAMSTSConfiguration();
        if (appliesTo != null) {
            agentConfig = stsConfig.getSTSEndpoint().equals(appliesTo) ? STSUtils.getSTSSAMLAttributes(stsConfig) : STSUtils.getAgentAttributes(appliesTo, null, null, "WSPAgent");
        }
        if (agentConfig != null && !agentConfig.isEmpty() && (tmp = (Set)agentConfig.get(ATTR_NAMESPACE)) != null && !tmp.isEmpty()) {
            namespace = (String)tmp.iterator().next();
        }
        QName nameIdQName = new QName(namespace, "NameID");
        ArrayList<String> nameIdAttrs = new ArrayList<String>();
        nameIdAttrs.add(this.getUserPseduoName(subjectName, agentConfig));
        attrs.put(nameIdQName, nameIdAttrs);
        if (agentConfig == null || agentConfig.isEmpty()) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getClaimed Agent configuration not defined for " + appliesTo);
            return attrs;
        }
        tmp = (Set)agentConfig.get(SAML_ATTRIBUTE_MAP);
        Map<QName, List<String>> samlAttributeMap = null;
        if (tmp != null && !tmp.isEmpty()) {
            samlAttributeMap = WSSUtils.getSAMLAttributes(subjectName, tmp, namespace, this.ssoToken);
        }
        if (samlAttributeMap != null) {
            attrs.putAll(samlAttributeMap);
        }
        if (this.attributeMap != null && !this.attributeMap.isEmpty()) {
            Set entries = this.attributeMap.keySet();
            for (String key : entries) {
                String val = (String)this.attributeMap.get(key);
                QName attrQName = new QName(namespace, key);
                ArrayList<String> valList = new ArrayList<String>();
                valList.add(val);
                attrs.put(attrQName, valList);
            }
        }
        if ((includeMemberships = Boolean.valueOf(CollectionHelper.getMapAttr((Map)agentConfig, (String)INCLUDE_MEMBERSHIPS, (String)"false")).booleanValue()) && (memberships = WSSUtils.getMembershipAttributes(subjectName, namespace)) != null && !memberships.isEmpty()) {
            attrs.putAll(memberships);
        }
        String attrsStr = ((Object)attrs).toString();
        String[] data2 = new String[]{attrsStr};
        LogUtil.access(Level.INFO, "ATTR_MAP_FOR_SP", data2, null);
        return attrs;
    }

    private String getUserPseduoName(String userName, Map agentConfig) {
        if (agentConfig == null) {
            return userName;
        }
        String nameIDImpl = CollectionHelper.getMapAttr((Map)agentConfig, (String)NAMEID_MAPPER_CLASS);
        if (nameIDImpl == null) {
            return userName;
        }
        return WSSUtils.getUserPseduoName(userName, nameIDImpl);
    }

    private String getSubjectNameFromCustomToken(Subject subject) {
        for (Object object : subject.getPublicCredentials()) {
            if (!(object instanceof Element)) continue;
            Element credential = (Element)object;
            if (credential.getLocalName().equals(FAM_TOKEN)) {
                try {
                    STSClientUserToken userToken = new STSClientUserToken(credential);
                    String tokenID = userToken.getTokenId();
                    if (userToken.getType().equals("urn:sun:wss:saml2token")) {
                        try {
                            Element assertionE = XMLUtils.toDOMDocument((String)tokenID, (Debug)STSUtils.debug).getDocumentElement();
                            SAML2AssertionValidator validator = new SAML2AssertionValidator(assertionE, new HashMap());
                            return validator.getSubjectName();
                        }
                        catch (SecurityException se) {
                            if (STSUtils.debug.messageEnabled()) {
                                STSUtils.debug.message("FAMSTSAttributeProvider.getSubjectFromCustomToken:: ", (Throwable)se);
                            }
                            return null;
                        }
                    }
                    if (userToken.getType().equals("urn:sun:wss:samltoken")) {
                        try {
                            Element assertionE = XMLUtils.toDOMDocument((String)tokenID, (Debug)STSUtils.debug).getDocumentElement();
                            SAML11AssertionValidator validator = new SAML11AssertionValidator(assertionE, new HashMap());
                            return validator.getSubjectName();
                        }
                        catch (SecurityException se) {
                            if (STSUtils.debug.messageEnabled()) {
                                STSUtils.debug.error("FAMSTSAttributeProvider.getSubjectFromCustomToken:: ", (Throwable)se);
                            }
                            return null;
                        }
                    }
                    if (userToken.getType().equals("urn:sun:wss:ssotoken")) {
                        SSOToken currentToken;
                        SSOTokenManager manager = SSOTokenManager.getInstance();
                        if (manager.isValidToken(currentToken = manager.createSSOToken(tokenID))) {
                            this.ssoToken = currentToken;
                        }
                        return userToken.getPrincipalName();
                    }
                    return null;
                }
                catch (FAMSTSException fae) {
                    if (!STSUtils.debug.messageEnabled()) continue;
                    STSUtils.debug.message("FAMSTSAttributeProvider.getSubjectNameFromCustomToken: FAMException", (Throwable)fae);
                    continue;
                }
                catch (SSOException se) {
                    if (!STSUtils.debug.messageEnabled()) continue;
                    STSUtils.debug.message("FAMSTSAttributeProvider.getSubjectNameFromCustomToken: SSOException", (Throwable)se);
                    continue;
                }
            }
            FAMSTSConfiguration stsConfig = new FAMSTSConfiguration();
            String customToken = stsConfig.getClientUserTokenClass();
            if (customToken == null || customToken.length() == 0) continue;
            try {
                Class<?> customTokenClass = Thread.currentThread().getContextClassLoader().loadClass(customToken);
                ClientUserToken userToken = (ClientUserToken)customTokenClass.newInstance();
                userToken.parse(credential);
                return userToken.getPrincipalName();
            }
            catch (Exception ex) {
                if (!STSUtils.debug.messageEnabled()) continue;
                STSUtils.debug.message("FAMSTSAttributeProvider.CheckForCustomTokens: " + ex.getMessage());
            }
        }
        return null;
    }

    private String getAuthenticatedSubject(Subject subject) {
        final Subject sub = subject;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<Object> creds = sub.getPrivateCredentials();
                    if (creds != null && !creds.isEmpty()) {
                        for (Object cred : creds) {
                            if (!(cred instanceof SSOToken)) continue;
                            FAMSTSAttributeProvider.this.ssoToken = (SSOToken)cred;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getAuthenticatedSubject: Priveleged exception error", (Throwable)e);
            return null;
        }
        try {
            if (this.ssoToken != null) {
                return this.ssoToken.getPrincipal().getName();
            }
        }
        catch (SSOException se) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getAuthenticatedSubject: SSOException", (Throwable)se);
        }
        return null;
    }

    private void parseSAMLAssertion(Element samlAssertionE, Subject subject) {
        X509Certificate cert = null;
        try {
            String namespace = samlAssertionE.getNamespaceURI();
            if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace)) {
                SAML11AssertionValidator validator = new SAML11AssertionValidator(samlAssertionE, new HashMap());
                cert = validator.getKeyInfoCert();
                this.attributeMap = validator.getAttributes();
            } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) {
                SAML2AssertionValidator validator = new SAML2AssertionValidator(samlAssertionE, new HashMap());
                cert = validator.getKeyInfoCert();
                this.attributeMap = validator.getAttributes();
            }
            if (cert != null) {
                subject.getPublicCredentials().add(cert);
            }
        }
        catch (Exception ex) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getClaimedAttributes: assertion validation failed");
        }
    }
}

