/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.datastore;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.datastore.DataStoreBase;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.Iterator;
import java.util.List;

public class DeleteDataStores
extends DataStoreBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        List names = rc.getOption("names");
        this.validateRealm(realm);
        String[] params = new String[]{realm, names.toString()};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_DATASTORES", params);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", adminSSOToken);
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realm, null);
            if (cfg != null) {
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    cfg.removeSubConfig((String)i.next());
                }
                if (names.size() > 1) {
                    this.getOutputWriter().printlnMessage(this.getResourceString("datastore-delete-datastores-succeeded"));
                } else {
                    this.getOutputWriter().printlnMessage(this.getResourceString("datastore-delete-datastore-succeeded"));
                }
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("datastore-delete-datastore-not-found"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_DATASTORES", params);
        }
        catch (SMSException e) {
            this.debugError("DeleteDataStores.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_DATASTORES", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("DeleteDataStores.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_DATASTORES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

