/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm.model;

import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.console.realm.model.IDRepoModel;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class IDRepoModelImpl
extends AMModelBase
implements IDRepoModel {
    public IDRepoModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getIDRepoNames(String realmName) throws AMConsoleException {
        String[] param = new String[]{realmName};
        this.logEvent("ATTEMPT_GET_ID_REPO_NAMES", param);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realmName, null);
            Set names = cfg != null ? cfg.getSubConfigNames() : Collections.EMPTY_SET;
            this.logEvent("SUCCEED_GET_ID_REPO_NAMES", param);
            return names;
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, strError};
            this.logEvent("SMS_EXCEPTION_GET_ID_REPO_NAMES", paramsEx);
            throw new AMConsoleException("no.properties");
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, strError};
            this.logEvent("SSO_EXCEPTION_GET_ID_REPO_NAMES", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public Map getIDRepoTypesMap() throws AMConsoleException {
        try {
            ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ResourceBundle rb = AMResBundleCacher.getBundle(schemaMgr.getI18NFileName(), this.getUserLocale());
            ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
            Set names = orgSchema.getSubSchemaNames();
            HashMap<String, String> map = new HashMap<String, String>(names.size() * 2);
            for (String name : names) {
                ServiceSchema ss = orgSchema.getSubSchema(name);
                String i18nKey = ss.getI18NKey();
                if (i18nKey == null || i18nKey.trim().length() <= 0) continue;
                map.put(name, Locale.getString((ResourceBundle)rb, (String)i18nKey, (Debug)debug));
            }
            return map;
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public OptionList getIDRepoTypes() throws AMConsoleException {
        Map map = AMFormatUtils.reverseStringMap(this.getIDRepoTypesMap());
        OptionList optList = new OptionList();
        List sorted = AMFormatUtils.sortKeyInMap(map, this.getUserLocale());
        for (String label : sorted) {
            optList.add(label, (String)map.get(label));
        }
        return optList;
    }

    public String getPropertyXMLString(String realmName, String viewbeanClassName, String type, boolean bCreate) throws AMConsoleException {
        try {
            ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
            ServiceSchema ss = orgSchema.getSubSchema(type);
            DelegationConfig dConfig = DelegationConfig.getInstance();
            boolean canModify = dConfig.hasPermission(realmName, null, "MODIFY", this, viewbeanClassName);
            Set attributeSchemas = ss.getAttributeSchemas();
            PropertyXMLBuilder.removeAttributeSchemaWithoutI18nKey(attributeSchemas);
            PropertyXMLBuilder builder = new PropertyXMLBuilder("sunIdentityRepositoryService", (AMModel)this, attributeSchemas);
            if (!bCreate && !canModify) {
                builder.setAllAttributeReadOnly(true);
            }
            String xml = builder.getXML();
            String xmlFile = bCreate ? "com/sun/identity/console/propertyRMIDRepoAdd.xml" : "com/sun/identity/console/propertyRMIDRepoEdit.xml";
            String header = AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream(xmlFile));
            xml = PropertyXMLBuilder.prependXMLProperty(xml, header);
            return xml;
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Map getDefaultAttributeValues(String type) {
        HashMap<String, Set> values = null;
        try {
            ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
            ServiceSchema ss = orgSchema.getSubSchema(type);
            Set attrs = ss.getAttributeSchemas();
            values = new HashMap<String, Set>(attrs.size() * 2);
            for (AttributeSchema as : attrs) {
                values.put(as.getName(), as.getDefaultValues());
            }
        }
        catch (SMSException e) {
            debug.warning("IDRepoModelImpl.getDefaultAttributeValues", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("IDRepoModelImpl.getDefaultAttributeValues", (Throwable)((Object)e));
        }
        return values != null ? values : Collections.EMPTY_MAP;
    }

    public Map getAttributeValues(String realmName, String name) throws AMConsoleException {
        String[] params = new String[]{realmName, name};
        this.logEvent("ATTEMPT_GET_ATTR_VALUES_ID_REPO", params);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realmName, null);
            ServiceConfig ss = cfg.getSubConfig(name);
            Map attrValues = ss.getAttributes();
            this.logEvent("SUCCEED_GET_ATTR_VALUES_ID_REPO", params);
            return attrValues;
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, name, strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUES_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, name, strError};
            this.logEvent("SSO_EXCEPTION_GET_ATTR_VALUES_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public void createIDRepo(String realmName, String idRepoName, String idRepoType, Map values) throws AMConsoleException {
        String[] params = new String[]{realmName, idRepoName, idRepoType};
        this.logEvent("ATTEMPT_CREATE_ID_REPO", params);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realmName, null);
            if (cfg == null) {
                cfg = this.createOrganizationConfig(realmName, idRepoType);
            }
            cfg.addSubConfig(idRepoName, idRepoType, 0, values);
            this.logEvent("SUCCEED_CREATE_ID_REPO", params);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, idRepoName, idRepoType, strError};
            this.logEvent("SMS_EXCEPTION_CREATE_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, idRepoName, idRepoType, strError};
            this.logEvent("SSO_EXCEPTION_CREATE_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private ServiceConfig createOrganizationConfig(String realmName, String idRepoType) throws AMConsoleException {
        try {
            OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(this.getUserSSOToken(), realmName);
            Map attrValues = this.getDefaultAttributeValues();
            return orgCfgMgr.addServiceConfig("sunIdentityRepositoryService", attrValues);
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Map getDefaultAttributeValues() {
        HashMap<String, Set> values = null;
        try {
            ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
            Set attrs = orgSchema.getAttributeSchemas();
            values = new HashMap<String, Set>(attrs.size() * 2);
            for (AttributeSchema as : attrs) {
                values.put(as.getName(), as.getDefaultValues());
            }
        }
        catch (SMSException e) {
            debug.warning("IDRepoModelImpl.getDefaultAttributeValues", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("IDRepoModelImpl.getDefaultAttributeValues", (Throwable)((Object)e));
        }
        return values != null ? values : Collections.EMPTY_MAP;
    }

    public void deleteIDRepos(String realmName, Set names) throws AMConsoleException {
        String[] params = new String[2];
        params[0] = realmName;
        String curName = "";
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realmName, null);
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                String name;
                curName = name = (String)iter.next();
                params[1] = name;
                this.logEvent("ATTEMPT_DELETE_ID_REPO", params);
                cfg.removeSubConfig(name);
                this.logEvent("SUCCEED_DELETE_ID_REPO", params);
            }
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, curName, strError};
            this.logEvent("SMS_EXCEPTION_DELETE_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, curName, strError};
            this.logEvent("SSO_EXCEPTION_DELETE_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public void editIDRepo(String realmName, String idRepoName, Map values) throws AMConsoleException {
        String[] params = new String[]{realmName, idRepoName};
        this.logEvent("ATTEMPT_MODIFY_ID_REPO", params);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realmName, null);
            ServiceConfig ss = cfg.getSubConfig(idRepoName);
            ss.setAttributes(values);
            this.logEvent("SUCCEED_MODIFY_ID_REPO", params);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, idRepoName, strError};
            this.logEvent("SMS_EXCEPTION_MODIFY_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, idRepoName, strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_ID_REPO", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public String getIDRepoType(String realmName, String idRepoName) throws AMConsoleException {
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", this.getUserSSOToken());
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realmName, null);
            ServiceConfig ss = cfg.getSubConfig(idRepoName);
            return ss.getSchemaID();
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }
}

