/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeIndexStore;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.opensso.DataStore;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NotificationServlet
extends HttpServlet {
    public static final String CONTEXT_PATH = "/notification";
    public static final String PRIVILEGE_ADDED = "privilegeadded";
    public static final String REFERRAL_ADDED = "referraladded";
    public static final String PRIVILEGE_DELETED = "privilegedeleted";
    public static final String REFERRAL_DELETED = "referraldeleted";
    public static final String APPLICATIONS_CHANGED = "applicationsChanged";
    public static final String ATTR_REALM_NAME = "realm";
    public static final String ATTR_NAME = "name";
    public static DataStore dataStore = DataStore.getInstance();

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest req, HttpServletResponse res) {
        Writer writer = null;
        try {
            String uri = req.getRequestURI();
            String path = req.getContextPath();
            String action = uri.substring(path.length());
            action = action.substring(CONTEXT_PATH.length() + 1);
            if (action.equals(PRIVILEGE_DELETED)) {
                this.handlePrivilegeDeleted(req);
            } else if (action.equals(REFERRAL_DELETED)) {
                this.handleReferralPrivilegeDeleted(req);
            } else if (action.equals(PRIVILEGE_ADDED)) {
                this.handlePrivilegeAdded(req);
            } else if (action.equals(REFERRAL_ADDED)) {
                this.handleReferralPrivilegeAdded(req);
            } else if (action.equals(APPLICATIONS_CHANGED)) {
                this.handleApplicationsChanged(req);
            }
            writer = res.getWriter();
            res.setHeader("content-type", "text/html");
            writer.write("200");
            writer.flush();
        }
        catch (IOException ex) {
            PrivilegeManager.debug.error("NotificationServlet.handleRequest", (Throwable)ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {}
        }
    }

    private void handleReferralPrivilegeAdded(HttpServletRequest req) {
        String realm = req.getParameter(ATTR_REALM_NAME);
        dataStore.clearIndexCount(realm, true);
    }

    private void handlePrivilegeAdded(HttpServletRequest req) {
        String realm = req.getParameter(ATTR_REALM_NAME);
        dataStore.clearIndexCount(realm, false);
    }

    private void handlePrivilegeDeleted(HttpServletRequest req) {
        String privilegeName = req.getParameter(ATTR_NAME);
        String realm = req.getParameter(ATTR_REALM_NAME);
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(PrivilegeManager.superAdminSubject, realm);
        try {
            pis.delete(privilegeName, false);
        }
        catch (EntitlementException e) {
            // empty catch block
        }
        dataStore.clearIndexCount(realm, false);
    }

    private void handleReferralPrivilegeDeleted(HttpServletRequest req) {
        String referralName = req.getParameter(ATTR_NAME);
        String realm = req.getParameter(ATTR_REALM_NAME);
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(PrivilegeManager.superAdminSubject, realm);
        try {
            pis.deleteReferral(referralName, false);
        }
        catch (EntitlementException e) {
            // empty catch block
        }
        dataStore.clearIndexCount(realm, true);
    }

    private void handleApplicationsChanged(HttpServletRequest req) {
        String realm = req.getParameter(ATTR_REALM_NAME);
        ApplicationManager.clearCache(realm);
    }
}

