/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class GetCircleOfTrusts
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        String extendedMetaData;
        String realm = this.getString(params, "realm");
        if (realm == null && (extendedMetaData = this.getString(params, "extendeddata")) != null) {
            realm = this.getRealmFromExtData(GetCircleOfTrusts.getContent(extendedMetaData, locale));
        }
        if (realm == null) {
            throw new WorkflowException("invalid-metaalias-slash", null);
        }
        try {
            CircleOfTrustManager mgr = new CircleOfTrustManager();
            Set cots = mgr.getAllCirclesOfTrust(realm);
            StringBuffer buff = new StringBuffer();
            if (cots != null && !cots.isEmpty()) {
                boolean first = true;
                for (String c : cots) {
                    if (first) {
                        first = false;
                    } else {
                        buff.append("|");
                    }
                    try {
                        buff.append(URLEncoder.encode(c, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        buff.append(c);
                    }
                }
            }
            return buff.toString();
        }
        catch (COTException e) {
            throw new WorkflowException("invalid-extended-data-cot", null);
        }
    }

    private String getRealmFromExtData(String xml) throws WorkflowException {
        String realm = null;
        try {
            List config;
            EntityConfigElement configElt;
            Object obj = SAML2MetaUtils.convertStringToJAXB((String)xml);
            EntityConfigElement entityConfigElement = configElt = obj instanceof EntityConfigElement ? (EntityConfigElement)obj : null;
            if (configElt != null && configElt.isHosted() && !(config = configElt.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig()).isEmpty()) {
                BaseConfigType bConfig = (BaseConfigType)config.iterator().next();
                realm = SAML2MetaUtils.getRealmByMetaAlias((String)bConfig.getMetaAlias());
            }
        }
        catch (JAXBException e) {
            throw new WorkflowException("invalid-extended-data-cot", null);
        }
        return realm;
    }
}

