/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.sun.identity.shared.ldap.LDAPAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class Attr
implements Serializable,
Cloneable {
    String _name;
    private ArrayList _stringValues;
    private ArrayList _byteValues;
    private LDAPAttribute _ldapAttribute;

    public Attr() {
    }

    public Attr(String name) {
        this._name = name.toLowerCase();
    }

    public Attr(String name, String value) {
        this._name = name.toLowerCase();
        this._stringValues = new ArrayList(1);
        this._stringValues.add(value);
    }

    public Attr(String name, String[] value) {
        this._name = name.toLowerCase();
        int size = value.length;
        this._stringValues = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this._stringValues.add(value[i]);
        }
    }

    public Attr(String name, byte[] value) {
        this._name = name.toLowerCase();
        this._byteValues = new ArrayList(1);
        this._byteValues.add(value);
    }

    public Attr(String name, byte[][] value) {
        this._name = name.toLowerCase();
        this._byteValues = new ArrayList(1);
        int size = value.length;
        for (int i = 0; i < size; ++i) {
            this._byteValues.add(value[i]);
        }
    }

    public Attr(LDAPAttribute attr) {
        this._name = attr.getName().toLowerCase();
        this._ldapAttribute = attr;
    }

    public LDAPAttribute toLDAPAttribute() {
        int size = 0;
        LDAPAttribute ldapAttribute = null;
        if (this._stringValues != null) {
            size = this._stringValues.size();
            if (size == 0) {
                ldapAttribute = new LDAPAttribute(this._name);
            } else if (size == 1) {
                ldapAttribute = new LDAPAttribute(this._name, (String)this._stringValues.get(0));
            } else if (size > 1) {
                ldapAttribute = new LDAPAttribute(this._name);
                for (int i = 0; i < size; ++i) {
                    ldapAttribute.addValue((String)this._stringValues.get(i));
                }
            }
        } else if (this._byteValues != null) {
            ldapAttribute = new LDAPAttribute(this._name);
            size = this._byteValues.size();
            for (int i = 0; i < size; ++i) {
                ldapAttribute.addValue((byte[])this._byteValues.get(i));
            }
        } else if (this._ldapAttribute != null) {
            ldapAttribute = this._ldapAttribute;
        } else if (this._name != null) {
            ldapAttribute = new LDAPAttribute(this._name);
        }
        return ldapAttribute;
    }

    public void setValue(String value) {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        this._stringValues.clear();
        this.addValue(value);
    }

    public void addValue(String value) {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        if (!this._stringValues.contains(value)) {
            this._stringValues.add(value);
        }
    }

    public void addValues(String[] values) {
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            this.addValue(values[i]);
        }
    }

    public void removeValue(String value) {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        int size = this._stringValues.size();
        for (int i = 0; i < size; ++i) {
            if (!this._stringValues.get(i).equals(value)) continue;
            this._stringValues.remove(i);
            break;
        }
    }

    public void setValue(byte[] value) {
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        this._byteValues.clear();
        this.addValue(value);
    }

    public void addValue(byte[] value) {
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        this._byteValues.add(value);
    }

    public void addValues(byte[][] values) {
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            this.addValue(values[i]);
        }
    }

    public void removeValue(byte[] value) {
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        int size = this._byteValues.size();
        for (int i = 0; i < size; ++i) {
            if (!this._byteValues.get(i).equals(value)) continue;
            this._byteValues.remove(i);
            break;
        }
    }

    public String getName() {
        return this._name;
    }

    public String getName(Locale locale) {
        return Attr.getName(this._name, locale);
    }

    public static String getName(String attrName, Locale locale) {
        String name = null;
        String baseName = Attr.getBaseName(attrName);
        if (locale == null) {
            name = baseName;
        } else {
            String localeStr = locale.toString();
            if (localeStr.length() > 0) {
                StringBuffer sb = new StringBuffer(baseName);
                sb.append(";lang-");
                sb.append(localeStr);
                name = sb.toString();
            }
        }
        return name;
    }

    public String getBaseName() {
        String baseName = null;
        baseName = this._name == null ? null : LDAPAttribute.getBaseName((String)this._name);
        return baseName;
    }

    public static String getBaseName(String attrName) {
        return LDAPAttribute.getBaseName((String)attrName);
    }

    public String getValue() {
        String value = null;
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        if (this._stringValues.size() != 0) {
            value = (String)this._stringValues.get(0);
        }
        return value;
    }

    public String[] getStringValues() {
        String[] stringValues = null;
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        int size = this._stringValues.size();
        stringValues = new String[size];
        for (int i = 0; i < size; ++i) {
            stringValues[i] = (String)this._stringValues.get(i);
        }
        return stringValues;
    }

    public boolean contains(String value) {
        boolean contained = false;
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        int size = this._stringValues.size();
        for (int i = 0; i < size; ++i) {
            if (!this._stringValues.get(i).equals(value)) continue;
            contained = true;
            break;
        }
        return contained;
    }

    public byte[] getByteValue() {
        byte[] value = null;
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        if (this._byteValues.size() != 0) {
            value = (byte[])this._byteValues.get(0);
        }
        return value;
    }

    public byte[][] getByteValues() {
        Object byteValues = null;
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        int size = this._byteValues.size();
        byteValues = new byte[size][];
        for (int i = 0; i < size; ++i) {
            byteValues[i] = (byte[])this._byteValues.get(i);
        }
        return byteValues;
    }

    public boolean contains(byte[] value) {
        boolean contained = false;
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        int size = this._byteValues.size();
        for (int i = 0; i < size; ++i) {
            if (!this._byteValues.get(i).equals(value)) continue;
            contained = true;
            break;
        }
        return contained;
    }

    public int size() {
        int size = 0;
        if (this._stringValues != null) {
            size = this._stringValues.size();
        } else if (this._byteValues != null) {
            size = this._byteValues.size();
        } else if (this._ldapAttribute != null) {
            size = this._ldapAttribute.size();
        }
        return size;
    }

    public Object clone() {
        Attr theClone = null;
        try {
            theClone = (Attr)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._stringValues != null) {
            theClone._stringValues = (ArrayList)this._stringValues.clone();
        }
        if (this._byteValues != null) {
            theClone._byteValues = (ArrayList)this._byteValues.clone();
        } else if (this._ldapAttribute != null) {
            theClone._ldapAttribute = this._ldapAttribute;
        }
        return theClone;
    }

    public String toString() {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        return "Name : " + this._name + this._stringValues;
    }

    private void setupStringValues() {
        if (this._ldapAttribute != null) {
            String[] values = this._ldapAttribute.getStringValueArray();
            int size = values.length;
            this._stringValues = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this._stringValues.add(values[i]);
            }
        } else {
            this._stringValues = new ArrayList();
        }
    }

    private void setupByteValues() {
        if (this._ldapAttribute != null) {
            byte[][] values = this._ldapAttribute.getByteValueArray();
            int size = values.length;
            this._byteValues = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this._byteValues.add(values[i]);
            }
        } else {
            this._byteValues = new ArrayList();
        }
    }
}

