/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class I18n {
    public static final String ASCII_CHARSET = "ISO-8859-1";
    private static Map i18nMap = new HashMap();
    private boolean initialized = false;
    private String serviceName = null;
    private String i18nFile = null;
    private ClassLoader ucl = null;
    private Map resourceBundles = new HashMap();

    protected I18n(String serviceName) {
        this.serviceName = new String(serviceName);
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.i18nFile = this.serviceName;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I18n getInstance(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        I18n i18nobj = null;
        Map map = i18nMap;
        synchronized (map) {
            i18nobj = (I18n)i18nMap.get(serviceName);
            if (i18nobj == null) {
                i18nobj = new I18n(serviceName);
                i18nMap.put(serviceName, i18nobj);
            }
        }
        return i18nobj;
    }

    public static Locale getLocale(String stringformat) {
        if (stringformat == null) {
            return Locale.getDefault();
        }
        StringTokenizer tk = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    public String getResBundleName() {
        this.initialize();
        return this.i18nFile;
    }

    private synchronized ResourceBundle getResourceBundle(String stringformat) {
        ResourceBundle bundle = (ResourceBundle)this.resourceBundles.get(stringformat);
        if (bundle == null) {
            bundle = this.ucl != null ? ResourceBundle.getBundle(this.i18nFile, I18n.getLocale(stringformat), this.ucl) : ResourceBundle.getBundle(this.i18nFile, I18n.getLocale(stringformat));
            if (this.initialized) {
                this.resourceBundles.put(stringformat, bundle);
            }
        }
        return bundle;
    }

    private static String getDefaultLocale() {
        String loc = "en_US";
        return loc;
    }

    public String getString(String key, String locale) {
        this.initialize();
        if (key == null) {
            return null;
        }
        ResourceBundle bundle = this.getResourceBundle(locale);
        return bundle.getString(key);
    }

    public String getString(String key) {
        this.initialize();
        if (key == null) {
            return null;
        }
        ResourceBundle bundle = this.getResourceBundle(I18n.getDefaultLocale());
        return bundle.getString(key);
    }

    public String getString(String key, String locale, Object[] params) {
        this.initialize();
        if (key == null) {
            return null;
        }
        return MessageFormat.format(this.getString(key, locale), params);
    }

    public String getString(String key, Object[] params) {
        this.initialize();
        if (key == null) {
            return null;
        }
        return MessageFormat.format(this.getString(key), params);
    }

    public static String decodeCharset(String s, String charset) {
        if (s == null) {
            return null;
        }
        try {
            byte[] buf = s.getBytes(ASCII_CHARSET);
            return new String(buf, 0, buf.length, charset);
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public static boolean isAscii(String s) {
        if (s == null) {
            return true;
        }
        try {
            if (!s.equals(new String(s.getBytes(ASCII_CHARSET), ASCII_CHARSET))) {
                return false;
            }
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        return true;
    }

    private static String format(MessageFormat mf, Object o) {
        String msg = mf.format(new Object[]{o}, new StringBuffer(), (FieldPosition)null).toString();
        return msg;
    }

    public static String format(String pattern, Long j, String l) {
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(I18n.getLocale(l));
        mf.applyPattern(pattern);
        String msg = I18n.format(mf, j);
        return msg;
    }

    public static String format(String pattern, Integer i, String l) {
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(I18n.getLocale(l));
        mf.applyPattern(pattern);
        String msg = I18n.format(mf, i);
        return msg;
    }

    public static String format(String pattern, Date d, TimeZone tz, String l) {
        DateFormat df2;
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(I18n.getLocale(l));
        mf.applyPattern(pattern);
        ((DateFormat)mf.getFormats()[0]).setTimeZone(tz);
        DateFormat df1 = (DateFormat)mf.getFormats()[0];
        if (df1 != null) {
            df1.setTimeZone(tz);
        }
        if ((df2 = (DateFormat)mf.getFormats()[1]) != null) {
            df2.setTimeZone(tz);
        }
        return I18n.format(mf, d);
    }
}

