/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.securid;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.rsa.authagent.authapi.AuthAgentException;
import com.rsa.authagent.authapi.AuthSession;
import com.rsa.authagent.authapi.AuthSessionFactory;
import com.sun.identity.authentication.modules.securid.SecurIDPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.shared.debug.Debug;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class SecurID
extends AMLoginModule {
    private Map sharedState;
    private Map options;
    private String userTokenId = null;
    private String username;
    private SecurIDPrincipal userPrincipal = null;
    private String wtOrgName = "";
    static ResourceBundle bundle = null;
    private static String bundleName = "amAuthSecurID";
    private static Debug debug = null;
    private static Locale locale = null;
    private AuthSessionFactory api = null;
    private AuthSession session = null;
    private static HashMap configDone = new HashMap();
    private final String SDCONF_FILE = "sdconf.rec";
    public String STR_SECURID_CONFIG_PATH = "";
    private String WAIT_PIN = "Wait for the your token to change, then enter with the new PIN. ";
    private String SYS_GEN_PIN = "System generated PIN? (y/n):  ";
    private String ENTER_NEW_PIN = "Enter new PIN, containing ";
    private String NEW_SYS_PIN = "New system PIN:";
    private String READY_SYS_GEN_PIN = "Ready to have the system generate your new PIN? (y/n):";
    private boolean getCredentialsFromSharedState;

    public void init(Subject subject, Map sharedState, Map options) {
        this.session = null;
        try {
            bundle = amCache.getResBundle("amAuthSecurID", this.getLoginLocale());
            if (debug.messageEnabled()) {
                debug.message("SecurID resbundle locale=" + this.getLoginLocale());
            }
            this.options = options;
            this.sharedState = sharedState;
            String thisOrg = this.getRequestOrg();
            if (debug.messageEnabled()) {
                debug.message("SecurID:init:subject = " + subject + "\n\tsharedState = " + sharedState + "\n\toptions = " + options + "\n\torg = " + thisOrg);
            }
            String config_path = Misc.getServerMapAttr(options, "iplanet-am-auth-securid-server-config-path");
            if (!(config_path = config_path.trim()).endsWith("/")) {
                config_path = config_path + "/";
            }
            this.STR_SECURID_CONFIG_PATH = config_path;
            if (debug.messageEnabled()) {
                debug.message("SecurID:init:configpath = " + this.STR_SECURID_CONFIG_PATH);
            }
        }
        catch (Exception e) {
            debug.error("SecurID.init:Error...", (Throwable)e);
        }
    }

    private void setDynamicText(boolean isPswd, int state, String prompt) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("SecurID:setDynamic: isPswd=" + isPswd + ", state=" + state);
        }
        Callback[] callbacks = this.getCallback(state);
        boolean echo = false;
        if (isPswd) {
            echo = ((PasswordCallback)callbacks[0]).isEchoOn();
        }
        if (isPswd) {
            callbacks[0] = new PasswordCallback(prompt, echo);
        } else {
            if (debug.messageEnabled()) {
                debug.message(" prompt=" + prompt);
            }
            callbacks[0] = new NameCallback(prompt);
        }
        this.replaceCallback(state, 0, callbacks[0]);
    }

    private void verifyConfigPath() throws AuthLoginException {
        String filePath = this.STR_SECURID_CONFIG_PATH + "sdconf.rec";
        File f = new File(filePath);
        if (debug.messageEnabled()) {
            debug.message("SecurID:verifyConfigPath:checking Server File Path " + filePath + " for Org " + this.wtOrgName);
        }
        if (!f.exists()) {
            debug.error("SecurID.verifyConfigPath:SecurID Server Path '" + filePath + "' does not exist.  Organization = " + this.wtOrgName);
            throw new AuthLoginException(bundleName, "SecurIDSrvrPathNoExist", null);
        }
        if (debug.messageEnabled()) {
            debug.message("SecurID:verifyConfigPath:found SecurID Server Path = " + filePath + " for Org " + this.wtOrgName);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        rtnval = -1;
        tmp_passcode = null;
        this.wtOrgName = this.getRequestOrg();
        if (SecurID.debug.messageEnabled()) {
            SecurID.debug.message("SecurID:process: Org = " + this.wtOrgName + "\n\tstate = " + state);
        }
        if (!SecurID.configDone.containsKey(this.STR_SECURID_CONFIG_PATH)) {
            this.verifyConfigPath();
            SecurID.configDone.put(this.STR_SECURID_CONFIG_PATH, "true");
        }
        if (this.api == null) {
            SecurID.debug.message("SecurID.process:getting Session instance");
            try {
                this.api = AuthSessionFactory.getInstance((String)this.STR_SECURID_CONFIG_PATH);
            }
            catch (AuthAgentException e) {
                SecurID.debug.error("SecurID.process:Unable to get SecurID API.");
                throw new AuthLoginException(SecurID.bundleName, "SecurIDInitLex", null, e);
            }
        }
        if (SecurID.debug.messageEnabled()) {
            SecurID.debug.message("SecurID:process:after configDone: Org = " + this.wtOrgName + "\n\tstate = " + state + "\n\tconfig_path = " + this.STR_SECURID_CONFIG_PATH + "\n\tuserTokenId = " + this.userTokenId + "\n\tusername = " + this.username);
        }
        newPin = "";
        authStatus = 1;
        pinData = null;
        block33 : switch (state) {
            case 1: {
                if (callbacks != null && callbacks.length == 0) {
                    this.username = (String)this.sharedState.get(this.getUserKey());
                    tmp_passcode = (String)this.sharedState.get(this.getPwdKey());
                    if (this.username == null || tmp_passcode == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    this.username = ((NameCallback)callbacks[0]).getName();
                    if (this.username == null || this.username.length() == 0) {
                        throw new AuthLoginException(SecurID.bundleName, "securIDUserIdNull", null);
                    }
                    tmp_passcode = this.charToString(((PasswordCallback)callbacks[1]).getPassword(), callbacks[1]);
                    if (tmp_passcode == null || tmp_passcode.length() == 0) {
                        throw new AuthLoginException(SecurID.bundleName, "SecurIDPasscodeNull", null);
                    }
                }
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("SecurID.process(): username: " + this.username);
                }
                this.storeUsernamePasswd(this.username, tmp_passcode);
                try {
                    this.session = this.api.createUserSession();
                }
                catch (AuthAgentException aaex) {
                    SecurID.debug.error("SecurID.process:createUserSession() error:" + aaex.getMessage());
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDInitializeLex", new Object[]{aaex.getMessage()});
                }
                try {
                    authStatus = this.session.lock(this.username);
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:session.lock returns = " + authStatus);
                    }
                    authStatus = this.session.check(this.username, tmp_passcode);
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:session.check returns = " + authStatus);
                    }
                    switch (authStatus) {
                        case 0: {
                            SecurID.debug.message("SecurID.process:ACCESS_OK");
                            this.userTokenId = this.username;
                            rtnval = -1;
                            ** break;
                        }
                        case 5: {
                            SecurID.debug.message("SecurID.process:NEW_PIN_REQUIRED");
                            pinData = this.session.getPinData();
                            pinState = pinData.getUserSelectable();
                            pinMin = pinData.getMinPinLength();
                            pinMax = pinData.getMaxPinLength();
                            if (SecurID.debug.messageEnabled()) {
                                SecurID.debug.message("SecurID.process:pinState = " + pinState + "\n\tpinMin = " + pinMin + "\n\tpinMax = " + pinMax);
                            }
                            pinSize = pinMin + " to " + pinMax + " ";
                            v0 = pinType = pinData.isAlphanumeric() != false ? "characters" : "digits";
                            if (pinState == 0) {
                                SecurID.debug.message("SecurID.process:CANNOT_CHOOSE_PIN");
                                newPin = pinData.getSystemPin().trim();
                                if (newPin.length() != 0) {
                                    authStatus = this.session.pin(newPin);
                                    if (SecurID.debug.messageEnabled()) {
                                        SecurID.debug.message("SecurID.process:CCP:pin rtns = " + authStatus);
                                    }
                                    if (authStatus != 6) {
                                        SecurID.debug.error("SecurID.process:CCP:sys pin not accepted!");
                                        if (this.session != null) {
                                            try {
                                                this.session.close();
                                            }
                                            catch (AuthAgentException aax) {
                                                SecurID.debug.error("SecurID.process:NPRCCP:close err = " + aax.getMessage());
                                            }
                                            this.session = null;
                                        }
                                        throw new AuthLoginException(SecurID.bundleName, "SecurIDLoginFailed", new Object[]{this.username});
                                    }
                                } else {
                                    SecurID.debug.message("SecurID.process:CCP:newPin 0-length");
                                    newPin = "";
                                    if (this.session != null) {
                                        try {
                                            this.session.close();
                                        }
                                        catch (AuthAgentException aax) {
                                            SecurID.debug.error("SecurID.process:LSNP:close err = " + aax.getMessage());
                                        }
                                        this.session = null;
                                    }
                                    throw new AuthLoginException(SecurID.bundleName, "SecurIDLoginFailed", new Object[]{this.username});
                                }
                                this.setDynamicText(true, 5, this.WAIT_PIN + this.NEW_SYS_PIN + newPin);
                                rtnval = 5;
                                ** break;
                            }
                            if (pinState == 1) {
                                SecurID.debug.message("SecurID.process:USER_SELECTABLE");
                                this.setDynamicText(false, 4, this.SYS_GEN_PIN);
                                rtnval = 4;
                                ** break;
                            }
                            if (pinState == 2) {
                                SecurID.debug.message("SecurID.process:MUST_CHOOSE_PIN");
                                this.setDynamicText(true, 2, this.ENTER_NEW_PIN + pinSize + pinType);
                                rtnval = 2;
                                if (SecurID.debug.messageEnabled()) {
                                    SecurID.debug.message("SecurID.process:prompt = " + this.ENTER_NEW_PIN + pinSize + pinType);
                                    ** break;
                                }
                                break block33;
                            }
                            SecurID.debug.error("SecurID.process:NEW_PIN_REQUIRED:unknown pinState = " + pinState);
                            if (this.session == null) break block33;
                            try {
                                this.session.close();
                            }
                            catch (AuthAgentException aax) {
                                SecurID.debug.error("SecurID.process:NPRQ:close err = " + aax.getMessage());
                            }
                            this.session = null;
                            this.setFailureID(this.username);
                            throw new AuthLoginException(SecurID.bundleName, "SecurIDLoginFailed", new Object[]{this.username});
                        }
                        case 2: {
                            SecurID.debug.message("SecurID.process:NEXT_CODE_REQUIRED");
                            rtnval = 3;
                            ** break;
                        }
                        case 1: {
                            SecurID.debug.message("SecurID.process:ACCESS_DENIED");
                        }
                        default: {
                            SecurID.debug.message("SecurID.process:state == default");
                            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                                this.getCredentialsFromSharedState = false;
                                rtnval = 1;
                                ** break;
                            }
                            this.setFailureID(this.username);
                            if (this.session != null) {
                                try {
                                    this.session.close();
                                }
                                catch (AuthAgentException aax) {
                                    SecurID.debug.error("SecurID.process:LSAD:close err = " + aax.getMessage());
                                }
                                this.session = null;
                            }
                            throw new AuthLoginException(SecurID.bundleName, "SecurIDLoginFailed", new Object[]{this.username});
lbl146:
                            // 6 sources

                            break block33;
                        }
                    }
                }
                catch (AuthAgentException aaex) {
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:LS:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    SecurID.debug.error("SecurID.process:session lock/check:" + aaex.getMessage());
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDInitializeLex", new Object[]{aaex.getMessage()});
                }
            }
            case 2: {
                SecurID.debug.message("SecurID.process:LOGIN_CHALLENGE");
                newPIN = this.charToString(((PasswordCallback)callbacks[0]).getPassword(), callbacks[0]);
                if (newPIN == null) {
                    newPIN = "";
                }
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("SecurID.process:state2: token length = " + newPIN.length());
                }
                try {
                    if (!newPIN.equals(new String(newPIN.getBytes("ASCII"), "ASCII"))) {
                        if (this.session != null) {
                            try {
                                this.session.close();
                            }
                            catch (AuthAgentException aax) {
                                SecurID.debug.error("SecurID.process:LC:close err = " + aax.getMessage());
                            }
                            this.session = null;
                        }
                        this.setFailureID(this.username);
                        throw new AuthLoginException(SecurID.bundleName, "SecurIDNewPINNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException ueex) {
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:LC2:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDInputEncodingException", null);
                }
                try {
                    authStatus = this.session.pin(newPIN);
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:session.pin returns " + authStatus);
                    }
                    if (authStatus == 6) {
                        SecurID.debug.message("SecurID.process:new pin ACCEPTED");
                        rtnval = 5;
                        this.setDynamicText(true, 5, this.WAIT_PIN);
                        this.userTokenId = this.username;
                        break;
                    }
                    if (authStatus == 7) {
                        SecurID.debug.message("SecurID:process:New PIN specified is invalid.");
                        if (this.session != null) {
                            try {
                                this.session.close();
                            }
                            catch (AuthAgentException aax) {
                                SecurID.debug.error("SecurID.process:LC3:close err = " + aax.getMessage());
                            }
                            this.session = null;
                        }
                        this.setFailureID(this.username);
                        throw new AuthLoginException(SecurID.bundleName, "SecurIDAuthInvNewPin", null);
                    }
                    SecurID.debug.error("SecurID.process:unsure this pin response value.");
                    if (this.session == null) break;
                    try {
                        this.session.close();
                    }
                    catch (AuthAgentException aax) {
                        SecurID.debug.error("SecurID.process:LC4:close err = " + aax.getMessage());
                    }
                    this.session = null;
                    break;
                }
                catch (AuthAgentException aaex) {
                    SecurID.debug.error("SecurID.process:session.pin exception: " + aaex.getMessage());
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:LC5:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDAuthInvNewPin", null);
                }
            }
            case 3: {
                SecurID.debug.message("SecurID.process:LOGIN_NEXT_TOKEN");
                nextToken = this.charToString(((PasswordCallback)callbacks[0]).getPassword(), callbacks[0]);
                if (nextToken == null) {
                    nextToken = "";
                }
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("SecurID.process:LOGIN_NEXT_TOKEN:token length = " + nextToken.length());
                }
                try {
                    if (!nextToken.equals(new String(nextToken.getBytes("ASCII"), "ASCII"))) {
                        this.setFailureID(this.username);
                        if (this.session != null) {
                            try {
                                this.session.close();
                            }
                            catch (AuthAgentException aax) {
                                SecurID.debug.error("SecurID.process:NT:close err = " + aax.getMessage());
                            }
                            this.session = null;
                        }
                        SecurID.debug.error("SecurID.process:LOGIN_NEXT_TOKEN:nextToken not ascii");
                        throw new AuthLoginException(SecurID.bundleName, "SecurIDNextTokenNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException ueex) {
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:NT2:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    this.setFailureID(this.username);
                    SecurID.debug.error("SecurID.process:LOGIN_NEXT_TOKEN:nextToken input encoding");
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDInputEncodingException", null);
                }
                try {
                    authStatus = this.session.next(nextToken);
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:LOGIN_NEXT_TOKEN:next returns " + authStatus);
                    }
                }
                catch (AuthAgentException aaex) {
                    SecurID.debug.error("SecurID.process:LOGIN_NEXT_TOKEN:next() exception:" + aaex.getMessage());
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:NT3:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDInvNextToken", null);
                }
                if (authStatus == 0) {
                    this.userTokenId = this.username;
                    rtnval = -1;
                    break;
                }
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (AuthAgentException aax) {
                        SecurID.debug.error("SecurID.process:NT4:close err = " + aax.getMessage());
                    }
                    this.session = null;
                }
                this.setFailureID(this.username);
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("SecurID.process:LOGIN_NEXT_TOKEN:nextToken failure");
                }
                throw new AuthLoginException(SecurID.bundleName, "SecurIDInvNextToken", null);
            }
            case 4: {
                SecurID.debug.message("SecurID.process:LOGIN_SYS_GEN_PIN");
                answer = ((NameCallback)callbacks[0]).getName();
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("SecurID.process:received answer(state 4) = " + answer);
                }
                sysgenpin = false;
                if (answer == null || answer.length() == 0) {
                    sysgenpin = true;
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:made answer(state 4) = " + sysgenpin);
                    }
                } else if (answer.startsWith("y") || answer.startsWith("Y")) {
                    sysgenpin = true;
                }
                if (sysgenpin) {
                    SecurID.debug.message("SecurID.process:LOGIN_SYS_GEN_PIN:about to getSystemPin");
                    try {
                        pinData = this.session.getPinData();
                        newPin = pinData.getSystemPin();
                        authStatus = this.session.pin(newPin);
                        if (SecurID.debug.messageEnabled()) {
                            SecurID.debug.message("SecurID.process:LSGP:newPin:pin() response = " + authStatus);
                        }
                        this.setDynamicText(true, 5, this.WAIT_PIN + this.NEW_SYS_PIN + newPin);
                        this.userTokenId = this.username;
                        rtnval = 5;
                        break;
                    }
                    catch (AuthAgentException aaex) {
                        SecurID.debug.error("SecurID.process:LSGP:getSystemPin/pin error = " + aaex.getMessage());
                        if (this.session != null) {
                            try {
                                this.session.close();
                            }
                            catch (AuthAgentException aax) {
                                SecurID.debug.error("SecurID.process:SGP:close err = " + aax.getMessage());
                            }
                            this.session = null;
                        }
                        this.setFailureID(this.username);
                        if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                            this.getCredentialsFromSharedState = false;
                            rtnval = 1;
                        }
                        throw new AuthLoginException(SecurID.bundleName, "SecurIDAuthInvNewPin", null);
                    }
                }
                try {
                    pinData = this.session.getPinData();
                    pinMin = pinData.getMinPinLength();
                    pinMax = pinData.getMaxPinLength();
                    pinSize = pinMin + " to " + pinMax + " ";
                    v1 = pinType = pinData.isAlphanumeric() != false ? "characters" : "digits";
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:LOGIN_SYS_GEN_PIN:about to get user-genned PIN, prompt = \n\t" + this.ENTER_NEW_PIN + pinSize + pinType);
                    }
                    this.setDynamicText(true, 2, this.ENTER_NEW_PIN + pinSize + pinType);
                    rtnval = 2;
                    break;
                }
                catch (AuthAgentException aaex) {
                    SecurID.debug.error("SecurID.process:session.getPinData exception: " + aaex.getMessage());
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:UGP:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDAuthInvNewPin", null);
                }
            }
            case 5: {
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("LOGIN_NEW_PIN_NEXT_TOKEN:username = " + this.username);
                }
                if (this.username == null || this.username.length() == 0) {
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDPrevUserid", null);
                }
                nextToken = this.charToString(((PasswordCallback)callbacks[0]).getPassword(), callbacks[0]);
                if (nextToken == null) {
                    nextToken = "";
                }
                try {
                    if (!nextToken.equals(new String(nextToken.getBytes("ASCII"), "ASCII"))) {
                        this.setFailureID(this.username);
                        if (this.session != null) {
                            try {
                                this.session.close();
                            }
                            catch (AuthAgentException aax) {
                                SecurID.debug.error("SecurID.process:NPT:close err = " + aax.getMessage());
                            }
                            this.session = null;
                        }
                        throw new AuthLoginException(SecurID.bundleName, "SecurIDNextTokenNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException ueex) {
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:NPT2:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDInputEncodingException", null);
                }
                SecurID.debug.message("SecurID.process:LNPNT:doing session.check");
                authStatus = 1;
                try {
                    authStatus = this.session.lock(this.username);
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:LNPNT:lock returns " + authStatus);
                    }
                    authStatus = this.session.check(this.username, nextToken);
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:LNPNT:next returns " + authStatus);
                    }
                }
                catch (AuthAgentException aaex) {
                    SecurID.debug.error("SecurID.process:LNPNT:next() gets exception:" + aaex.getMessage());
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (AuthAgentException aax) {
                            SecurID.debug.error("SecurID.process:NPT3:close err = " + aax.getMessage());
                        }
                        this.session = null;
                    }
                    this.setFailureID(this.username);
                    throw new AuthLoginException(SecurID.bundleName, "SecurIDLoginFailed", new Object[]{this.username});
                }
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("SecurID.process:LNPNT:ACCESS_OK = 0, authStatus = " + authStatus);
                }
                if (authStatus == 0) {
                    if (SecurID.debug.messageEnabled()) {
                        SecurID.debug.message("SecurID.process:LNPNT:next() = LOGIN_SUCCEED, username = " + this.username);
                    }
                    this.userTokenId = this.username;
                    rtnval = -1;
                    break;
                }
                if (SecurID.debug.messageEnabled()) {
                    SecurID.debug.message("SecurID.process:LNPNT:next() gets NOT Succeed = " + authStatus);
                }
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (AuthAgentException aax) {
                        SecurID.debug.error("SecurID.process:NPT4:close err = " + aax.getMessage());
                    }
                    this.session = null;
                }
                this.setFailureID(this.username);
                throw new AuthLoginException(SecurID.bundleName, "SecurIDLoginFailed", new Object[]{this.username});
            }
            default: {
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (AuthAgentException aax) {
                        SecurID.debug.error("SecurID.process:DEF:close err = " + aax.getMessage());
                    }
                    this.session = null;
                }
                this.setFailureID(this.username);
                throw new AuthLoginException(SecurID.bundleName, "SecurIDAuth", null);
            }
        }
        if (SecurID.debug.messageEnabled()) {
            SecurID.debug.message("process; after process:\n\tstate = " + state + "\n\tuserTokenId = " + this.userTokenId + "\n\tusername = " + this.username + "\n\trtnval = " + rtnval);
        }
        if (rtnval == -1 && this.session != null) {
            try {
                this.session.close();
            }
            catch (AuthAgentException aax) {
                SecurID.debug.error("SecurID.process:LOGIN_SUCCEED:close err = " + aax.getMessage());
            }
            this.session = null;
        }
        return rtnval;
    }

    private String charToString(char[] tmpPassword, Callback cbk) {
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)cbk).clearPassword();
        return new String(pwd);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            if (debug.messageEnabled()) {
                debug.message("SecurID.getPrincipal:userPrincipal not null; userPrincipal = " + this.userPrincipal);
            }
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new SecurIDPrincipal(this.userTokenId);
            if (debug.messageEnabled()) {
                debug.message("SecurID.getPrincipal: userPrincipal null, userTokenId = " + this.userTokenId + ", returning userPrincipal = " + this.userPrincipal);
            }
            return this.userPrincipal;
        }
        if (debug.messageEnabled()) {
            debug.message("getPrincipal: returning null");
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.sharedState = null;
        this.options = null;
        this.username = null;
        this.wtOrgName = null;
        this.STR_SECURID_CONFIG_PATH = null;
    }

    public void shutdown() {
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance((String)"amAuthSecurID");
        }
    }
}

