/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;

public class AuthLevel {
    String indexName;
    String orgDN;
    private static AuthD ad = AuthD.getAuth();
    private static Debug debug = AuthD.debug;
    int authLevel = 0;
    int numberOfModules = 1;
    Vector modList;
    AuthContext.IndexType indexType = null;
    String clientType = AuthUtils.getDefaultClientType();
    java.util.Locale userLocale;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    ResourceBundle rb = null;
    Map moduleMap = null;

    public AuthLevel(AuthContext.IndexType indexType, String indexName, String orgDN, String clientType, java.util.Locale loc) throws AuthException {
        try {
            debug.message("in auth level constructor");
            this.indexName = indexName;
            this.indexType = indexType;
            this.orgDN = orgDN;
            this.clientType = clientType;
            this.userLocale = loc;
            try {
                this.authLevel = Integer.parseInt(indexName);
            }
            catch (Exception ee) {
                throw new AuthException("119", null);
            }
            if (debug.messageEnabled()) {
                debug.message("indexType : " + indexType);
                debug.message("indexName : " + indexName);
                debug.message("orgDN     : " + orgDN);
                debug.message("clientType: " + clientType);
                debug.message("authLevel : " + this.authLevel);
                debug.message("userLocale: " + this.userLocale);
            }
            this.rb = amCache.getResBundle("amAuth", this.userLocale);
            this.getAuthModulesConfig();
            debug.message("end auth level constructor");
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }

    public void getAuthModulesConfig() {
        Set levelModulesSet = AuthUtils.getAuthModules(this.authLevel, this.orgDN, this.clientType);
        this.modList = new Vector();
        this.moduleMap = new HashMap();
        int i = 0;
        for (String moduleName : levelModulesSet) {
            String localizedName = this.getModuleLocalizedName(moduleName);
            this.moduleMap.put(localizedName, moduleName);
            this.modList.addElement(localizedName);
            ++i;
        }
        this.numberOfModules = i;
    }

    public int getNumberOfAuthModules() {
        return this.numberOfModules;
    }

    public String[] getModuleList() {
        String[] moduleList = new String[this.modList.size()];
        this.modList.copyInto(moduleList);
        return moduleList;
    }

    public String getModuleName() {
        Enumeration vList = this.modList.elements();
        return (String)this.moduleMap.get(vList.nextElement());
    }

    public Callback[] createChoiceCallback() throws AuthException {
        debug.message("In createChoiceCallback");
        String[] moduleList = this.getModuleList();
        Callback[] callbacks = new Callback[1];
        try {
            ChoiceCallback choiceCallback = new ChoiceCallback(Locale.getString((ResourceBundle)this.rb, (String)"modulePrompt", (Debug)debug), moduleList, 0, false);
            callbacks[0] = choiceCallback;
        }
        catch (IllegalArgumentException ie) {
            debug.error("Number of arguments not correct", (Throwable)ie);
            throw new AuthException("callbackError", null);
        }
        catch (Exception e) {
            debug.error("Error: ", (Throwable)e);
            throw new AuthException("callbackError", null);
        }
        if (debug.messageEnabled()) {
            debug.message("Callback is.. :" + callbacks[0]);
        }
        return callbacks;
    }

    protected String getModuleLocalizedName(String moduleName) {
        return Locale.getString((ResourceBundle)this.rb, (String)moduleName, (Debug)debug);
    }

    protected Map getModuleMap() {
        return this.moduleMap;
    }
}

