/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public class RealmDeletePolicy
extends AuthenticatedCommand {
    static final String ARGUMENT_POLICY_NAMES = "policynames";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        ArrayList policyNames = rc.getOption(ARGUMENT_POLICY_NAMES);
        String file = this.getStringOptionValue("file");
        if (policyNames == null) {
            policyNames = new ArrayList();
        }
        if (file != null) {
            policyNames.addAll(AttributeValues.parseValues(file));
        }
        if (policyNames.isEmpty()) {
            throw new CLIException(this.getResourceString("missing-policy-names"), 127);
        }
        IOutput outputWriter = this.getOutputWriter();
        String currentPolicyName = null;
        try {
            PolicyManager pm = new PolicyManager(adminSSOToken, realm);
            String[] params = new String[2];
            params[0] = realm;
            Iterator i = policyNames.iterator();
            while (i.hasNext()) {
                params[1] = currentPolicyName = (String)i.next();
                this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_POLICY_IN_REALM", params);
                pm.removePolicy(currentPolicyName);
                this.writeLog(0, Level.INFO, "SUCCEED_DELETE_POLICY_IN_REALM", params);
            }
            String[] arg = new String[]{realm};
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-policy-in-realm-succeed"), arg));
        }
        catch (PolicyException e) {
            String[] args = new String[]{realm, currentPolicyName, e.getMessage()};
            this.debugError("RealmDeletePolicy.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_POLICY_IN_REALM", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, currentPolicyName, e.getMessage()};
            this.debugError("RealmDeletePolicy.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_POLICY_IN_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

