/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.controller;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.controller.TabController;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Set;

public abstract class TabControllerBase
implements TabController,
ServiceListener {
    protected boolean visible;

    protected void updateStatus() {
        boolean status = false;
        SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMAdminConsoleService", adminSSOToken);
            ServiceSchema schema = mgr.getSchema(SchemaType.GLOBAL);
            AttributeSchema as = schema.getAttributeSchema(this.getConfigAttribute());
            Set defaultValue = as.getDefaultValues();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                String val = (String)defaultValue.iterator().next();
                status = val != null && val.equals("true");
            }
        }
        catch (SMSException e) {
            AMModelBase.debug.error("TabControllerBase.updateStatus", (Throwable)e);
        }
        catch (SSOException e) {
            AMModelBase.debug.error("TabControllerBase.updateStatus", (Throwable)((Object)e));
        }
        this.visible = status;
    }

    protected void addListener() {
        SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMAdminConsoleService", adminSSOToken);
            mgr.addListener(this);
        }
        catch (SMSException e) {
            AMModelBase.debug.error("TabControllerBase.addListener", (Throwable)e);
        }
        catch (SSOException e) {
            AMModelBase.debug.error("TabControllerBase.addListener", (Throwable)((Object)e));
        }
    }

    public void schemaChanged(String serviceName, String version) {
        this.updateStatus();
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    protected abstract String getConfigAttribute();
}

