/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.delegation.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.delegation.model.DelegationModel;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPrivilege;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DelegationModelImpl
extends AMModelBase
implements DelegationModel {
    public DelegationModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getSubjects(String realmName, String pattern) throws AMConsoleException {
        String[] params = new String[]{realmName, pattern};
        this.logEvent("ATTEMPT_GET_DELEGATION_SUBJECTS", params);
        try {
            DelegationManager mgr = new DelegationManager(this.getUserSSOToken(), realmName);
            Set results = mgr.getSubjects(pattern);
            this.logEvent("SUCCEED_GET_DELEGATION_SUBJECTS", params);
            return results != null ? results : Collections.EMPTY_SET;
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, pattern, strError};
            this.logEvent("SSO_EXCEPTION_GET_DELEGATION_SUBJECTS", params);
            debug.error("DelegationModelImpl.getSubjects", (Throwable)((Object)e));
            throw new AMConsoleException(strError);
        }
        catch (DelegationException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, pattern, strError};
            this.logEvent("DELEGATION_EXCEPTION_GET_DELEGATION_SUBJECTS", params);
            debug.error("DelegationModelImpl.getSubjects", (Throwable)e);
            throw new AMConsoleException(strError);
        }
    }

    public Set getPrivileges(String realmName, String uid) throws AMConsoleException {
        String[] params = new String[]{realmName, uid};
        this.logEvent("ATTEMPT_GET_PRIVILEGES_OF_DELEGATION_SUBJECT", params);
        try {
            DelegationManager mgr = new DelegationManager(this.getUserSSOToken(), realmName);
            Set results = mgr.getPrivileges(uid);
            this.logEvent("SUCCEED_GET_PRIVILEGES_OF_DELEGATION_SUBJECT", params);
            return results != null ? results : Collections.EMPTY_SET;
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, uid, strError};
            this.logEvent("SSO_EXCEPTION_GET_PRIVILEGES_OF_DELEGATION_SUBJECT", paramsEx);
            debug.error("DelegationModelImpl.getPrivileges", (Throwable)((Object)e));
            throw new AMConsoleException(strError);
        }
        catch (DelegationException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, uid, strError};
            this.logEvent("DELEGATION_EXCEPTION_GET_PRIVILEGES_OF_DELEGATION_SUBJECT", paramsEx);
            debug.error("DelegationModelImpl.getPrivileges", (Throwable)e);
            throw new AMConsoleException(strError);
        }
    }

    public void setPrivileges(String realmName, String uid, Map privileges) throws AMConsoleException {
        String curPrivilegeName = null;
        try {
            DelegationManager mgr = new DelegationManager(this.getUserSSOToken(), realmName);
            Set privilegeObjects = mgr.getPrivileges();
            String[] params = new String[3];
            params[0] = realmName;
            params[1] = uid;
            for (String name : privileges.keySet()) {
                HashSet<String> subjects;
                String strVal = (String)AMAdminUtils.getValue((Set)privileges.get(name));
                boolean bVal = strVal.equals(Boolean.TRUE.toString());
                params[2] = name;
                curPrivilegeName = name;
                DelegationPrivilege dp = this.getDelegationPrivilege(name, privilegeObjects);
                if (dp != null) {
                    subjects = dp.getSubjects();
                    boolean modified = false;
                    if (bVal) {
                        if (!subjects.contains(uid)) {
                            subjects.add(uid);
                            modified = true;
                        }
                    } else if (subjects.contains(uid)) {
                        subjects.remove(uid);
                        modified = true;
                    }
                    if (!modified) continue;
                    this.logEvent("ATTEMPT_MODIFY_DELEGATION_PRIVILEGE", params);
                    mgr.addPrivilege(dp);
                    this.logEvent("SUCCEED_MODIFY_DELEGATION_PRIVILEGE", params);
                    continue;
                }
                if (!bVal) continue;
                subjects = new HashSet<String>(2);
                subjects.add(uid);
                this.logEvent("ATTEMPT_MODIFY_DELEGATION_PRIVILEGE", params);
                DelegationPrivilege newDp = new DelegationPrivilege(name, subjects, realmName);
                mgr.addPrivilege(newDp);
                this.logEvent("SUCCEED_MODIFY_DELEGATION_PRIVILEGE", params);
            }
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, uid, curPrivilegeName, strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_DELEGATION_PRIVILEGE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (DelegationException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, uid, curPrivilegeName, strError};
            this.logEvent("DELEGATION_EXCEPTION_MODIFY_DELEGATION_PRIVILEGE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private DelegationPrivilege getDelegationPrivilege(String name, Set privilegeObjects) {
        DelegationPrivilege dp = null;
        Iterator i = privilegeObjects.iterator();
        while (i.hasNext() && dp == null) {
            DelegationPrivilege p = (DelegationPrivilege)i.next();
            if (!p.getName().equals(name)) continue;
            dp = p;
        }
        return dp;
    }
}

