/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvaluatorFactory;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.ServiceManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;

public class ProxyPolicyEvaluator {
    private static final String TOP_LEVEL_ADMIN_ROLE = "cn=Top-level Admin Role,";
    private static final String TOP_LEVEL_POLICY_ADMIN_ROLE = "cn=Top-level Policy Admin Role,";
    private static final String ORG_ADMIN_ROLE = "cn=Organization Admin Role,";
    private static final String ORG_POLICY_ADMIN_ROLE = "cn=Organization Policy Admin Role,";
    private SSOToken adminToken;
    private String serviceType;
    private PolicyEvaluator policyEvaluator;
    private static String baseDNString = ServiceManager.getBaseDN();
    private static DN baseDN = new DN(baseDNString);

    ProxyPolicyEvaluator(SSOToken token, String serviceType) throws NoPermissionException, NameNotFoundException, PolicyException, SSOException {
        SSOTokenManager.getInstance().validateToken(token);
        this.adminToken = token;
        this.serviceType = serviceType;
        this.policyEvaluator = PolicyEvaluatorFactory.getInstance().getPolicyEvaluator(token, serviceType);
    }

    public boolean isAllowed(String principalName, String realm, String resourceName, String actionName, Map env) throws PolicyException, SSOException {
        SSOToken token = this.getProxyToken(realm, principalName);
        boolean allowed = this.policyEvaluator.isAllowed(token, resourceName, actionName, env);
        return allowed;
    }

    public boolean isAllowed(String principalName, String resourceName, String actionName, Map env) throws PolicyException, SSOException {
        return this.isAllowed(principalName, null, resourceName, actionName, env);
    }

    public PolicyDecision getPolicyDecision(String principalName, String realm, String resourceName, Map env) throws PolicyException, SSOException {
        String decision;
        SSOToken token = this.getProxyToken(realm, principalName);
        PolicyDecision pd = this.policyEvaluator.getPolicyDecision(token, resourceName, null, env);
        if (PolicyUtils.logStatus && (decision = pd.toString()) != null && decision.length() != 0) {
            String[] objs = new String[]{this.adminToken.getPrincipal().getName(), principalName, resourceName, decision};
            PolicyUtils.logAccessMessage("PROXIED_POLICY_EVALUATION", objs, this.adminToken);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message(" Admin: " + this.adminToken.getPrincipal().getName() + " got policy decision " + " for principal: " + token.getPrincipal().getName() + " for resourceName:" + resourceName + " for serviceType :" + this.serviceType + " is " + pd);
        }
        return pd;
    }

    public PolicyDecision getPolicyDecision(String principalName, String resourceName, Map env) throws PolicyException, SSOException {
        return this.getPolicyDecision(principalName, null, resourceName, env);
    }

    public PolicyDecision getPolicyDecisionIgnoreSubjects(String resourceName, Set actionNames, Map env) throws PolicyException, SSOException {
        String decision;
        PolicyDecision pd = this.policyEvaluator.getPolicyDecisionIgnoreSubjects(resourceName, actionNames, env);
        if (PolicyUtils.logStatus && (decision = pd.toString()) != null && decision.length() != 0) {
            String[] objs = new String[]{this.adminToken.getPrincipal().getName(), resourceName, decision};
            PolicyUtils.logAccessMessage("PROXIED_POLICY_EVALUATION_IGNORING_SUBJECTS", objs, this.adminToken);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message(" Admin: " + this.adminToken.getPrincipal().getName() + " got policy decision " + " ignoring subjects " + " for resourceName:" + resourceName + " for serviceType :" + this.serviceType + " is " + pd);
        }
        return pd;
    }

    public Set getProtectedResourcesIgnoreConditions(String principalName, String rootResource) throws PolicyException, SSOException {
        return this.getProtectedResourcesIgnoreConditions(principalName, null, rootResource);
    }

    public Set getProtectedResourcesIgnoreConditions(String principalName, String realm, String rootResource) throws PolicyException, SSOException {
        SSOToken token = this.getProxyToken(realm, principalName);
        return this.policyEvaluator.getProtectedResourcesIgnoreConditions(token, rootResource);
    }

    private SSOToken getProxyToken(String realm, String principalName) throws PolicyException, SSOException {
        if (realm == null || realm.trim().equals("")) {
            realm = "/";
        }
        SSOTokenManager.getInstance().validateToken(this.adminToken);
        SSOToken token = null;
        boolean proxyPermission = false;
        try {
            String orgDN = DNMapper.orgNameToDN(realm);
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("ProxyPolicyEvaluator.getProxyToken:principalName, orgDN=" + principalName + "," + orgDN);
            }
            AuthContextLocal ac = AuthUtils.getAuthContext(orgDN);
            ac.login(AuthContext.IndexType.USER, principalName, true);
            token = ac.getSSOToken();
        }
        catch (AuthException ae) {
            throw new PolicyException((Throwable)((Object)ae));
        }
        catch (LoginException le) {
            throw new PolicyException(le);
        }
        if (token == null) {
            throw new SSOException(new PolicyException("amPolicy", "can_not_get_proxy_sso_token", null, null));
        }
        try {
            HashSet<String> actionNames = new HashSet<String>();
            actionNames.add("MODIFY");
            DelegationEvaluator de = new DelegationEvaluator();
            DelegationPermission permission = new DelegationPermission("/", "iPlanetAMPolicyService", "1.0", "organization", "default", actionNames, null);
            proxyPermission = de.isAllowed(this.adminToken, permission, null);
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("proxyPermission after delegation check:" + proxyPermission);
            }
            if (!proxyPermission) {
                SSOTokenManager.getInstance().destroyToken(token);
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Admin : " + this.adminToken.getPrincipal().getName() + " can not create proxy sso token for user " + principalName);
                }
                throw new PolicyException("amPolicy", "no_permission_to_create_proxy_sso_token", null, null);
            }
        }
        catch (DelegationException de) {
            throw new PolicyException(de);
        }
        return token;
    }
}

