/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AuthenticatedSharedAgentsCondition
implements Condition,
ServiceListener {
    private Map properties;
    private String delimiter;
    private static List propertyNames = Collections.EMPTY_LIST;
    private static ServiceConfigManager scm = null;
    private static final String version = "1.0";
    private static final String attributeToRead = "AgentsAllowedToRead";
    private static final String agentserviceName = "AgentService";
    private static Map sharedAgentsCache = new HashMap(2);
    private static Map realmCache = new HashMap(2);
    private static Debug debug = Debug.getInstance((String)"AuthAgents");
    static final String RESOURCE_PREFIX = "sms://";
    static final String SVC_RESOURCE_NAME = "/sunIdentityRepositoryService/1.0/application/";

    public AuthenticatedSharedAgentsCondition() {
        block6: {
            this.delimiter = "/";
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                if (scm == null) {
                    scm = new ServiceConfigManager(adminToken, agentserviceName, version);
                }
                if (scm != null) {
                    scm.addListener(this);
                }
            }
            catch (SMSException smse) {
                if (debug.warningEnabled()) {
                    debug.warning("AuthenticatedSharedAgentsCondition: Unable to init scm due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!debug.warningEnabled()) break block6;
                debug.warning("AuthenticatedSharedAgentsCondition: Unable to init scm due to " + (Object)((Object)ssoe));
            }
        }
    }

    public List getPropertyNames() {
        return propertyNames;
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.ANY;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        boolean allowed = false;
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgentsCondition.getConditionDecision: called with Token: " + token.getPrincipal().getName() + ", requestedResourcename: " + env.get("sun.am.requestedOriginalResource"));
        }
        String realmName = null;
        String sharedAgentName = null;
        String sharedAgentUnivId = null;
        try {
            AMIdentity id = IdUtils.getIdentity(token);
            realmName = id.getRealm();
            sharedAgentName = id.getName();
            sharedAgentUnivId = id.getUniversalId();
        }
        catch (SSOException ssoe) {
            if (debug.messageEnabled()) {
                debug.message("AuthenticatedSharedAgentsCondition.getConditionDecision: invalid sso token: " + ssoe.getMessage());
            }
            throw ssoe;
        }
        catch (IdRepoException ide) {
            if (debug.messageEnabled()) {
                debug.message("AuthenticatedSharedAgentsCondition.getConditionDecision IdRepo exception: ", (Throwable)ide);
            }
            throw new PolicyException(ide);
        }
        Object o = env.get("sun.am.requestedOriginalResource");
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgentsCondition.getConditionDecision: name: " + sharedAgentName + " resource: " + o);
        }
        if (o != null) {
            String resourceName = null;
            if (o instanceof String) {
                resourceName = (String)o;
            } else if (o instanceof Set) {
                if (!((Set)o).isEmpty()) {
                    resourceName = (String)((Set)o).iterator().next();
                }
            } else if (debug.warningEnabled()) {
                resourceName = "";
                debug.warning("AuthenticatedSharedAgentsCondition.getConditionDecision: Unable to get resource name");
            }
            try {
                Set<String> agentsFromEnv = new HashSet<String>();
                String agentTypeName = IdType.AGENT.getName();
                String agentOnlyTypeName = IdType.AGENTONLY.getName();
                SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceConfig orgConfig = this.getOrgConfig(adminToken, realmName);
                String[] retVal = this.split(resourceName);
                if (retVal[0].equalsIgnoreCase(agentTypeName) && retVal[1].equalsIgnoreCase(agentTypeName) || retVal[0].equalsIgnoreCase(agentOnlyTypeName) && retVal[1].equalsIgnoreCase(agentOnlyTypeName)) {
                    agentsFromEnv.add(retVal[0]);
                }
                if (!retVal[0].equalsIgnoreCase(agentTypeName) && !retVal[0].equalsIgnoreCase(agentOnlyTypeName)) {
                    retVal[0] = this.getAgentNameFromEnv(resourceName);
                    if (retVal[0].equalsIgnoreCase(sharedAgentName)) {
                        Map envMap = this.getAttributes(orgConfig, retVal[0]);
                        agentsFromEnv = (Set)envMap.get(attributeToRead);
                    } else {
                        agentsFromEnv.add(retVal[0]);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AuthenticatedSharedAgentsCondition.getConditionDecision: agentsFromEnv: " + agentsFromEnv + "retVal[0] " + retVal[0]);
                    }
                }
                if (sharedAgentsCache != null && sharedAgentsCache.containsKey(sharedAgentUnivId)) {
                    Set agentsfromCache = (Set)sharedAgentsCache.get(sharedAgentUnivId);
                    if (agentsfromCache != null && !agentsfromCache.isEmpty()) {
                        allowed = this.getPermission(agentsFromEnv, agentsfromCache);
                    }
                    return new ConditionDecision(allowed);
                }
                Map agentsAttrMap = this.getAttributes(orgConfig, sharedAgentName);
                Set agentsToRead = (Set)agentsAttrMap.get(attributeToRead);
                if (debug.messageEnabled()) {
                    debug.message("AuthenticatedSharedAgentsCondition.getConditionDecision: agentsToRead: " + agentsToRead);
                }
                if (agentsToRead != null && !agentsToRead.isEmpty()) {
                    allowed = this.getPermission(agentsFromEnv, agentsToRead);
                }
                AuthenticatedSharedAgentsCondition.updateCache(sharedAgentUnivId, agentsToRead);
            }
            catch (IdRepoException idpe) {
                debug.error("AuthenticatedSharedAgentsCondition.getConditionDecision(): Unable to read agent attributes for " + sharedAgentName, (Throwable)idpe);
                throw new PolicyException(idpe);
            }
        }
        return new ConditionDecision(allowed);
    }

    private String getAgentNameFromEnv(String resName) {
        String agentName = null;
        String rn = resName.toLowerCase();
        int ndx = rn.indexOf(SVC_RESOURCE_NAME.toLowerCase());
        if (ndx != -1 && (ndx = (rn = rn.substring(ndx + SVC_RESOURCE_NAME.length())).indexOf(47)) != -1) {
            agentName = rn.substring(ndx + 1);
        }
        return agentName;
    }

    public Object clone() {
        AuthenticatedSharedAgentsCondition theClone = null;
        try {
            theClone = (AuthenticatedSharedAgentsCondition)super.clone();
            theClone.properties = Collections.unmodifiableMap(SMSUtils.copyAttributes(this.properties));
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return theClone;
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgentsCondition.globalConfigChanged..");
        }
        AuthenticatedSharedAgentsCondition.clearCache();
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgentsCondition.organizationConfigChanged..");
        }
        AuthenticatedSharedAgentsCondition.clearCache();
    }

    public void schemaChanged(String serviceName, String version) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgentsCondition.schemaChanged..");
        }
        AuthenticatedSharedAgentsCondition.clearCache();
    }

    private Map getAttributes(ServiceConfig svcConfig, String agentName) throws IdRepoException, SSOException, PolicyException {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgentsCondition.getAttributes() called:AgentName- " + agentName);
        }
        Map answer = new HashMap(2);
        try {
            ServiceConfig aCfg = svcConfig.getSubConfig(agentName);
            if (aCfg != null) {
                answer = aCfg.getAttributesForRead();
            }
        }
        catch (SMSException sme) {
            debug.error("AuthenticatedSharedAgentsCondition.getAttributes(): Error occurred while getting " + agentName, (Throwable)sme);
            throw new PolicyException(sme.getMessage());
        }
        return answer;
    }

    private ServiceConfig getOrgConfig(SSOToken token, String realmName) {
        ServiceConfig orgConfigCache;
        block7: {
            if (debug.messageEnabled()) {
                debug.message("AuthenticatedSharedAgentsCondition.getOrgConfig() called. ");
            }
            orgConfigCache = null;
            try {
                if (realmCache != null && !realmCache.isEmpty() && realmCache.containsKey(realmName) && (orgConfigCache = (ServiceConfig)realmCache.get(realmName)).isValid()) {
                    debug.message("AuthenticatedSharedAgentsCondition.getOrgConfig() found in cache.");
                    return orgConfigCache;
                }
                if (scm == null) {
                    scm = new ServiceConfigManager(token, agentserviceName, version);
                }
                orgConfigCache = scm.getOrganizationConfig(realmName, null);
                AuthenticatedSharedAgentsCondition.updateRealmCache(realmName, orgConfigCache);
            }
            catch (SMSException smse) {
                if (debug.warningEnabled()) {
                    debug.warning("AuthenticatedSharedAgentsCondition.getOrgConfig(): Unable to get organization config due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("AuthenticatedSharedAgentsCondition.getOrgConfig(): Unable to get organization config due to " + (Object)((Object)ssoe));
            }
        }
        return orgConfigCache;
    }

    private static void updateCache(String sharedAgentUnivId, Set agentsToRead) {
        HashMap<String, Set> nmap = new HashMap<String, Set>(2);
        nmap.putAll(sharedAgentsCache);
        nmap.put(sharedAgentUnivId, agentsToRead);
        sharedAgentsCache = nmap;
    }

    static void clearCache() {
        sharedAgentsCache = new HashMap(2);
        realmCache = new HashMap(2);
    }

    private static void updateRealmCache(String realmName, ServiceConfig orgConfig) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgents.updateRealmCache: update cache for realm " + realmName);
        }
        HashMap<String, ServiceConfig> rmap = new HashMap<String, ServiceConfig>(2);
        rmap.putAll(realmCache);
        rmap.put(realmName, orgConfig);
        realmCache = rmap;
    }

    private boolean getPermission(Set agentsFromEnv, Set agentsToRead) {
        boolean allowed = false;
        if (agentsFromEnv != null && !agentsFromEnv.isEmpty()) {
            CaseInsensitiveHashSet envValues = new CaseInsensitiveHashSet((Collection)agentsFromEnv);
            if (agentsToRead != null && !agentsToRead.isEmpty()) {
                for (String avName : agentsToRead) {
                    if (envValues == null || !envValues.contains(avName)) continue;
                    allowed = true;
                    if (!debug.messageEnabled()) break;
                    debug.message("AuthenticatedSharedAgentsCondition.getPermission(): returning true.");
                    break;
                }
            }
        }
        if (!allowed && debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgentsCondition.getPermission(): returning false.");
        }
        return allowed;
    }

    public String[] split(String res) {
        StringTokenizer st = new StringTokenizer(res, this.delimiter);
        int n = st.countTokens();
        String[] retVal = new String[n];
        for (int i = 0; i < n; ++i) {
            retVal[n - i - 1] = st.nextToken();
        }
        return retVal;
    }
}

