/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.util;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.ProxyPolicyEvaluator;
import com.sun.identity.policy.ProxyPolicyEvaluatorFactory;
import com.sun.identity.policy.util.AuthServiceConfigInfo;
import com.sun.identity.policy.util.GatewayServletUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessageImpl;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.ServiceConfigManager;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Gateway
extends HttpServlet {
    ServletConfig config = null;
    private static final String GOTO_URL = "goto";
    private static final String LOGIN_URL = "/UI/Login";
    private static final String AUTH_LEVEL_ADVICE = "AuthLevelConditionAdvice";
    private static final String AUTH_SCHEME_ADVICE = "AuthSchemeConditionAdvice";
    private static final String ORG_NAME = "org";
    private static final String AUTH_SCHEME = "module";
    private static final String AUTH_LEVEL = "authlevel";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String ALLOW = "allow";
    private static final String CERT_PROTOCOL = "https://";
    private static final String CERT_SCHEME = "Cert";
    private static final String WEB_AGENT_SERVICE_NAME = "iPlanetAMWebAgentService";
    private static final String CERT_SERVICE_NAME = "iPlanetAMAuthCertService";
    private static Debug debug = Debug.getInstance((String)"amGateway");
    private static AuthD authD;
    private static SSOTokenManager defTokenMgr;
    private static SSOToken defToken;
    private static ProxyPolicyEvaluator pe;
    private static HashMap gwServletUtilsMap;
    private static HashSet authenticators;
    private static Set actionNames;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        try {
            gwServletUtilsMap = new HashMap();
            authD = AuthD.getAuth();
            defToken = authD.getSSOAuthSession();
            defTokenMgr = SSOTokenManager.getInstance();
            Iterator auths = authD.getAuthenticators();
            while (auths.hasNext()) {
                String auth = (String)auths.next();
                authenticators.add(auth);
            }
            this.initGWServletUtilsMap(SMSEntry.getRootSuffix());
            actionNames.add(GET);
            actionNames.add(POST);
            pe = ProxyPolicyEvaluatorFactory.getInstance().getProxyPolicyEvaluator(defToken, WEB_AGENT_SERVICE_NAME);
        }
        catch (Exception e) {
            debug.error("GatewayServlet: Unable to create PolicyEvaluator", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String authScheme = null;
        String authLevel = null;
        String gotoUrl = null;
        ActionDecision ad = null;
        Map advices = null;
        String orgName = null;
        try {
            RequestUtils.checkContentLength(request);
        }
        catch (L10NMessageImpl e) {
            ISLocaleContext localeContext = new ISLocaleContext();
            localeContext.setLocale(request);
            Locale locale = localeContext.getLocale();
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: " + e.getL10NMessage(locale));
            }
            throw new ServletException(e.getL10NMessage(locale));
        }
        StringBuffer forwardUrl = new StringBuffer(200);
        forwardUrl.append(LOGIN_URL);
        String queryString = request.getQueryString();
        Enumeration paramNames = request.getParameterNames();
        while (queryString != null && paramNames.hasMoreElements()) {
            String key = (String)paramNames.nextElement();
            if (key.equalsIgnoreCase(GOTO_URL)) {
                gotoUrl = request.getParameter(key);
                continue;
            }
            if (key.equalsIgnoreCase(AUTH_SCHEME)) {
                authScheme = request.getParameter(key);
                continue;
            }
            if (!key.equalsIgnoreCase(AUTH_LEVEL)) continue;
            authLevel = request.getParameter(key);
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet: queryString : " + queryString);
            debug.message("GatewayServlet: gotoUrl : " + gotoUrl);
        }
        if (gotoUrl != null && (ad = this.getActionDecision(gotoUrl)) != null) {
            advices = ad.getAdvices();
            orgName = this.getOrgNameFromAdvice(advices);
        }
        AuthServiceConfigInfo info = null;
        if (gotoUrl != null && authScheme == null && authLevel == null) {
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: gotoUrl : " + gotoUrl);
            }
            forwardUrl.append('?').append(queryString);
            String advice = this.getPolicyAdvice(ad);
            info = this.getGWServletUtilsFromMap(advices);
            if (advice != null) {
                StringBuffer adv = new StringBuffer();
                int index1 = advice.indexOf("=");
                if (index1 != -1) {
                    adv = adv.append(advice.substring(0, index1 + 1));
                    int index2 = advice.indexOf(":");
                    if (index2 != -1) {
                        orgName = advice.substring(index1 + 1, index2);
                        adv = adv.append(advice.substring(index2 + 1));
                        advice = adv.toString();
                    }
                }
            }
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: advice from getPolicyAdvice(): " + advice);
            }
            if (advice != null && advice.length() > 0) {
                forwardUrl.append('&').append(advice);
            }
        } else if (authScheme != null || authLevel != null) {
            forwardUrl.append('?').append(queryString);
            if (authScheme != null) {
                info = this.getGWServletUtilsByScheme(orgName, authScheme);
            } else if (authLevel != null) {
                info = this.getGWServletUtilsByLevel(orgName, authLevel);
            }
        }
        String fUrl = forwardUrl.toString();
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet >>> Need to change URL !");
            debug.message("OLD URL : " + fUrl);
        }
        if (info != null && info.getPortNumber() != null) {
            fUrl = CERT_PROTOCOL + request.getServerName() + ":" + info.getPortNumber() + SystemProperties.get("com.iplanet.am.services.deploymentDescriptor") + fUrl;
            if (orgName != null && fUrl.indexOf("org=") == -1) {
                fUrl = fUrl + "&" + ORG_NAME + "=" + this.DNtoName(orgName);
            }
            response.sendRedirect(fUrl);
        } else {
            if (orgName != null && fUrl.indexOf("org=") == -1) {
                fUrl = fUrl + "&" + ORG_NAME + "=" + this.DNtoName(orgName);
            }
            RequestDispatcher dispatcher = this.config.getServletContext().getRequestDispatcher(fUrl);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        if (debug.messageEnabled()) {
            debug.message("New URL : " + fUrl);
        }
    }

    String getPolicyAdvice(ActionDecision ad) {
        StringBuffer answer = new StringBuffer(30);
        this.processActionDecision(ad, answer);
        return answer.toString().trim();
    }

    boolean processActionDecision(ActionDecision ad, StringBuffer answer) {
        if (ad == null) {
            return false;
        }
        Set values = ad.getValues();
        if (values.contains(ALLOW)) {
            return true;
        }
        Map advices = ad.getAdvices();
        if (advices != null) {
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: processActionDecision : " + advices.values().toString());
            }
            if (this.appendAdvice(AUTH_SCHEME, (Set)advices.get(AUTH_SCHEME_ADVICE), answer) || this.appendAdvice(AUTH_LEVEL, (Set)advices.get(AUTH_LEVEL_ADVICE), answer)) {
                return true;
            }
        }
        return false;
    }

    boolean appendAdvice(String prefix, Set advices, StringBuffer answer) {
        Iterator items;
        if (advices != null && (items = advices.iterator()).hasNext()) {
            String item = (String)items.next();
            if (answer.length() != 0) {
                answer.append('&');
            }
            answer.append(prefix).append('=').append(item);
            return true;
        }
        return false;
    }

    private GatewayServletUtils initGWServletUtilsMap(String orgName) {
        GatewayServletUtils utils = null;
        OrganizationConfigManager orgConfigMgr = authD.getOrgConfigManager(orgName);
        try {
            Set registeredServices = orgConfigMgr.getAssignedServices();
            for (String service : registeredServices) {
                if (service.trim().indexOf("iPlanetAMAuth") != 0) continue;
                int idx = service.lastIndexOf("Service");
                String module = null;
                if (idx <= "iPlanetAMAuth".length() || !authenticators.contains(module = service.substring("iPlanetAMAuth".length(), idx))) continue;
                utils = this.addGWServletUtilsToMap(orgName, module);
            }
        }
        catch (Exception e) {
            debug.error("Error in GatewayServlet:initGWServletUtilsMap()");
            debug.error("", (Throwable)e);
        }
        return utils;
    }

    private GatewayServletUtils addGWServletUtilsToMap(String orgName, String module) {
        GatewayServletUtils utils = null;
        String authService = AMAuthConfigUtils.getModuleServiceName(module);
        try {
            ServiceConfigManager scm = new ServiceConfigManager(authService, defToken);
            utils = new GatewayServletUtils(scm, module);
            utils.organizationConfigChanged(orgName);
            AuthServiceConfigInfo info = utils.getAuthConfigInfo(orgName);
            if (info != null && info.getPortNumber() != null) {
                scm.addListener(utils);
                gwServletUtilsMap.put(authService, utils);
            } else {
                utils = null;
                gwServletUtilsMap.put(authService, null);
            }
        }
        catch (Exception e) {
            debug.error("GatewayServlet: Unable to add Auth Service Info : " + authService, (Throwable)e);
        }
        return utils;
    }

    private AuthServiceConfigInfo getGWServletUtilsFromMap(Map advices) {
        String orgName = null;
        String module = null;
        String level = null;
        AuthServiceConfigInfo info = null;
        if (advices != null) {
            orgName = this.getOrgNameFromAdvice(advices);
            module = this.getAuthSchemeFromAdvice(advices);
            if (module != null) {
                info = this.getGWServletUtilsByScheme(orgName, module);
            } else {
                level = this.getAuthLevelFromAdvice(advices);
                if (level != null) {
                    info = this.getGWServletUtilsByLevel(orgName, level);
                }
            }
        }
        return info;
    }

    private ActionDecision getActionDecision(String url) {
        ActionDecision ad = null;
        if (pe != null) {
            PolicyDecision pd = null;
            try {
                HashMap envParameters = new HashMap();
                pd = pe.getPolicyDecisionIgnoreSubjects(url, actionNames, envParameters);
            }
            catch (Exception e) {
                debug.error("GatewayServlet: Error in getting policy decision.", (Throwable)e);
                return null;
            }
            Map actionDecisions = pd.getActionDecisions();
            if (actionDecisions != null && (ad = (ActionDecision)actionDecisions.get(GET)) == null) {
                ad = (ActionDecision)actionDecisions.get(POST);
            }
        }
        return ad;
    }

    private String getOrgNameFromAdvice(Map advices) {
        Iterator items;
        Set advice;
        String orgName = null;
        if (advices != null && (advice = (Set)advices.get("AdvicingOrganization")) != null && (items = advice.iterator()).hasNext()) {
            orgName = (String)items.next();
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getOrgName() : " + orgName);
        }
        return orgName;
    }

    private String getAuthSchemeFromAdvice(Map advices) {
        Iterator items;
        String authScheme = null;
        Set advice = (Set)advices.get(AUTH_SCHEME_ADVICE);
        if (advice != null && (items = advice.iterator()).hasNext()) {
            authScheme = (String)items.next();
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getAuthScheme() : " + authScheme);
        }
        return authScheme;
    }

    private String getAuthLevelFromAdvice(Map advices) {
        Iterator items;
        String authLevel = null;
        Set advice = (Set)advices.get(AUTH_LEVEL_ADVICE);
        if (advice != null && (items = advice.iterator()).hasNext()) {
            authLevel = (String)items.next();
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getAuthLevel() : " + authLevel);
        }
        return authLevel;
    }

    private AuthServiceConfigInfo getGWServletUtilsByScheme(String orgName, String scheme) {
        AuthServiceConfigInfo info = null;
        GatewayServletUtils util = null;
        String authService = AMAuthConfigUtils.getModuleServiceName(scheme);
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getGWServletUtilsByScheme()");
            debug.message("OrgName : " + orgName);
            debug.message("Auth Scheme : " + scheme);
        }
        if ((util = (GatewayServletUtils)gwServletUtilsMap.get(authService)) != null) {
            info = util.getAuthConfigInfo(orgName);
        }
        return info;
    }

    private AuthServiceConfigInfo getGWServletUtilsByLevel(String orgName, String level) {
        AuthServiceConfigInfo info = null;
        GatewayServletUtils util = null;
        Set keyset = gwServletUtilsMap.keySet();
        Iterator keys = keyset.iterator();
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getGWServletUtilsByLevel()");
            debug.message("OrgName : " + orgName);
            debug.message("Auth Level : " + level);
            debug.message("No of entries in  GWServletUtilsMap : " + gwServletUtilsMap.size());
        }
        while (keys.hasNext()) {
            String service = (String)keys.next();
            util = (GatewayServletUtils)gwServletUtilsMap.get(service);
            if (util == null || util.getAuthLevel(orgName) == null || !util.getAuthLevel(orgName).equals(level)) continue;
            info = util.getAuthConfigInfo(orgName);
            break;
        }
        return info;
    }

    String DNtoName(String dn) {
        String ret = null;
        int a1 = dn.indexOf("=");
        int i2 = dn.indexOf(",");
        ret = i2 == -1 ? dn.substring(a1 + 1).trim() : dn.substring(a1 + 1, i2).trim();
        return ret;
    }

    static {
        authenticators = new HashSet();
        actionNames = new HashSet();
    }
}

