/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DNUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CachedSubEntries {
    protected static Map smsEntries = Collections.synchronizedMap(new HashMap(100));
    protected Map ssoTokenToSubEntries = new Cache(100);
    private long lastUpdated;
    protected CachedSMSEntry cachedEntry;
    protected String notificationID;
    private static Debug debug = SMSEntry.debug;

    private CachedSubEntries(SSOToken t, String dn) throws SMSException {
        try {
            this.cachedEntry = CachedSMSEntry.getInstance(t, dn);
            this.notificationID = SMSEventListenerManager.notifyChangesToSubNodes(t, dn, this);
        }
        catch (SSOException ssoe) {
            debug.warning("CachedSubEntries::init Invalid SSOToken", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::init: " + dn);
        }
    }

    protected Set getSubEntries(SSOToken t) throws SMSException, SSOException {
        String tokenID = ((Object)t.getTokenID()).toString();
        LinkedHashSet subEntries = (LinkedHashSet)this.ssoTokenToSubEntries.get(tokenID);
        if (subEntries != null && SMSEntry.cacheSMSEntries) {
            if (debug.messageEnabled()) {
                debug.message("CachedSubEntries:getSubEntries Entries from cache: " + subEntries);
            }
            if (CachedSMSEntry.ttlEnabled && System.currentTimeMillis() - this.lastUpdated > CachedSMSEntry.ttl) {
                this.ssoTokenToSubEntries.clear();
            } else {
                return subEntries;
            }
        }
        subEntries = this.getSubEntries(t, "*");
        if (SMSEntry.cacheSMSEntries) {
            LinkedHashSet answer = new LinkedHashSet(subEntries);
            this.ssoTokenToSubEntries.put(tokenID, answer);
            subEntries = answer;
            this.lastUpdated = System.currentTimeMillis();
        }
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries:getSubEntries Entries from DataStore: " + subEntries);
        }
        return subEntries;
    }

    public Set getSubEntries(SSOToken token, String pattern) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.cachedEntry.getDN() + " pattern: " + pattern);
        }
        return this.cachedEntry.getSMSEntry().subEntries(token, pattern, 0, true, true);
    }

    public Set getSchemaSubEntries(SSOToken token, String pattern, String serviceidPattern) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.cachedEntry.getDN() + " pattern: " + serviceidPattern);
        }
        return this.cachedEntry.getSMSEntry().schemaSubEntries(token, pattern, serviceidPattern, 0, true, true);
    }

    protected void add(String entry) {
        this.ssoTokenToSubEntries.clear();
    }

    protected void remove(String entry) {
        this.ssoTokenToSubEntries.clear();
    }

    protected boolean isEmpty(SSOToken t) throws SMSException, SSOException {
        return this.getSubEntries(t).isEmpty();
    }

    protected boolean contains(SSOToken t, String entry) throws SMSException, SSOException {
        return this.getSubEntries(t).contains(entry);
    }

    protected SMSEntry getSMSEntry() {
        if (this.cachedEntry.isDirty()) {
            this.cachedEntry.refresh();
        }
        return this.cachedEntry.getSMSEntry();
    }

    protected void update() {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::update called for dn: " + this.cachedEntry.getDN());
        }
        this.ssoTokenToSubEntries.clear();
    }

    protected void finalize() throws Throwable {
        SMSEventListenerManager.removeNotification(this.notificationID);
    }

    public Set searchSubOrgNames(SSOToken token, String pattern, boolean recursive) throws SMSException, SSOException {
        SMSEntry.validateToken(token);
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading subOrgNames DN: " + this.cachedEntry.getDN() + " pattern: " + pattern);
        }
        return this.cachedEntry.getSMSEntry().searchSubOrgNames(token, pattern, 0, !recursive, !recursive, recursive);
    }

    public Set searchOrgNames(SSOToken token, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        SMSEntry.validateToken(token);
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading orgNames DN: " + this.cachedEntry.getDN() + " attrName: " + attrName);
        }
        return this.cachedEntry.getSMSEntry().searchOrganizationNames(token, 0, true, true, serviceName, attrName, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedSubEntries getInstanceIfCached(SSOToken token, String dn, boolean cached) throws SMSException {
        String entry;
        CachedSubEntries answer;
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::getInstance DN: " + dn);
        }
        if ((answer = (CachedSubEntries)smsEntries.get(entry = DNUtils.normalizeDN(dn))) != null || cached) {
            return answer;
        }
        Map map = smsEntries;
        synchronized (map) {
            answer = (CachedSubEntries)smsEntries.get(entry);
            if (answer == null) {
                answer = new CachedSubEntries(token, dn);
                smsEntries.put(entry, answer);
            }
        }
        return answer;
    }

    public static CachedSubEntries getInstance(SSOToken token, String dn) throws SMSException {
        return CachedSubEntries.getInstanceIfCached(token, dn, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map map = smsEntries;
        synchronized (map) {
            for (CachedSubEntries entry : smsEntries.values()) {
                entry.update();
            }
        }
    }
}

